/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public abstract class AbstractECMultiplier
implements ECMultiplier {
    @Override
    public ECPoint multiply(ECPoint p2, BigInteger k2) {
        int n2 = k2.signum();
        if (n2 == 0 || p2.isInfinity()) {
            return p2.getCurve().getInfinity();
        }
        ECPoint eCPoint = this.multiplyPositive(p2, k2.abs());
        ECPoint eCPoint2 = n2 > 0 ? eCPoint : eCPoint.negate();
        return this.checkResult(eCPoint2);
    }

    protected abstract ECPoint multiplyPositive(ECPoint var1, BigInteger var2);

    protected ECPoint checkResult(ECPoint p2) {
        return ECAlgorithms.a(p2);
    }
}

