/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.PreCompCallback;
import com.enterprisedt.bouncycastle.math.ec.PreCompInfo;
import com.enterprisedt.bouncycastle.math.ec.WTauNafPreCompInfo;
import com.enterprisedt.bouncycastle.math.ec.c;
import com.enterprisedt.bouncycastle.math.ec.e;
import java.math.BigInteger;

public class WTauNafMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint point, BigInteger k2) {
        if (!(point instanceof ECPoint.AbstractF2m)) {
            throw new IllegalArgumentException("Only ECPoint.AbstractF2m can be used in WTauNafMultiplier");
        }
        ECPoint.AbstractF2m abstractF2m = (ECPoint.AbstractF2m)point;
        ECCurve.AbstractF2m abstractF2m2 = (ECCurve.AbstractF2m)abstractF2m.getCurve();
        byte by = abstractF2m2.getA().toBigInteger().byteValue();
        byte by2 = c.a(by);
        e e2 = c.a(abstractF2m2, k2, by, by2, (byte)10);
        return this.a(abstractF2m, e2, by, by2);
    }

    private ECPoint.AbstractF2m a(ECPoint.AbstractF2m abstractF2m, e e2, byte by, byte by2) {
        e[] eArray = by == 0 ? c.a : c.c;
        BigInteger bigInteger = c.a(by2, 4);
        byte[] byArray = c.a(by2, e2, 4, bigInteger.intValue(), eArray);
        return WTauNafMultiplier.a(abstractF2m, byArray);
    }

    private static ECPoint.AbstractF2m a(final ECPoint.AbstractF2m abstractF2m, byte[] byArray) {
        ECCurve.AbstractF2m abstractF2m2 = (ECCurve.AbstractF2m)abstractF2m.getCurve();
        final byte by = abstractF2m2.getA().toBigInteger().byteValue();
        WTauNafPreCompInfo wTauNafPreCompInfo = (WTauNafPreCompInfo)abstractF2m2.precompute(abstractF2m, "bc_wtnaf", new PreCompCallback(){

            @Override
            public PreCompInfo precompute(PreCompInfo existing) {
                if (existing instanceof WTauNafPreCompInfo) {
                    return existing;
                }
                WTauNafPreCompInfo wTauNafPreCompInfo = new WTauNafPreCompInfo();
                wTauNafPreCompInfo.setPreComp(c.a(abstractF2m, by));
                return wTauNafPreCompInfo;
            }
        });
        ECPoint.AbstractF2m[] abstractF2mArray = wTauNafPreCompInfo.getPreComp();
        ECPoint.AbstractF2m[] abstractF2mArray2 = new ECPoint.AbstractF2m[abstractF2mArray.length];
        for (int i2 = 0; i2 < abstractF2mArray.length; ++i2) {
            abstractF2mArray2[i2] = (ECPoint.AbstractF2m)abstractF2mArray[i2].negate();
        }
        ECPoint.AbstractF2m abstractF2m3 = (ECPoint.AbstractF2m)abstractF2m.getCurve().getInfinity();
        int n2 = 0;
        for (int i3 = byArray.length - 1; i3 >= 0; --i3) {
            ++n2;
            byte by2 = byArray[i3];
            if (by2 == 0) continue;
            abstractF2m3 = abstractF2m3.tauPow(n2);
            n2 = 0;
            ECPoint.AbstractF2m abstractF2m4 = by2 > 0 ? abstractF2mArray[by2 >>> 1] : abstractF2mArray2[-by2 >>> 1];
            abstractF2m3 = (ECPoint.AbstractF2m)abstractF2m3.add(abstractF2m4);
        }
        if (n2 > 0) {
            abstractF2m3 = abstractF2m3.tauPow(n2);
        }
        return abstractF2m3;
    }
}

