/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.djb;

import com.enterprisedt.bouncycastle.math.raw.Mod;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class Curve25519Field {
    static final int[] a = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int[] b = new int[]{361, 0, 0, 0, 0, 0, 0, 0, -19, -1, -1, -1, -1, -1, -1, 0x3FFFFFFF};

    public static void add(int[] x, int[] y, int[] z) {
        Nat256.add(x, y, z);
        if (Nat256.gte(z, a)) {
            Curve25519Field.c(z);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        Nat.add(16, xx, yy, zz);
        if (Nat.gte(16, zz, b)) {
            Curve25519Field.d(zz);
        }
    }

    public static void addOne(int[] x, int[] z) {
        Nat.inc(8, x, z);
        if (Nat256.gte(z, a)) {
            Curve25519Field.c(z);
        }
    }

    public static int[] fromBigInteger(BigInteger x) {
        int[] nArray = Nat256.fromBigInteger(x);
        while (Nat256.gte(nArray, a)) {
            Nat256.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x, int[] z) {
        if ((x[0] & 1) == 0) {
            Nat.shiftDownBit(8, x, 0, z);
        } else {
            Nat256.add(x, a, z);
            Nat.shiftDownBit(8, z, 0);
        }
    }

    public static void inv(int[] x, int[] z) {
        Mod.checkedModOddInverse(a, x, z);
    }

    public static int isZero(int[] x) {
        int n2 = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            n2 |= x[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static void multiply(int[] x, int[] y, int[] z) {
        int[] nArray = Nat256.createExt();
        Nat256.mul(x, y, nArray);
        Curve25519Field.reduce(nArray, z);
    }

    public static void multiplyAddToExt(int[] x, int[] y, int[] zz) {
        Nat256.mulAddTo(x, y, zz);
        if (Nat.gte(16, zz, b)) {
            Curve25519Field.d(zz);
        }
    }

    public static void negate(int[] x, int[] z) {
        if (0 != Curve25519Field.isZero(x)) {
            Nat256.sub(a, a, z);
        } else {
            Nat256.sub(a, x, z);
        }
    }

    public static void random(SecureRandom r2, int[] z) {
        byte[] byArray = new byte[32];
        do {
            r2.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, z, 0, 8);
            z[7] = z[7] & Integer.MAX_VALUE;
        } while (0 == Nat.lessThan(8, z, a));
    }

    public static void randomMult(SecureRandom r2, int[] z) {
        do {
            Curve25519Field.random(r2, z);
        } while (0 != Curve25519Field.isZero(z));
    }

    public static void reduce(int[] xx, int[] z) {
        int n2 = xx[7];
        Nat.shiftUpBit(8, xx, 8, n2, z, 0);
        int n3 = Nat256.mulByWordAddTo(19, xx, z) << 1;
        int n4 = z[7];
        n3 += (n4 >>> 31) - (n2 >>> 31);
        n4 &= Integer.MAX_VALUE;
        z[7] = n4 += Nat.addWordTo(7, n3 * 19, z);
        if (Nat256.gte(z, a)) {
            Curve25519Field.c(z);
        }
    }

    public static void reduce27(int x, int[] z) {
        int n2 = z[7];
        int n3 = x << 1 | n2 >>> 31;
        n2 &= Integer.MAX_VALUE;
        z[7] = n2 += Nat.addWordTo(7, n3 * 19, z);
        if (Nat256.gte(z, a)) {
            Curve25519Field.c(z);
        }
    }

    public static void square(int[] x, int[] z) {
        int[] nArray = Nat256.createExt();
        Nat256.square(x, nArray);
        Curve25519Field.reduce(nArray, z);
    }

    public static void squareN(int[] x, int n2, int[] z) {
        int[] nArray = Nat256.createExt();
        Nat256.square(x, nArray);
        Curve25519Field.reduce(nArray, z);
        while (--n2 > 0) {
            Nat256.square(z, nArray);
            Curve25519Field.reduce(nArray, z);
        }
    }

    public static void subtract(int[] x, int[] y, int[] z) {
        int n2 = Nat256.sub(x, y, z);
        if (n2 != 0) {
            Curve25519Field.a(z);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(16, xx, yy, zz);
        if (n2 != 0) {
            Curve25519Field.b(zz);
        }
    }

    public static void twice(int[] x, int[] z) {
        Nat.shiftUpBit(8, x, 0, z);
        if (Nat256.gte(z, a)) {
            Curve25519Field.c(z);
        }
    }

    private static int a(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) - 19L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            l2 = Nat.decAt(7, nArray, 1);
        }
        nArray[7] = (int)(l2 += ((long)nArray[7] & 0xFFFFFFFFL) + 0x80000000L);
        return (int)(l2 >>= 32);
    }

    private static int b(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)b[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            l2 = Nat.incAt(8, nArray, 1);
        }
        nArray[8] = (int)(l2 += ((long)nArray[8] & 0xFFFFFFFFL) - 19L);
        if ((l2 >>= 32) != 0L) {
            l2 = Nat.decAt(15, nArray, 9);
        }
        nArray[15] = (int)(l2 += ((long)nArray[15] & 0xFFFFFFFFL) + ((long)(b[15] + 1) & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    private static int c(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) + 19L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            l2 = Nat.incAt(7, nArray, 1);
        }
        nArray[7] = (int)(l2 += ((long)nArray[7] & 0xFFFFFFFFL) - 0x80000000L);
        return (int)(l2 >>= 32);
    }

    private static int d(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)b[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            l2 = Nat.decAt(8, nArray, 1);
        }
        nArray[8] = (int)(l2 += ((long)nArray[8] & 0xFFFFFFFFL) + 19L);
        if ((l2 >>= 32) != 0L) {
            l2 = Nat.incAt(15, nArray, 9);
        }
        nArray[15] = (int)(l2 += ((long)nArray[15] & 0xFFFFFFFFL) - ((long)(b[15] + 1) & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }
}

