/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.gm;

import com.enterprisedt.bouncycastle.math.raw.Mod;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2P256V1Field {
    static final int[] a = new int[]{-1, -1, 0, -1, -1, -1, -1, -2};
    private static final int[] b = new int[]{1, 0, -2, 1, 1, -2, 0, 2, -2, -3, 3, -2, -1, -1, 0, -2};

    public static void add(int[] x, int[] y, int[] z) {
        int n2 = Nat256.add(x, y, z);
        if (n2 != 0 || z[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(z, a)) {
            SM2P256V1Field.a(z);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(16, xx, yy, zz);
        if (n2 != 0 || zz[15] >>> 1 >= Integer.MAX_VALUE && Nat.gte(16, zz, b)) {
            Nat.subFrom(16, b, zz);
        }
    }

    public static void addOne(int[] x, int[] z) {
        int n2 = Nat.inc(8, x, z);
        if (n2 != 0 || z[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(z, a)) {
            SM2P256V1Field.a(z);
        }
    }

    public static int[] fromBigInteger(BigInteger x) {
        int[] nArray = Nat256.fromBigInteger(x);
        if (nArray[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(nArray, a)) {
            Nat256.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x, int[] z) {
        if ((x[0] & 1) == 0) {
            Nat.shiftDownBit(8, x, 0, z);
        } else {
            int n2 = Nat256.add(x, a, z);
            Nat.shiftDownBit(8, z, n2);
        }
    }

    public static void inv(int[] x, int[] z) {
        Mod.checkedModOddInverse(a, x, z);
    }

    public static int isZero(int[] x) {
        int n2 = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            n2 |= x[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static void multiply(int[] x, int[] y, int[] z) {
        int[] nArray = Nat256.createExt();
        Nat256.mul(x, y, nArray);
        SM2P256V1Field.reduce(nArray, z);
    }

    public static void multiplyAddToExt(int[] x, int[] y, int[] zz) {
        int n2 = Nat256.mulAddTo(x, y, zz);
        if (n2 != 0 || zz[15] >>> 1 >= Integer.MAX_VALUE && Nat.gte(16, zz, b)) {
            Nat.subFrom(16, b, zz);
        }
    }

    public static void negate(int[] x, int[] z) {
        if (0 != SM2P256V1Field.isZero(x)) {
            Nat256.sub(a, a, z);
        } else {
            Nat256.sub(a, x, z);
        }
    }

    public static void random(SecureRandom r2, int[] z) {
        byte[] byArray = new byte[32];
        do {
            r2.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, z, 0, 8);
        } while (0 == Nat.lessThan(8, z, a));
    }

    public static void randomMult(SecureRandom r2, int[] z) {
        do {
            SM2P256V1Field.random(r2, z);
        } while (0 != SM2P256V1Field.isZero(z));
    }

    public static void reduce(int[] xx, int[] z) {
        long l2 = (long)xx[8] & 0xFFFFFFFFL;
        long l3 = (long)xx[9] & 0xFFFFFFFFL;
        long l4 = (long)xx[10] & 0xFFFFFFFFL;
        long l5 = (long)xx[11] & 0xFFFFFFFFL;
        long l6 = (long)xx[12] & 0xFFFFFFFFL;
        long l7 = (long)xx[13] & 0xFFFFFFFFL;
        long l8 = (long)xx[14] & 0xFFFFFFFFL;
        long l9 = (long)xx[15] & 0xFFFFFFFFL;
        long l10 = l2 + l3;
        long l11 = l4 + l5;
        long l12 = l6 + l9;
        long l13 = l7 + l8;
        long l14 = l13 + (l9 << 1);
        long l15 = l10 + l13;
        long l16 = l11 + l12 + l15;
        long l17 = 0L;
        z[0] = (int)(l17 += ((long)xx[0] & 0xFFFFFFFFL) + l16 + l7 + l8 + l9);
        l17 >>= 32;
        z[1] = (int)(l17 += ((long)xx[1] & 0xFFFFFFFFL) + l16 - l2 + l8 + l9);
        l17 >>= 32;
        z[2] = (int)(l17 += ((long)xx[2] & 0xFFFFFFFFL) - l15);
        l17 >>= 32;
        z[3] = (int)(l17 += ((long)xx[3] & 0xFFFFFFFFL) + l16 - l3 - l4 + l7);
        l17 >>= 32;
        z[4] = (int)(l17 += ((long)xx[4] & 0xFFFFFFFFL) + l16 - l11 - l2 + l8);
        l17 >>= 32;
        z[5] = (int)(l17 += ((long)xx[5] & 0xFFFFFFFFL) + l14 + l4);
        l17 >>= 32;
        z[6] = (int)(l17 += ((long)xx[6] & 0xFFFFFFFFL) + l5 + l8 + l9);
        l17 >>= 32;
        z[7] = (int)(l17 += ((long)xx[7] & 0xFFFFFFFFL) + l16 + l14 + l6);
        SM2P256V1Field.reduce32((int)(l17 >>= 32), z);
    }

    public static void reduce32(int x, int[] z) {
        long l2 = 0L;
        if (x != 0) {
            long l3 = (long)x & 0xFFFFFFFFL;
            z[0] = (int)(l2 += ((long)z[0] & 0xFFFFFFFFL) + l3);
            if ((l2 >>= 32) != 0L) {
                z[1] = (int)(l2 += (long)z[1] & 0xFFFFFFFFL);
                l2 >>= 32;
            }
            z[2] = (int)(l2 += ((long)z[2] & 0xFFFFFFFFL) - l3);
            l2 >>= 32;
            z[3] = (int)(l2 += ((long)z[3] & 0xFFFFFFFFL) + l3);
            if ((l2 >>= 32) != 0L) {
                z[4] = (int)(l2 += (long)z[4] & 0xFFFFFFFFL);
                l2 >>= 32;
                z[5] = (int)(l2 += (long)z[5] & 0xFFFFFFFFL);
                l2 >>= 32;
                z[6] = (int)(l2 += (long)z[6] & 0xFFFFFFFFL);
                l2 >>= 32;
            }
            z[7] = (int)(l2 += ((long)z[7] & 0xFFFFFFFFL) + l3);
            l2 >>= 32;
        }
        if (l2 != 0L || z[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(z, a)) {
            SM2P256V1Field.a(z);
        }
    }

    public static void square(int[] x, int[] z) {
        int[] nArray = Nat256.createExt();
        Nat256.square(x, nArray);
        SM2P256V1Field.reduce(nArray, z);
    }

    public static void squareN(int[] x, int n2, int[] z) {
        int[] nArray = Nat256.createExt();
        Nat256.square(x, nArray);
        SM2P256V1Field.reduce(nArray, z);
        while (--n2 > 0) {
            Nat256.square(z, nArray);
            SM2P256V1Field.reduce(nArray, z);
        }
    }

    public static void subtract(int[] x, int[] y, int[] z) {
        int n2 = Nat256.sub(x, y, z);
        if (n2 != 0) {
            SM2P256V1Field.b(z);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(16, xx, yy, zz);
        if (n2 != 0) {
            Nat.addTo(16, b, zz);
        }
    }

    public static void twice(int[] x, int[] z) {
        int n2 = Nat.shiftUpBit(8, x, 0, z);
        if (n2 != 0 || z[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(z, a)) {
            SM2P256V1Field.a(z);
        }
    }

    private static void a(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[2] = (int)(l2 += ((long)nArray[2] & 0xFFFFFFFFL) - 1L);
        l2 >>= 32;
        nArray[3] = (int)(l2 += ((long)nArray[3] & 0xFFFFFFFFL) + 1L);
        if ((l2 >>= 32) != 0L) {
            nArray[4] = (int)(l2 += (long)nArray[4] & 0xFFFFFFFFL);
            l2 >>= 32;
            nArray[5] = (int)(l2 += (long)nArray[5] & 0xFFFFFFFFL);
            l2 >>= 32;
            nArray[6] = (int)(l2 += (long)nArray[6] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[7] = (int)(l2 += ((long)nArray[7] & 0xFFFFFFFFL) + 1L);
    }

    private static void b(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[2] = (int)(l2 += ((long)nArray[2] & 0xFFFFFFFFL) + 1L);
        l2 >>= 32;
        nArray[3] = (int)(l2 += ((long)nArray[3] & 0xFFFFFFFFL) - 1L);
        if ((l2 >>= 32) != 0L) {
            nArray[4] = (int)(l2 += (long)nArray[4] & 0xFFFFFFFFL);
            l2 >>= 32;
            nArray[5] = (int)(l2 += (long)nArray[5] & 0xFFFFFFFFL);
            l2 >>= 32;
            nArray[6] = (int)(l2 += (long)nArray[6] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[7] = (int)(l2 += ((long)nArray[7] & 0xFFFFFFFFL) - 1L);
    }
}

