/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP160K1Point;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP160R2Field;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP160R2FieldElement;
import com.enterprisedt.bouncycastle.math.raw.Nat160;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP160K1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP160R2FieldElement.Q;
    private static final ECFieldElement[] c = new ECFieldElement[]{new SecP160R2FieldElement(ECConstants.ONE)};
    protected SecP160K1Point infinity = new SecP160K1Point(this, null, null);

    public SecP160K1Curve() {
        super(q);
        this.a = this.fromBigInteger(ECConstants.ZERO);
        this.b = this.fromBigInteger(BigInteger.valueOf(7L));
        this.order = new BigInteger(1, Hex.decodeStrict("0100000000000000000001B8FA16DFAB9ACA16B6B3"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP160K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecP160R2FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y) {
        return new SecP160K1Point(this, x, y);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs) {
        return new SecP160K1Point(this, x, y, zs);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int n2 = 5;
        final int[] nArray = new int[len * 5 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 5);
            n3 += 5;
        }
        return new AbstractECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                int[] nArray3 = Nat160.create();
                int[] nArray2 = Nat160.create();
                int n2 = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    int n3 = (i2 ^ index) - 1 >> 31;
                    for (int i3 = 0; i3 < 5; ++i3) {
                        int n4 = i3;
                        nArray3[n4] = nArray3[n4] ^ nArray[n2 + i3] & n3;
                        int n5 = i3;
                        nArray2[n5] = nArray2[n5] ^ nArray[n2 + 5 + i3] & n3;
                    }
                    n2 += 10;
                }
                return this.a(nArray3, nArray2);
            }

            @Override
            public ECPoint lookupVar(int index) {
                int[] nArray3 = Nat160.create();
                int[] nArray2 = Nat160.create();
                int n2 = index * 5 * 2;
                for (int i2 = 0; i2 < 5; ++i2) {
                    nArray3[i2] = nArray[n2 + i2];
                    nArray2[i2] = nArray[n2 + 5 + i2];
                }
                return this.a(nArray3, nArray2);
            }

            private ECPoint a(int[] nArray3, int[] nArray2) {
                return SecP160K1Curve.this.createRawPoint(new SecP160R2FieldElement(nArray3), new SecP160R2FieldElement(nArray2), c);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom r2) {
        int[] nArray = Nat160.create();
        SecP160R2Field.random(r2, nArray);
        return new SecP160R2FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom r2) {
        int[] nArray = Nat160.create();
        SecP160R2Field.randomMult(r2, nArray);
        return new SecP160R2FieldElement(nArray);
    }
}

