/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Mod;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat192;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP192R1Field {
    static final int[] a = new int[]{-1, -1, -2, -1, -1, -1};
    private static final int[] b = new int[]{1, 0, 2, 0, 1, 0, -2, -1, -3, -1, -1, -1};
    private static final int[] c = new int[]{-1, -1, -3, -1, -2, -1, 1, 0, 2};

    public static void add(int[] x, int[] y, int[] z) {
        int n2 = Nat192.add(x, y, z);
        if (n2 != 0 || z[5] == -1 && Nat192.gte(z, a)) {
            SecP192R1Field.a(z);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(12, xx, yy, zz);
        if ((n2 != 0 || zz[11] == -1 && Nat.gte(12, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(12, zz, c.length);
        }
    }

    public static void addOne(int[] x, int[] z) {
        int n2 = Nat.inc(6, x, z);
        if (n2 != 0 || z[5] == -1 && Nat192.gte(z, a)) {
            SecP192R1Field.a(z);
        }
    }

    public static int[] fromBigInteger(BigInteger x) {
        int[] nArray = Nat192.fromBigInteger(x);
        if (nArray[5] == -1 && Nat192.gte(nArray, a)) {
            Nat192.subFrom(a, nArray);
        }
        return nArray;
    }

    public static void half(int[] x, int[] z) {
        if ((x[0] & 1) == 0) {
            Nat.shiftDownBit(6, x, 0, z);
        } else {
            int n2 = Nat192.add(x, a, z);
            Nat.shiftDownBit(6, z, n2);
        }
    }

    public static void inv(int[] x, int[] z) {
        Mod.checkedModOddInverse(a, x, z);
    }

    public static int isZero(int[] x) {
        int n2 = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            n2 |= x[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static void multiply(int[] x, int[] y, int[] z) {
        int[] nArray = Nat192.createExt();
        Nat192.mul(x, y, nArray);
        SecP192R1Field.reduce(nArray, z);
    }

    public static void multiplyAddToExt(int[] x, int[] y, int[] zz) {
        int n2 = Nat192.mulAddTo(x, y, zz);
        if ((n2 != 0 || zz[11] == -1 && Nat.gte(12, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(12, zz, c.length);
        }
    }

    public static void negate(int[] x, int[] z) {
        if (0 != SecP192R1Field.isZero(x)) {
            Nat192.sub(a, a, z);
        } else {
            Nat192.sub(a, x, z);
        }
    }

    public static void random(SecureRandom r2, int[] z) {
        byte[] byArray = new byte[24];
        do {
            r2.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, z, 0, 6);
        } while (0 == Nat.lessThan(6, z, a));
    }

    public static void randomMult(SecureRandom r2, int[] z) {
        do {
            SecP192R1Field.random(r2, z);
        } while (0 != SecP192R1Field.isZero(z));
    }

    public static void reduce(int[] xx, int[] z) {
        long l2 = (long)xx[6] & 0xFFFFFFFFL;
        long l3 = (long)xx[7] & 0xFFFFFFFFL;
        long l4 = (long)xx[8] & 0xFFFFFFFFL;
        long l5 = (long)xx[9] & 0xFFFFFFFFL;
        long l6 = (long)xx[10] & 0xFFFFFFFFL;
        long l7 = (long)xx[11] & 0xFFFFFFFFL;
        long l8 = l2 + l6;
        long l9 = l3 + l7;
        long l10 = 0L;
        int n2 = (int)(l10 += ((long)xx[0] & 0xFFFFFFFFL) + l8);
        l10 >>= 32;
        z[1] = (int)(l10 += ((long)xx[1] & 0xFFFFFFFFL) + l9);
        l10 >>= 32;
        long l11 = (l10 += ((long)xx[2] & 0xFFFFFFFFL) + (l8 += l4)) & 0xFFFFFFFFL;
        l10 >>= 32;
        z[3] = (int)(l10 += ((long)xx[3] & 0xFFFFFFFFL) + (l9 += l5));
        l10 >>= 32;
        z[4] = (int)(l10 += ((long)xx[4] & 0xFFFFFFFFL) + (l8 -= l2));
        l10 >>= 32;
        z[5] = (int)(l10 += ((long)xx[5] & 0xFFFFFFFFL) + (l9 -= l3));
        l11 += (l10 >>= 32);
        z[0] = (int)(l10 += (long)n2 & 0xFFFFFFFFL);
        if ((l10 >>= 32) != 0L) {
            z[1] = (int)(l10 += (long)z[1] & 0xFFFFFFFFL);
            l11 += l10 >> 32;
        }
        z[2] = (int)l11;
        l10 = l11 >> 32;
        if (l10 != 0L && Nat.incAt(6, z, 3) != 0 || z[5] == -1 && Nat192.gte(z, a)) {
            SecP192R1Field.a(z);
        }
    }

    public static void reduce32(int x, int[] z) {
        long l2 = 0L;
        if (x != 0) {
            long l3 = (long)x & 0xFFFFFFFFL;
            z[0] = (int)(l2 += ((long)z[0] & 0xFFFFFFFFL) + l3);
            if ((l2 >>= 32) != 0L) {
                z[1] = (int)(l2 += (long)z[1] & 0xFFFFFFFFL);
                l2 >>= 32;
            }
            z[2] = (int)(l2 += ((long)z[2] & 0xFFFFFFFFL) + l3);
            l2 >>= 32;
        }
        if (l2 != 0L && Nat.incAt(6, z, 3) != 0 || z[5] == -1 && Nat192.gte(z, a)) {
            SecP192R1Field.a(z);
        }
    }

    public static void square(int[] x, int[] z) {
        int[] nArray = Nat192.createExt();
        Nat192.square(x, nArray);
        SecP192R1Field.reduce(nArray, z);
    }

    public static void squareN(int[] x, int n2, int[] z) {
        int[] nArray = Nat192.createExt();
        Nat192.square(x, nArray);
        SecP192R1Field.reduce(nArray, z);
        while (--n2 > 0) {
            Nat192.square(z, nArray);
            SecP192R1Field.reduce(nArray, z);
        }
    }

    public static void subtract(int[] x, int[] y, int[] z) {
        int n2 = Nat192.sub(x, y, z);
        if (n2 != 0) {
            SecP192R1Field.b(z);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(12, xx, yy, zz);
        if (n2 != 0 && Nat.subFrom(c.length, c, zz) != 0) {
            Nat.decAt(12, zz, c.length);
        }
    }

    public static void twice(int[] x, int[] z) {
        int n2 = Nat.shiftUpBit(6, x, 0, z);
        if (n2 != 0 || z[5] == -1 && Nat192.gte(z, a)) {
            SecP192R1Field.a(z);
        }
    }

    private static void a(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[2] = (int)(l2 += ((long)nArray[2] & 0xFFFFFFFFL) + 1L);
        if ((l2 >>= 32) != 0L) {
            Nat.incAt(6, nArray, 3);
        }
    }

    private static void b(int[] nArray) {
        long l2 = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l2;
        if ((l2 >>= 32) != 0L) {
            nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        nArray[2] = (int)(l2 += ((long)nArray[2] & 0xFFFFFFFFL) - 1L);
        if ((l2 >>= 32) != 0L) {
            Nat.decAt(6, nArray, 3);
        }
    }
}

