/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Mod;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat224;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP224K1Field {
    static final int[] a = new int[]{-6803, -2, -1, -1, -1, -1, -1};
    private static final int[] b = new int[]{46280809, 13606, 1, 0, 0, 0, 0, -13606, -3, -1, -1, -1, -1, -1};
    private static final int[] c = new int[]{-46280809, -13607, -2, -1, -1, -1, -1, 13605, 2};

    public static void add(int[] x, int[] y, int[] z) {
        int n2 = Nat224.add(x, y, z);
        if (n2 != 0 || z[6] == -1 && Nat224.gte(z, a)) {
            Nat.add33To(7, 6803, z);
        }
    }

    public static void addExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.add(14, xx, yy, zz);
        if ((n2 != 0 || zz[13] == -1 && Nat.gte(14, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(14, zz, c.length);
        }
    }

    public static void addOne(int[] x, int[] z) {
        int n2 = Nat.inc(7, x, z);
        if (n2 != 0 || z[6] == -1 && Nat224.gte(z, a)) {
            Nat.add33To(7, 6803, z);
        }
    }

    public static int[] fromBigInteger(BigInteger x) {
        int[] nArray = Nat224.fromBigInteger(x);
        if (nArray[6] == -1 && Nat224.gte(nArray, a)) {
            Nat.add33To(7, 6803, nArray);
        }
        return nArray;
    }

    public static void half(int[] x, int[] z) {
        if ((x[0] & 1) == 0) {
            Nat.shiftDownBit(7, x, 0, z);
        } else {
            int n2 = Nat224.add(x, a, z);
            Nat.shiftDownBit(7, z, n2);
        }
    }

    public static void inv(int[] x, int[] z) {
        Mod.checkedModOddInverse(a, x, z);
    }

    public static int isZero(int[] x) {
        int n2 = 0;
        for (int i2 = 0; i2 < 7; ++i2) {
            n2 |= x[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static void multiply(int[] x, int[] y, int[] z) {
        int[] nArray = Nat224.createExt();
        Nat224.mul(x, y, nArray);
        SecP224K1Field.reduce(nArray, z);
    }

    public static void multiplyAddToExt(int[] x, int[] y, int[] zz) {
        int n2 = Nat224.mulAddTo(x, y, zz);
        if ((n2 != 0 || zz[13] == -1 && Nat.gte(14, zz, b)) && Nat.addTo(c.length, c, zz) != 0) {
            Nat.incAt(14, zz, c.length);
        }
    }

    public static void negate(int[] x, int[] z) {
        if (0 != SecP224K1Field.isZero(x)) {
            Nat224.sub(a, a, z);
        } else {
            Nat224.sub(a, x, z);
        }
    }

    public static void random(SecureRandom r2, int[] z) {
        byte[] byArray = new byte[28];
        do {
            r2.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, z, 0, 7);
        } while (0 == Nat.lessThan(7, z, a));
    }

    public static void randomMult(SecureRandom r2, int[] z) {
        do {
            SecP224K1Field.random(r2, z);
        } while (0 != SecP224K1Field.isZero(z));
    }

    public static void reduce(int[] xx, int[] z) {
        long l2 = Nat224.mul33Add(6803, xx, 7, xx, 0, z, 0);
        int n2 = Nat224.mul33DWordAdd(6803, l2, z, 0);
        if (n2 != 0 || z[6] == -1 && Nat224.gte(z, a)) {
            Nat.add33To(7, 6803, z);
        }
    }

    public static void reduce32(int x, int[] z) {
        if (x != 0 && Nat224.mul33WordAdd(6803, x, z, 0) != 0 || z[6] == -1 && Nat224.gte(z, a)) {
            Nat.add33To(7, 6803, z);
        }
    }

    public static void square(int[] x, int[] z) {
        int[] nArray = Nat224.createExt();
        Nat224.square(x, nArray);
        SecP224K1Field.reduce(nArray, z);
    }

    public static void squareN(int[] x, int n2, int[] z) {
        int[] nArray = Nat224.createExt();
        Nat224.square(x, nArray);
        SecP224K1Field.reduce(nArray, z);
        while (--n2 > 0) {
            Nat224.square(z, nArray);
            SecP224K1Field.reduce(nArray, z);
        }
    }

    public static void subtract(int[] x, int[] y, int[] z) {
        int n2 = Nat224.sub(x, y, z);
        if (n2 != 0) {
            Nat.sub33From(7, 6803, z);
        }
    }

    public static void subtractExt(int[] xx, int[] yy, int[] zz) {
        int n2 = Nat.sub(14, xx, yy, zz);
        if (n2 != 0 && Nat.subFrom(c.length, c, zz) != 0) {
            Nat.decAt(14, zz, c.length);
        }
    }

    public static void twice(int[] x, int[] z) {
        int n2 = Nat.shiftUpBit(7, x, 0, z);
        if (n2 != 0 || z[6] == -1 && Nat224.gte(z, a)) {
            Nat.add33To(7, 6803, z);
        }
    }
}

