/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP384R1Field;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP384R1FieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecP384R1Point;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP384R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP384R1FieldElement.Q;
    private static final ECFieldElement[] c = new ECFieldElement[]{new SecP384R1FieldElement(ECConstants.ONE)};
    protected SecP384R1Point infinity = new SecP384R1Point(this, null, null);

    public SecP384R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF")));
        this.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP384R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecP384R1FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y) {
        return new SecP384R1Point(this, x, y);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs) {
        return new SecP384R1Point(this, x, y, zs);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int n2 = 12;
        final int[] nArray = new int[len * 12 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            Nat.copy(12, ((SecP384R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat.copy(12, ((SecP384R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 12);
            n3 += 12;
        }
        return new AbstractECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                int[] nArray3 = Nat.create(12);
                int[] nArray2 = Nat.create(12);
                int n2 = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    int n3 = (i2 ^ index) - 1 >> 31;
                    for (int i3 = 0; i3 < 12; ++i3) {
                        int n4 = i3;
                        nArray3[n4] = nArray3[n4] ^ nArray[n2 + i3] & n3;
                        int n5 = i3;
                        nArray2[n5] = nArray2[n5] ^ nArray[n2 + 12 + i3] & n3;
                    }
                    n2 += 24;
                }
                return this.a(nArray3, nArray2);
            }

            @Override
            public ECPoint lookupVar(int index) {
                int[] nArray3 = Nat.create(12);
                int[] nArray2 = Nat.create(12);
                int n2 = index * 12 * 2;
                for (int i2 = 0; i2 < 12; ++i2) {
                    nArray3[i2] = nArray[n2 + i2];
                    nArray2[i2] = nArray[n2 + 12 + i2];
                }
                return this.a(nArray3, nArray2);
            }

            private ECPoint a(int[] nArray3, int[] nArray2) {
                return SecP384R1Curve.this.createRawPoint(new SecP384R1FieldElement(nArray3), new SecP384R1FieldElement(nArray2), c);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom r2) {
        int[] nArray = Nat.create(12);
        SecP384R1Field.random(r2, nArray);
        return new SecP384R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom r2) {
        int[] nArray = Nat.create(12);
        SecP384R1Field.randomMult(r2, nArray);
        return new SecP384R1FieldElement(nArray);
    }
}

