/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat128;
import java.math.BigInteger;

public class SecT113Field {
    public static void add(long[] x, long[] y, long[] z) {
        z[0] = x[0] ^ y[0];
        z[1] = x[1] ^ y[1];
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        zz[0] = xx[0] ^ yy[0];
        zz[1] = xx[1] ^ yy[1];
        zz[2] = xx[2] ^ yy[2];
        zz[3] = xx[3] ^ yy[3];
    }

    public static void addOne(long[] x, long[] z) {
        z[0] = x[0] ^ 1L;
        z[1] = x[1];
    }

    private static void a(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray2[0] ^ lArray[0];
        lArray2[1] = lArray2[1] ^ lArray[1];
    }

    public static long[] fromBigInteger(BigInteger x) {
        return Nat.fromBigInteger64(113, x);
    }

    public static void halfTrace(long[] x, long[] z) {
        long[] lArray = Nat128.createExt64();
        Nat128.copy64(x, z);
        for (int i2 = 1; i2 < 113; i2 += 2) {
            SecT113Field.implSquare(z, lArray);
            SecT113Field.reduce(lArray, z);
            SecT113Field.implSquare(z, lArray);
            SecT113Field.reduce(lArray, z);
            SecT113Field.a(x, z);
        }
    }

    public static void invert(long[] x, long[] z) {
        if (Nat128.isZero64(x)) {
            throw new IllegalStateException();
        }
        long[] lArray = Nat128.create64();
        long[] lArray2 = Nat128.create64();
        SecT113Field.square(x, lArray);
        SecT113Field.multiply(lArray, x, lArray);
        SecT113Field.square(lArray, lArray);
        SecT113Field.multiply(lArray, x, lArray);
        SecT113Field.squareN(lArray, 3, lArray2);
        SecT113Field.multiply(lArray2, lArray, lArray2);
        SecT113Field.square(lArray2, lArray2);
        SecT113Field.multiply(lArray2, x, lArray2);
        SecT113Field.squareN(lArray2, 7, lArray);
        SecT113Field.multiply(lArray, lArray2, lArray);
        SecT113Field.squareN(lArray, 14, lArray2);
        SecT113Field.multiply(lArray2, lArray, lArray2);
        SecT113Field.squareN(lArray2, 28, lArray);
        SecT113Field.multiply(lArray, lArray2, lArray);
        SecT113Field.squareN(lArray, 56, lArray2);
        SecT113Field.multiply(lArray2, lArray, lArray2);
        SecT113Field.square(lArray2, z);
    }

    public static void multiply(long[] x, long[] y, long[] z) {
        long[] lArray = new long[8];
        SecT113Field.implMultiply(x, y, lArray);
        SecT113Field.reduce(lArray, z);
    }

    public static void multiplyAddToExt(long[] x, long[] y, long[] zz) {
        long[] lArray = new long[8];
        SecT113Field.implMultiply(x, y, lArray);
        SecT113Field.addExt(zz, lArray, zz);
    }

    public static void reduce(long[] xx, long[] z) {
        long l2 = xx[0];
        long l3 = xx[1];
        long l4 = xx[2];
        long l5 = xx[3];
        l3 ^= l5 << 15 ^ l5 << 24;
        long l6 = (l3 ^= l4 >>> 49 ^ l4 >>> 40) >>> 49;
        z[0] = (l2 ^= (l4 ^= l5 >>> 49 ^ l5 >>> 40) << 15 ^ l4 << 24) ^ l6 ^ l6 << 9;
        z[1] = l3 & 0x1FFFFFFFFFFFFL;
    }

    public static void reduce15(long[] z, int zOff) {
        long l2 = z[zOff + 1];
        long l3 = l2 >>> 49;
        int n2 = zOff;
        z[n2] = z[n2] ^ (l3 ^ l3 << 9);
        z[zOff + 1] = l2 & 0x1FFFFFFFFFFFFL;
    }

    public static void sqrt(long[] x, long[] z) {
        long l2 = Interleave.unshuffle(x[0]);
        long l3 = Interleave.unshuffle(x[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l5 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        z[0] = l4 ^ l5 << 57 ^ l5 << 5;
        z[1] = l5 >>> 7 ^ l5 >>> 59;
    }

    public static void square(long[] x, long[] z) {
        long[] lArray = Nat128.createExt64();
        SecT113Field.implSquare(x, lArray);
        SecT113Field.reduce(lArray, z);
    }

    public static void squareAddToExt(long[] x, long[] zz) {
        long[] lArray = Nat128.createExt64();
        SecT113Field.implSquare(x, lArray);
        SecT113Field.addExt(zz, lArray, zz);
    }

    public static void squareN(long[] x, int n2, long[] z) {
        long[] lArray = Nat128.createExt64();
        SecT113Field.implSquare(x, lArray);
        SecT113Field.reduce(lArray, z);
        while (--n2 > 0) {
            SecT113Field.implSquare(z, lArray);
            SecT113Field.reduce(lArray, z);
        }
    }

    public static int trace(long[] x) {
        return (int)x[0] & 1;
    }

    protected static void implMultiply(long[] x, long[] y, long[] zz) {
        long l2 = x[0];
        long l3 = x[1];
        l3 = (l2 >>> 57 ^ l3 << 7) & 0x1FFFFFFFFFFFFFFL;
        l2 &= 0x1FFFFFFFFFFFFFFL;
        long l4 = y[0];
        long l5 = y[1];
        l5 = (l4 >>> 57 ^ l5 << 7) & 0x1FFFFFFFFFFFFFFL;
        long[] lArray = zz;
        long[] lArray2 = new long[6];
        SecT113Field.implMulw(lArray, l2, l4 &= 0x1FFFFFFFFFFFFFFL, lArray2, 0);
        SecT113Field.implMulw(lArray, l3, l5, lArray2, 2);
        SecT113Field.implMulw(lArray, l2 ^ l3, l4 ^ l5, lArray2, 4);
        long l6 = lArray2[1] ^ lArray2[2];
        long l7 = lArray2[0];
        long l8 = lArray2[3];
        long l9 = lArray2[4] ^ l7 ^ l6;
        long l10 = lArray2[5] ^ l8 ^ l6;
        zz[0] = l7 ^ l9 << 57;
        zz[1] = l9 >>> 7 ^ l10 << 50;
        zz[2] = l10 >>> 14 ^ l8 << 43;
        zz[3] = l8 >>> 21;
    }

    protected static void implMulw(long[] u2, long x, long y, long[] z, int zOff) {
        u2[1] = y;
        u2[2] = u2[1] << 1;
        u2[3] = u2[2] ^ y;
        u2[4] = u2[2] << 1;
        u2[5] = u2[4] ^ y;
        u2[6] = u2[3] << 1;
        u2[7] = u2[6] ^ y;
        int n2 = (int)x;
        long l2 = 0L;
        long l3 = u2[n2 & 7];
        int n3 = 48;
        do {
            n2 = (int)(x >>> n3);
            long l4 = u2[n2 & 7] ^ u2[n2 >>> 3 & 7] << 3 ^ u2[n2 >>> 6 & 7] << 6;
            l3 ^= l4 << n3;
            l2 ^= l4 >>> -n3;
        } while ((n3 -= 9) > 0);
        z[zOff] = l3 & 0x1FFFFFFFFFFFFFFL;
        z[zOff + 1] = l3 >>> 57 ^ (l2 ^= (x & 0x100804020100800L & y << 7 >> 63) >>> 8) << 7;
    }

    protected static void implSquare(long[] x, long[] zz) {
        Interleave.expand64To128(x, 0, 2, zz, 0);
    }
}

