/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat192;
import java.math.BigInteger;

public class SecT163Field {
    private static final long[] a = new long[]{-5270498306774157648L, 5270498306774195053L, 0x492492492L};

    public static void add(long[] x, long[] y, long[] z) {
        z[0] = x[0] ^ y[0];
        z[1] = x[1] ^ y[1];
        z[2] = x[2] ^ y[2];
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        zz[0] = xx[0] ^ yy[0];
        zz[1] = xx[1] ^ yy[1];
        zz[2] = xx[2] ^ yy[2];
        zz[3] = xx[3] ^ yy[3];
        zz[4] = xx[4] ^ yy[4];
        zz[5] = xx[5] ^ yy[5];
    }

    public static void addOne(long[] x, long[] z) {
        z[0] = x[0] ^ 1L;
        z[1] = x[1];
        z[2] = x[2];
    }

    private static void a(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray2[0] ^ lArray[0];
        lArray2[1] = lArray2[1] ^ lArray[1];
        lArray2[2] = lArray2[2] ^ lArray[2];
    }

    public static long[] fromBigInteger(BigInteger x) {
        return Nat.fromBigInteger64(163, x);
    }

    public static void halfTrace(long[] x, long[] z) {
        long[] lArray = Nat192.createExt64();
        Nat192.copy64(x, z);
        for (int i2 = 1; i2 < 163; i2 += 2) {
            SecT163Field.implSquare(z, lArray);
            SecT163Field.reduce(lArray, z);
            SecT163Field.implSquare(z, lArray);
            SecT163Field.reduce(lArray, z);
            SecT163Field.a(x, z);
        }
    }

    public static void invert(long[] x, long[] z) {
        if (Nat192.isZero64(x)) {
            throw new IllegalStateException();
        }
        long[] lArray = Nat192.create64();
        long[] lArray2 = Nat192.create64();
        SecT163Field.square(x, lArray);
        SecT163Field.squareN(lArray, 1, lArray2);
        SecT163Field.multiply(lArray, lArray2, lArray);
        SecT163Field.squareN(lArray2, 1, lArray2);
        SecT163Field.multiply(lArray, lArray2, lArray);
        SecT163Field.squareN(lArray, 3, lArray2);
        SecT163Field.multiply(lArray, lArray2, lArray);
        SecT163Field.squareN(lArray2, 3, lArray2);
        SecT163Field.multiply(lArray, lArray2, lArray);
        SecT163Field.squareN(lArray, 9, lArray2);
        SecT163Field.multiply(lArray, lArray2, lArray);
        SecT163Field.squareN(lArray2, 9, lArray2);
        SecT163Field.multiply(lArray, lArray2, lArray);
        SecT163Field.squareN(lArray, 27, lArray2);
        SecT163Field.multiply(lArray, lArray2, lArray);
        SecT163Field.squareN(lArray2, 27, lArray2);
        SecT163Field.multiply(lArray, lArray2, lArray);
        SecT163Field.squareN(lArray, 81, lArray2);
        SecT163Field.multiply(lArray, lArray2, z);
    }

    public static void multiply(long[] x, long[] y, long[] z) {
        long[] lArray = new long[8];
        SecT163Field.implMultiply(x, y, lArray);
        SecT163Field.reduce(lArray, z);
    }

    public static void multiplyAddToExt(long[] x, long[] y, long[] zz) {
        long[] lArray = new long[8];
        SecT163Field.implMultiply(x, y, lArray);
        SecT163Field.addExt(zz, lArray, zz);
    }

    public static void reduce(long[] xx, long[] z) {
        long l2 = xx[0];
        long l3 = xx[1];
        long l4 = xx[2];
        long l5 = xx[3];
        long l6 = xx[4];
        long l7 = xx[5];
        l4 ^= l7 << 29 ^ l7 << 32 ^ l7 << 35 ^ l7 << 36;
        l3 ^= l6 << 29 ^ l6 << 32 ^ l6 << 35 ^ l6 << 36;
        long l8 = (l4 ^= l6 >>> 35 ^ l6 >>> 32 ^ l6 >>> 29 ^ l6 >>> 28) >>> 35;
        z[0] = (l2 ^= (l5 ^= l7 >>> 35 ^ l7 >>> 32 ^ l7 >>> 29 ^ l7 >>> 28) << 29 ^ l5 << 32 ^ l5 << 35 ^ l5 << 36) ^ l8 ^ l8 << 3 ^ l8 << 6 ^ l8 << 7;
        z[1] = l3 ^= l5 >>> 35 ^ l5 >>> 32 ^ l5 >>> 29 ^ l5 >>> 28;
        z[2] = l4 & 0x7FFFFFFFFL;
    }

    public static void reduce29(long[] z, int zOff) {
        long l2 = z[zOff + 2];
        long l3 = l2 >>> 35;
        int n2 = zOff;
        z[n2] = z[n2] ^ (l3 ^ l3 << 3 ^ l3 << 6 ^ l3 << 7);
        z[zOff + 2] = l2 & 0x7FFFFFFFFL;
    }

    public static void sqrt(long[] x, long[] z) {
        long[] lArray = Nat192.create64();
        long l2 = Interleave.unshuffle(x[0]);
        long l3 = Interleave.unshuffle(x[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        lArray[0] = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(x[2]);
        long l5 = l2 & 0xFFFFFFFFL;
        lArray[1] = l2 >>> 32;
        SecT163Field.multiply(lArray, a, z);
        z[0] = z[0] ^ l4;
        z[1] = z[1] ^ l5;
    }

    public static void square(long[] x, long[] z) {
        long[] lArray = Nat192.createExt64();
        SecT163Field.implSquare(x, lArray);
        SecT163Field.reduce(lArray, z);
    }

    public static void squareAddToExt(long[] x, long[] zz) {
        long[] lArray = Nat192.createExt64();
        SecT163Field.implSquare(x, lArray);
        SecT163Field.addExt(zz, lArray, zz);
    }

    public static void squareN(long[] x, int n2, long[] z) {
        long[] lArray = Nat192.createExt64();
        SecT163Field.implSquare(x, lArray);
        SecT163Field.reduce(lArray, z);
        while (--n2 > 0) {
            SecT163Field.implSquare(z, lArray);
            SecT163Field.reduce(lArray, z);
        }
    }

    public static int trace(long[] x) {
        return (int)(x[0] ^ x[2] >>> 29) & 1;
    }

    protected static void implCompactExt(long[] zz) {
        long l2 = zz[0];
        long l3 = zz[1];
        long l4 = zz[2];
        long l5 = zz[3];
        long l6 = zz[4];
        long l7 = zz[5];
        zz[0] = l2 ^ l3 << 55;
        zz[1] = l3 >>> 9 ^ l4 << 46;
        zz[2] = l4 >>> 18 ^ l5 << 37;
        zz[3] = l5 >>> 27 ^ l6 << 28;
        zz[4] = l6 >>> 36 ^ l7 << 19;
        zz[5] = l7 >>> 45;
    }

    protected static void implMultiply(long[] x, long[] y, long[] zz) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = x[2];
        l4 = l3 >>> 46 ^ l4 << 18;
        l3 = (l2 >>> 55 ^ l3 << 9) & 0x7FFFFFFFFFFFFFL;
        l2 &= 0x7FFFFFFFFFFFFFL;
        long l5 = y[0];
        long l6 = y[1];
        long l7 = y[2];
        l7 = l6 >>> 46 ^ l7 << 18;
        l6 = (l5 >>> 55 ^ l6 << 9) & 0x7FFFFFFFFFFFFFL;
        long[] lArray = zz;
        long[] lArray2 = new long[10];
        SecT163Field.implMulw(lArray, l2, l5 &= 0x7FFFFFFFFFFFFFL, lArray2, 0);
        SecT163Field.implMulw(lArray, l4, l7, lArray2, 2);
        long l8 = l2 ^ l3 ^ l4;
        long l9 = l5 ^ l6 ^ l7;
        SecT163Field.implMulw(lArray, l8, l9, lArray2, 4);
        long l10 = l3 << 1 ^ l4 << 2;
        long l11 = l6 << 1 ^ l7 << 2;
        SecT163Field.implMulw(lArray, l2 ^ l10, l5 ^ l11, lArray2, 6);
        SecT163Field.implMulw(lArray, l8 ^ l10, l9 ^ l11, lArray2, 8);
        long l12 = lArray2[6] ^ lArray2[8];
        long l13 = lArray2[7] ^ lArray2[9];
        long l14 = l12 << 1 ^ lArray2[6];
        long l15 = l12 ^ l13 << 1 ^ lArray2[7];
        long l16 = l13;
        long l17 = lArray2[0];
        long l18 = lArray2[1] ^ lArray2[0] ^ lArray2[4];
        long l19 = lArray2[1] ^ lArray2[5];
        long l20 = l17 ^ l14 ^ lArray2[2] << 4 ^ lArray2[2] << 1;
        long l21 = l18 ^ l15 ^ lArray2[3] << 4 ^ lArray2[3] << 1;
        long l22 = l19 ^ l16;
        l21 ^= l20 >>> 55;
        l20 &= 0x7FFFFFFFFFFFFFL;
        l22 ^= l21 >>> 55;
        l20 = l20 >>> 1 ^ ((l21 &= 0x7FFFFFFFFFFFFFL) & 1L) << 54;
        l21 = l21 >>> 1 ^ (l22 & 1L) << 54;
        l22 >>>= 1;
        l20 ^= l20 << 1;
        l20 ^= l20 << 2;
        l20 ^= l20 << 4;
        l20 ^= l20 << 8;
        l20 ^= l20 << 16;
        l20 ^= l20 << 32;
        l21 ^= (l20 &= 0x7FFFFFFFFFFFFFL) >>> 54;
        l21 ^= l21 << 1;
        l21 ^= l21 << 2;
        l21 ^= l21 << 4;
        l21 ^= l21 << 8;
        l21 ^= l21 << 16;
        l21 ^= l21 << 32;
        l22 ^= (l21 &= 0x7FFFFFFFFFFFFFL) >>> 54;
        l22 ^= l22 << 1;
        l22 ^= l22 << 2;
        l22 ^= l22 << 4;
        l22 ^= l22 << 8;
        l22 ^= l22 << 16;
        l22 ^= l22 << 32;
        zz[0] = l17;
        zz[1] = l18 ^ l20 ^ lArray2[2];
        zz[2] = l19 ^ l21 ^ l20 ^ lArray2[3];
        zz[3] = l22 ^ l21;
        zz[4] = l22 ^ lArray2[2];
        zz[5] = lArray2[3];
        SecT163Field.implCompactExt(zz);
    }

    protected static void implMulw(long[] u2, long x, long y, long[] z, int zOff) {
        u2[1] = y;
        u2[2] = u2[1] << 1;
        u2[3] = u2[2] ^ y;
        u2[4] = u2[2] << 1;
        u2[5] = u2[4] ^ y;
        u2[6] = u2[3] << 1;
        u2[7] = u2[6] ^ y;
        int n2 = (int)x;
        long l2 = 0L;
        long l3 = u2[n2 & 3];
        int n3 = 47;
        do {
            n2 = (int)(x >>> n3);
            long l4 = u2[n2 & 7] ^ u2[n2 >>> 3 & 7] << 3 ^ u2[n2 >>> 6 & 7] << 6;
            l3 ^= l4 << n3;
            l2 ^= l4 >>> -n3;
        } while ((n3 -= 9) > 0);
        z[zOff] = l3 & 0x7FFFFFFFFFFFFFL;
        z[zOff + 1] = l3 >>> 55 ^ l2 << 9;
    }

    protected static void implSquare(long[] x, long[] zz) {
        Interleave.expand64To128(x, 0, 3, zz, 0);
    }
}

