/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT193Field;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT193FieldElement
extends ECFieldElement.AbstractF2m {
    protected long[] x;

    public SecT193FieldElement(BigInteger x) {
        if (x == null || x.signum() < 0 || x.bitLength() > 193) {
            throw new IllegalArgumentException("x value invalid for SecT193FieldElement");
        }
        this.x = SecT193Field.fromBigInteger(x);
    }

    public SecT193FieldElement() {
        this.x = Nat256.create64();
    }

    protected SecT193FieldElement(long[] x) {
        this.x = x;
    }

    @Override
    public boolean isOne() {
        return Nat256.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat256.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat256.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT193Field";
    }

    @Override
    public int getFieldSize() {
        return 193;
    }

    @Override
    public ECFieldElement add(ECFieldElement b2) {
        long[] lArray = Nat256.create64();
        SecT193Field.add(this.x, ((SecT193FieldElement)b2).x, lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public ECFieldElement addOne() {
        long[] lArray = Nat256.create64();
        SecT193Field.addOne(this.x, lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement b2) {
        return this.add(b2);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement b2) {
        long[] lArray = Nat256.create64();
        SecT193Field.multiply(this.x, ((SecT193FieldElement)b2).x, lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement b2, ECFieldElement x, ECFieldElement y) {
        return this.multiplyPlusProduct(b2, x, y);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement b2, ECFieldElement x, ECFieldElement y) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT193FieldElement)b2).x;
        long[] lArray3 = ((SecT193FieldElement)x).x;
        long[] lArray4 = ((SecT193FieldElement)y).x;
        long[] lArray5 = Nat256.createExt64();
        SecT193Field.multiplyAddToExt(lArray, lArray2, lArray5);
        SecT193Field.multiplyAddToExt(lArray3, lArray4, lArray5);
        long[] lArray6 = Nat256.create64();
        SecT193Field.reduce(lArray5, lArray6);
        return new SecT193FieldElement(lArray6);
    }

    @Override
    public ECFieldElement divide(ECFieldElement b2) {
        return this.multiply(b2.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        long[] lArray = Nat256.create64();
        SecT193Field.square(this.x, lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement x, ECFieldElement y) {
        return this.squarePlusProduct(x, y);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement x, ECFieldElement y) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT193FieldElement)x).x;
        long[] lArray3 = ((SecT193FieldElement)y).x;
        long[] lArray4 = Nat256.createExt64();
        SecT193Field.squareAddToExt(lArray, lArray4);
        SecT193Field.multiplyAddToExt(lArray2, lArray3, lArray4);
        long[] lArray5 = Nat256.create64();
        SecT193Field.reduce(lArray4, lArray5);
        return new SecT193FieldElement(lArray5);
    }

    @Override
    public ECFieldElement squarePow(int pow) {
        if (pow < 1) {
            return this;
        }
        long[] lArray = Nat256.create64();
        SecT193Field.squareN(this.x, pow, lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public ECFieldElement halfTrace() {
        long[] lArray = Nat256.create64();
        SecT193Field.halfTrace(this.x, lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT193Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        long[] lArray = Nat256.create64();
        SecT193Field.invert(this.x, lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public ECFieldElement sqrt() {
        long[] lArray = Nat256.create64();
        SecT193Field.sqrt(this.x, lArray);
        return new SecT193FieldElement(lArray);
    }

    public int getRepresentation() {
        return 2;
    }

    public int getM() {
        return 193;
    }

    public int getK1() {
        return 15;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SecT193FieldElement)) {
            return false;
        }
        SecT193FieldElement secT193FieldElement = (SecT193FieldElement)other;
        return Nat256.eq64(this.x, secT193FieldElement.x);
    }

    public int hashCode() {
        return 0x1D731F ^ Arrays.hashCode(this.x, 0, 4);
    }
}

