/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat320;
import java.math.BigInteger;

public class SecT283Field {
    private static final long[] a = new long[]{878416384462358536L, 0x30C30C30C30C30C3L, -9076969306111048948L, 0x820820820820820L, 0x2082082L};

    public static void add(long[] x, long[] y, long[] z) {
        z[0] = x[0] ^ y[0];
        z[1] = x[1] ^ y[1];
        z[2] = x[2] ^ y[2];
        z[3] = x[3] ^ y[3];
        z[4] = x[4] ^ y[4];
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        zz[0] = xx[0] ^ yy[0];
        zz[1] = xx[1] ^ yy[1];
        zz[2] = xx[2] ^ yy[2];
        zz[3] = xx[3] ^ yy[3];
        zz[4] = xx[4] ^ yy[4];
        zz[5] = xx[5] ^ yy[5];
        zz[6] = xx[6] ^ yy[6];
        zz[7] = xx[7] ^ yy[7];
        zz[8] = xx[8] ^ yy[8];
    }

    public static void addOne(long[] x, long[] z) {
        z[0] = x[0] ^ 1L;
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
        z[4] = x[4];
    }

    private static void a(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray2[0] ^ lArray[0];
        lArray2[1] = lArray2[1] ^ lArray[1];
        lArray2[2] = lArray2[2] ^ lArray[2];
        lArray2[3] = lArray2[3] ^ lArray[3];
        lArray2[4] = lArray2[4] ^ lArray[4];
    }

    public static long[] fromBigInteger(BigInteger x) {
        return Nat.fromBigInteger64(283, x);
    }

    public static void halfTrace(long[] x, long[] z) {
        long[] lArray = Nat.create64(9);
        Nat320.copy64(x, z);
        for (int i2 = 1; i2 < 283; i2 += 2) {
            SecT283Field.implSquare(z, lArray);
            SecT283Field.reduce(lArray, z);
            SecT283Field.implSquare(z, lArray);
            SecT283Field.reduce(lArray, z);
            SecT283Field.a(x, z);
        }
    }

    public static void invert(long[] x, long[] z) {
        if (Nat320.isZero64(x)) {
            throw new IllegalStateException();
        }
        long[] lArray = Nat320.create64();
        long[] lArray2 = Nat320.create64();
        SecT283Field.square(x, lArray);
        SecT283Field.multiply(lArray, x, lArray);
        SecT283Field.squareN(lArray, 2, lArray2);
        SecT283Field.multiply(lArray2, lArray, lArray2);
        SecT283Field.squareN(lArray2, 4, lArray);
        SecT283Field.multiply(lArray, lArray2, lArray);
        SecT283Field.squareN(lArray, 8, lArray2);
        SecT283Field.multiply(lArray2, lArray, lArray2);
        SecT283Field.square(lArray2, lArray2);
        SecT283Field.multiply(lArray2, x, lArray2);
        SecT283Field.squareN(lArray2, 17, lArray);
        SecT283Field.multiply(lArray, lArray2, lArray);
        SecT283Field.square(lArray, lArray);
        SecT283Field.multiply(lArray, x, lArray);
        SecT283Field.squareN(lArray, 35, lArray2);
        SecT283Field.multiply(lArray2, lArray, lArray2);
        SecT283Field.squareN(lArray2, 70, lArray);
        SecT283Field.multiply(lArray, lArray2, lArray);
        SecT283Field.square(lArray, lArray);
        SecT283Field.multiply(lArray, x, lArray);
        SecT283Field.squareN(lArray, 141, lArray2);
        SecT283Field.multiply(lArray2, lArray, lArray2);
        SecT283Field.square(lArray2, z);
    }

    public static void multiply(long[] x, long[] y, long[] z) {
        long[] lArray = Nat320.createExt64();
        SecT283Field.implMultiply(x, y, lArray);
        SecT283Field.reduce(lArray, z);
    }

    public static void multiplyAddToExt(long[] x, long[] y, long[] zz) {
        long[] lArray = Nat320.createExt64();
        SecT283Field.implMultiply(x, y, lArray);
        SecT283Field.addExt(zz, lArray, zz);
    }

    public static void reduce(long[] xx, long[] z) {
        long l2 = xx[0];
        long l3 = xx[1];
        long l4 = xx[2];
        long l5 = xx[3];
        long l6 = xx[4];
        long l7 = xx[5];
        long l8 = xx[6];
        long l9 = xx[7];
        long l10 = xx[8];
        l5 ^= l10 << 37 ^ l10 << 42 ^ l10 << 44 ^ l10 << 49;
        l4 ^= l9 << 37 ^ l9 << 42 ^ l9 << 44 ^ l9 << 49;
        l5 ^= l9 >>> 27 ^ l9 >>> 22 ^ l9 >>> 20 ^ l9 >>> 15;
        l3 ^= l8 << 37 ^ l8 << 42 ^ l8 << 44 ^ l8 << 49;
        long l11 = (l6 ^= l10 >>> 27 ^ l10 >>> 22 ^ l10 >>> 20 ^ l10 >>> 15) >>> 27;
        z[0] = (l2 ^= l7 << 37 ^ l7 << 42 ^ l7 << 44 ^ l7 << 49) ^ l11 ^ l11 << 5 ^ l11 << 7 ^ l11 << 12;
        z[1] = l3 ^= l7 >>> 27 ^ l7 >>> 22 ^ l7 >>> 20 ^ l7 >>> 15;
        z[2] = l4 ^= l8 >>> 27 ^ l8 >>> 22 ^ l8 >>> 20 ^ l8 >>> 15;
        z[3] = l5;
        z[4] = l6 & 0x7FFFFFFL;
    }

    public static void reduce37(long[] z, int zOff) {
        long l2 = z[zOff + 4];
        long l3 = l2 >>> 27;
        int n2 = zOff;
        z[n2] = z[n2] ^ (l3 ^ l3 << 5 ^ l3 << 7 ^ l3 << 12);
        z[zOff + 4] = l2 & 0x7FFFFFFL;
    }

    public static void sqrt(long[] x, long[] z) {
        long[] lArray = Nat320.create64();
        long l2 = Interleave.unshuffle(x[0]);
        long l3 = Interleave.unshuffle(x[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        lArray[0] = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(x[2]);
        l3 = Interleave.unshuffle(x[3]);
        long l5 = l2 & 0xFFFFFFFFL | l3 << 32;
        lArray[1] = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l2 = Interleave.unshuffle(x[4]);
        long l6 = l2 & 0xFFFFFFFFL;
        lArray[2] = l2 >>> 32;
        SecT283Field.multiply(lArray, a, z);
        z[0] = z[0] ^ l4;
        z[1] = z[1] ^ l5;
        z[2] = z[2] ^ l6;
    }

    public static void square(long[] x, long[] z) {
        long[] lArray = Nat.create64(9);
        SecT283Field.implSquare(x, lArray);
        SecT283Field.reduce(lArray, z);
    }

    public static void squareAddToExt(long[] x, long[] zz) {
        long[] lArray = Nat.create64(9);
        SecT283Field.implSquare(x, lArray);
        SecT283Field.addExt(zz, lArray, zz);
    }

    public static void squareN(long[] x, int n2, long[] z) {
        long[] lArray = Nat.create64(9);
        SecT283Field.implSquare(x, lArray);
        SecT283Field.reduce(lArray, z);
        while (--n2 > 0) {
            SecT283Field.implSquare(z, lArray);
            SecT283Field.reduce(lArray, z);
        }
    }

    public static int trace(long[] x) {
        return (int)(x[0] ^ x[4] >>> 15) & 1;
    }

    protected static void implCompactExt(long[] zz) {
        long l2 = zz[0];
        long l3 = zz[1];
        long l4 = zz[2];
        long l5 = zz[3];
        long l6 = zz[4];
        long l7 = zz[5];
        long l8 = zz[6];
        long l9 = zz[7];
        long l10 = zz[8];
        long l11 = zz[9];
        zz[0] = l2 ^ l3 << 57;
        zz[1] = l3 >>> 7 ^ l4 << 50;
        zz[2] = l4 >>> 14 ^ l5 << 43;
        zz[3] = l5 >>> 21 ^ l6 << 36;
        zz[4] = l6 >>> 28 ^ l7 << 29;
        zz[5] = l7 >>> 35 ^ l8 << 22;
        zz[6] = l8 >>> 42 ^ l9 << 15;
        zz[7] = l9 >>> 49 ^ l10 << 8;
        zz[8] = l10 >>> 56 ^ l11 << 1;
        zz[9] = l11 >>> 63;
    }

    protected static void implExpand(long[] x, long[] z) {
        long l2 = x[0];
        long l3 = x[1];
        long l4 = x[2];
        long l5 = x[3];
        long l6 = x[4];
        z[0] = l2 & 0x1FFFFFFFFFFFFFFL;
        z[1] = (l2 >>> 57 ^ l3 << 7) & 0x1FFFFFFFFFFFFFFL;
        z[2] = (l3 >>> 50 ^ l4 << 14) & 0x1FFFFFFFFFFFFFFL;
        z[3] = (l4 >>> 43 ^ l5 << 21) & 0x1FFFFFFFFFFFFFFL;
        z[4] = l5 >>> 36 ^ l6 << 28;
    }

    protected static void implMultiply(long[] x, long[] y, long[] zz) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        long[] lArray = new long[5];
        long[] lArray2 = new long[5];
        SecT283Field.implExpand(x, lArray);
        SecT283Field.implExpand(y, lArray2);
        long[] lArray3 = zz;
        long[] lArray4 = new long[26];
        SecT283Field.implMulw(lArray3, lArray[0], lArray2[0], lArray4, 0);
        SecT283Field.implMulw(lArray3, lArray[1], lArray2[1], lArray4, 2);
        SecT283Field.implMulw(lArray3, lArray[2], lArray2[2], lArray4, 4);
        SecT283Field.implMulw(lArray3, lArray[3], lArray2[3], lArray4, 6);
        SecT283Field.implMulw(lArray3, lArray[4], lArray2[4], lArray4, 8);
        long l10 = lArray[0] ^ lArray[1];
        long l11 = lArray2[0] ^ lArray2[1];
        long l12 = lArray[0] ^ lArray[2];
        long l13 = lArray2[0] ^ lArray2[2];
        long l14 = lArray[2] ^ lArray[4];
        long l15 = lArray2[2] ^ lArray2[4];
        long l16 = lArray[3] ^ lArray[4];
        long l17 = lArray2[3] ^ lArray2[4];
        SecT283Field.implMulw(lArray3, l12 ^ lArray[3], l13 ^ lArray2[3], lArray4, 18);
        SecT283Field.implMulw(lArray3, l14 ^ lArray[1], l15 ^ lArray2[1], lArray4, 20);
        long l18 = l10 ^ l16;
        long l19 = l11 ^ l17;
        long l20 = l18 ^ lArray[2];
        long l21 = l19 ^ lArray2[2];
        SecT283Field.implMulw(lArray3, l18, l19, lArray4, 22);
        SecT283Field.implMulw(lArray3, l20, l21, lArray4, 24);
        SecT283Field.implMulw(lArray3, l10, l11, lArray4, 10);
        SecT283Field.implMulw(lArray3, l12, l13, lArray4, 12);
        SecT283Field.implMulw(lArray3, l14, l15, lArray4, 14);
        SecT283Field.implMulw(lArray3, l16, l17, lArray4, 16);
        zz[0] = lArray4[0];
        zz[9] = lArray4[9];
        long l22 = lArray4[0] ^ lArray4[1];
        long l23 = l22 ^ lArray4[2];
        zz[1] = l9 = l23 ^ lArray4[10];
        long l24 = lArray4[3] ^ lArray4[4];
        long l25 = lArray4[11] ^ lArray4[12];
        long l26 = l24 ^ l25;
        zz[2] = l8 = l23 ^ l26;
        long l27 = l22 ^ l24;
        long l28 = lArray4[5] ^ lArray4[6];
        long l29 = l27 ^ l28;
        long l30 = l29 ^ lArray4[8];
        long l31 = lArray4[13] ^ lArray4[14];
        long l32 = l30 ^ l31;
        long l33 = lArray4[18] ^ lArray4[22];
        long l34 = l33 ^ lArray4[24];
        zz[3] = l7 = l32 ^ l34;
        long l35 = lArray4[7] ^ lArray4[8];
        long l36 = l35 ^ lArray4[9];
        zz[8] = l6 = l36 ^ lArray4[17];
        long l37 = l36 ^ l28;
        long l38 = lArray4[15] ^ lArray4[16];
        zz[7] = l5 = l37 ^ l38;
        long l39 = l5 ^ l9;
        long l40 = lArray4[19] ^ lArray4[20];
        long l41 = lArray4[25] ^ lArray4[24];
        long l42 = lArray4[18] ^ lArray4[23];
        long l43 = l40 ^ l41;
        long l44 = l43 ^ l42;
        zz[4] = l4 = l44 ^ l39;
        long l45 = l8 ^ l6;
        long l46 = l43 ^ l45;
        long l47 = lArray4[21] ^ lArray4[22];
        zz[5] = l3 = l46 ^ l47;
        long l48 = l30 ^ lArray4[0];
        long l49 = l48 ^ lArray4[9];
        long l50 = l49 ^ l31;
        long l51 = l50 ^ lArray4[21];
        long l52 = l51 ^ lArray4[23];
        zz[6] = l2 = l52 ^ lArray4[25];
        SecT283Field.implCompactExt(zz);
    }

    protected static void implMulw(long[] u2, long x, long y, long[] z, int zOff) {
        u2[1] = y;
        u2[2] = u2[1] << 1;
        u2[3] = u2[2] ^ y;
        u2[4] = u2[2] << 1;
        u2[5] = u2[4] ^ y;
        u2[6] = u2[3] << 1;
        u2[7] = u2[6] ^ y;
        int n2 = (int)x;
        long l2 = 0L;
        long l3 = u2[n2 & 7];
        int n3 = 48;
        do {
            n2 = (int)(x >>> n3);
            long l4 = u2[n2 & 7] ^ u2[n2 >>> 3 & 7] << 3 ^ u2[n2 >>> 6 & 7] << 6;
            l3 ^= l4 << n3;
            l2 ^= l4 >>> -n3;
        } while ((n3 -= 9) > 0);
        z[zOff] = l3 & 0x1FFFFFFFFFFFFFFL;
        z[zOff + 1] = l3 >>> 57 ^ (l2 ^= (x & 0x100804020100800L & y << 7 >> 63) >>> 8) << 7;
    }

    protected static void implSquare(long[] x, long[] zz) {
        Interleave.expand64To128(x, 0, 4, zz, 0);
        zz[8] = Interleave.expand32to64((int)x[4]);
    }
}

