/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT283Field;
import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat320;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class SecT283FieldElement
extends ECFieldElement.AbstractF2m {
    protected long[] x;

    public SecT283FieldElement(BigInteger x) {
        if (x == null || x.signum() < 0 || x.bitLength() > 283) {
            throw new IllegalArgumentException("x value invalid for SecT283FieldElement");
        }
        this.x = SecT283Field.fromBigInteger(x);
    }

    public SecT283FieldElement() {
        this.x = Nat320.create64();
    }

    protected SecT283FieldElement(long[] x) {
        this.x = x;
    }

    @Override
    public boolean isOne() {
        return Nat320.isOne64(this.x);
    }

    @Override
    public boolean isZero() {
        return Nat320.isZero64(this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat320.toBigInteger64(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT283Field";
    }

    @Override
    public int getFieldSize() {
        return 283;
    }

    @Override
    public ECFieldElement add(ECFieldElement b2) {
        long[] lArray = Nat320.create64();
        SecT283Field.add(this.x, ((SecT283FieldElement)b2).x, lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public ECFieldElement addOne() {
        long[] lArray = Nat320.create64();
        SecT283Field.addOne(this.x, lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement b2) {
        return this.add(b2);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement b2) {
        long[] lArray = Nat320.create64();
        SecT283Field.multiply(this.x, ((SecT283FieldElement)b2).x, lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement b2, ECFieldElement x, ECFieldElement y) {
        return this.multiplyPlusProduct(b2, x, y);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement b2, ECFieldElement x, ECFieldElement y) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT283FieldElement)b2).x;
        long[] lArray3 = ((SecT283FieldElement)x).x;
        long[] lArray4 = ((SecT283FieldElement)y).x;
        long[] lArray5 = Nat.create64(9);
        SecT283Field.multiplyAddToExt(lArray, lArray2, lArray5);
        SecT283Field.multiplyAddToExt(lArray3, lArray4, lArray5);
        long[] lArray6 = Nat320.create64();
        SecT283Field.reduce(lArray5, lArray6);
        return new SecT283FieldElement(lArray6);
    }

    @Override
    public ECFieldElement divide(ECFieldElement b2) {
        return this.multiply(b2.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        long[] lArray = Nat320.create64();
        SecT283Field.square(this.x, lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement x, ECFieldElement y) {
        return this.squarePlusProduct(x, y);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement x, ECFieldElement y) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT283FieldElement)x).x;
        long[] lArray3 = ((SecT283FieldElement)y).x;
        long[] lArray4 = Nat.create64(9);
        SecT283Field.squareAddToExt(lArray, lArray4);
        SecT283Field.multiplyAddToExt(lArray2, lArray3, lArray4);
        long[] lArray5 = Nat320.create64();
        SecT283Field.reduce(lArray4, lArray5);
        return new SecT283FieldElement(lArray5);
    }

    @Override
    public ECFieldElement squarePow(int pow) {
        if (pow < 1) {
            return this;
        }
        long[] lArray = Nat320.create64();
        SecT283Field.squareN(this.x, pow, lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public ECFieldElement halfTrace() {
        long[] lArray = Nat320.create64();
        SecT283Field.halfTrace(this.x, lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT283Field.trace(this.x);
    }

    @Override
    public ECFieldElement invert() {
        long[] lArray = Nat320.create64();
        SecT283Field.invert(this.x, lArray);
        return new SecT283FieldElement(lArray);
    }

    @Override
    public ECFieldElement sqrt() {
        long[] lArray = Nat320.create64();
        SecT283Field.sqrt(this.x, lArray);
        return new SecT283FieldElement(lArray);
    }

    public int getRepresentation() {
        return 3;
    }

    public int getM() {
        return 283;
    }

    public int getK1() {
        return 5;
    }

    public int getK2() {
        return 7;
    }

    public int getK3() {
        return 12;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SecT283FieldElement)) {
            return false;
        }
        SecT283FieldElement secT283FieldElement = (SecT283FieldElement)other;
        return Nat320.eq64(this.x, secT283FieldElement.x);
    }

    public int hashCode() {
        return 0x2B33AB ^ Arrays.hashCode(this.x, 0, 5);
    }
}

