/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.custom.sec;

import com.enterprisedt.bouncycastle.math.ec.AbstractECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECLookupTable;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT571FieldElement;
import com.enterprisedt.bouncycastle.math.ec.custom.sec.SecT571R1Point;
import com.enterprisedt.bouncycastle.math.raw.Nat576;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT571R1Curve
extends ECCurve.AbstractF2m {
    private static final ECFieldElement[] e = new ECFieldElement[]{new SecT571FieldElement(ECConstants.ONE)};
    protected SecT571R1Point infinity = new SecT571R1Point(this, null, null);
    static final SecT571FieldElement c = new SecT571FieldElement(new BigInteger(1, Hex.decodeStrict("02F40E7E2221F295DE297117B7F3D62F5C6A97FFCB8CEFF1CD6BA8CE4A9A18AD84FFABBD8EFA59332BE7AD6756A66E294AFD185A78FF12AA520E4DE739BACA0C7FFEFF7F2955727A")));
    static final SecT571FieldElement d = (SecT571FieldElement)c.sqrt();

    public SecT571R1Curve() {
        super(571, 2, 5, 10);
        this.a = this.fromBigInteger(BigInteger.valueOf(1L));
        this.b = c;
        this.order = new BigInteger(1, Hex.decodeStrict("03FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE661CE18FF55987308059B186823851EC7DD9CA1161DE93D5174D66E8382E9BB2FE84E47"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT571R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getFieldSize() {
        return 571;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT571FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y) {
        return new SecT571R1Point(this, x, y);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs) {
        return new SecT571R1Point(this, x, y, zs);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 571;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 5;
    }

    public int getK3() {
        return 10;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int n2 = 9;
        final long[] lArray = new long[len * 9 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            ECPoint eCPoint = points[off + i2];
            Nat576.copy64(((SecT571FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n3);
            Nat576.copy64(((SecT571FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n3 += 9);
            n3 += 9;
        }
        return new AbstractECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                long[] lArray3 = Nat576.create64();
                long[] lArray2 = Nat576.create64();
                int n2 = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    long l2 = (i2 ^ index) - 1 >> 31;
                    for (int i3 = 0; i3 < 9; ++i3) {
                        int n3 = i3;
                        lArray3[n3] = lArray3[n3] ^ lArray[n2 + i3] & l2;
                        int n4 = i3;
                        lArray2[n4] = lArray2[n4] ^ lArray[n2 + 9 + i3] & l2;
                    }
                    n2 += 18;
                }
                return this.a(lArray3, lArray2);
            }

            @Override
            public ECPoint lookupVar(int index) {
                long[] lArray3 = Nat576.create64();
                long[] lArray2 = Nat576.create64();
                int n2 = index * 9 * 2;
                for (int i2 = 0; i2 < 9; ++i2) {
                    lArray3[i2] = lArray[n2 + i2];
                    lArray2[i2] = lArray[n2 + 9 + i2];
                }
                return this.a(lArray3, lArray2);
            }

            private ECPoint a(long[] lArray3, long[] lArray2) {
                return SecT571R1Curve.this.createRawPoint(new SecT571FieldElement(lArray3), new SecT571FieldElement(lArray2), e);
            }
        };
    }
}

