/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.endo;

import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.PreCompCallback;
import com.enterprisedt.bouncycastle.math.ec.PreCompInfo;
import com.enterprisedt.bouncycastle.math.ec.endo.ECEndomorphism;
import com.enterprisedt.bouncycastle.math.ec.endo.EndoPreCompInfo;
import com.enterprisedt.bouncycastle.math.ec.endo.ScalarSplitParameters;
import java.math.BigInteger;

public abstract class EndoUtil {
    public static final String PRECOMP_NAME = "bc_endo";

    public static BigInteger[] decomposeScalar(ScalarSplitParameters p2, BigInteger k2) {
        int n2 = p2.getBits();
        BigInteger bigInteger = EndoUtil.a(k2, p2.getG1(), n2);
        BigInteger bigInteger2 = EndoUtil.a(k2, p2.getG2(), n2);
        BigInteger bigInteger3 = k2.subtract(bigInteger.multiply(p2.getV1A()).add(bigInteger2.multiply(p2.getV2A())));
        BigInteger bigInteger4 = bigInteger.multiply(p2.getV1B()).add(bigInteger2.multiply(p2.getV2B())).negate();
        return new BigInteger[]{bigInteger3, bigInteger4};
    }

    public static ECPoint mapPoint(final ECEndomorphism endomorphism, final ECPoint p2) {
        ECCurve eCCurve = p2.getCurve();
        EndoPreCompInfo endoPreCompInfo = (EndoPreCompInfo)eCCurve.precompute(p2, PRECOMP_NAME, new PreCompCallback(){

            @Override
            public PreCompInfo precompute(PreCompInfo existing) {
                EndoPreCompInfo endoPreCompInfo;
                EndoPreCompInfo endoPreCompInfo2 = endoPreCompInfo = existing instanceof EndoPreCompInfo ? (EndoPreCompInfo)existing : null;
                if (this.a(endoPreCompInfo, endomorphism)) {
                    return endoPreCompInfo;
                }
                ECPoint eCPoint = endomorphism.getPointMap().map(p2);
                EndoPreCompInfo endoPreCompInfo3 = new EndoPreCompInfo();
                endoPreCompInfo3.setEndomorphism(endomorphism);
                endoPreCompInfo3.setMappedPoint(eCPoint);
                return endoPreCompInfo3;
            }

            private boolean a(EndoPreCompInfo endoPreCompInfo, ECEndomorphism eCEndomorphism) {
                return null != endoPreCompInfo && endoPreCompInfo.getEndomorphism() == eCEndomorphism && endoPreCompInfo.getMappedPoint() != null;
            }
        });
        return endoPreCompInfo.getMappedPoint();
    }

    private static BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, int n2) {
        boolean bl = bigInteger2.signum() < 0;
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2.abs());
        boolean bl2 = bigInteger3.testBit(n2 - 1);
        bigInteger3 = bigInteger3.shiftRight(n2);
        if (bl2) {
            bigInteger3 = bigInteger3.add(ECConstants.ONE);
        }
        return bl ? bigInteger3.negate() : bigInteger3;
    }
}

