/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.endo;

import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPointMap;
import com.enterprisedt.bouncycastle.math.ec.ScaleYNegateXPointMap;
import com.enterprisedt.bouncycastle.math.ec.endo.EndoUtil;
import com.enterprisedt.bouncycastle.math.ec.endo.GLVEndomorphism;
import com.enterprisedt.bouncycastle.math.ec.endo.GLVTypeAParameters;
import java.math.BigInteger;

public class GLVTypeAEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeAParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeAEndomorphism(ECCurve curve, GLVTypeAParameters parameters) {
        this.parameters = parameters;
        this.pointMap = new ScaleYNegateXPointMap(curve.fromBigInteger(parameters.getI()));
    }

    @Override
    public BigInteger[] decomposeScalar(BigInteger k2) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), k2);
    }

    @Override
    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    @Override
    public boolean hasEfficientPointMap() {
        return true;
    }
}

