/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.ec.rfc8032;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA512Digest;
import com.enterprisedt.bouncycastle.math.ec.rfc7748.X25519;
import com.enterprisedt.bouncycastle.math.ec.rfc7748.X25519Field;
import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.math.raw.Nat256;
import java.security.SecureRandom;

public abstract class Ed25519 {
    public static final int PREHASH_SIZE = 64;
    public static final int PUBLIC_KEY_SIZE = 32;
    public static final int SECRET_KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private static final byte[] a = new byte[]{83, 105, 103, 69, 100, 50, 53, 53, 49, 57, 32, 110, 111, 32, 69, 100, 50, 53, 53, 49, 57, 32, 99, 111, 108, 108, 105, 115, 105, 111, 110, 115};
    private static final int[] b = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int[] c = new int[]{1886001095, 1339575613, 1980447930, 258412557, -95215574, -959694548, 2013120334, 2047061138};
    private static final int[] d = new int[]{-1886001114, -1339575614, -1980447931, -258412558, 95215573, 959694547, -2013120335, 100422509};
    private static final int[] e = new int[]{52811034, 25909283, 8072341, 50637101, 13785486, 30858332, 20483199, 20966410, 43936626, 4379245};
    private static final int[] f = new int[]{40265304, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC, 0x2666666, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC};
    private static final int[] g = new int[]{12052516, 1174424, 4087752, 38672185, 20040971, 21899680, 55468344, 20105554, 66708015, 9981791};
    private static final int[] h = new int[]{66430571, 45040722, 4842939, 15895846, 18981244, 46308410, 4697481, 8903007, 53646190, 12474675};
    private static final int[] i = new int[]{56195235, 47411844, 25868126, 40503822, 57364, 58321048, 30416477, 31930572, 57760639, 10749657};
    private static final int[] j = new int[]{45281625, 27714825, 18181821, 0xD4141D, 114729, 49533232, 60832955, 30306712, 48412415, 4722099};
    private static final int[] k = new int[]{23454386, 55429651, 2809210, 27797563, 229458, 31957600, 54557047, 27058993, 29715967, 9444199};
    private static final Object l = new Object();
    private static e[] m = null;
    private static e[] n = null;
    private static int[] o = null;

    private static byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int[] nArray = new int[16];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(byArray, nArray);
        int[] nArray2 = new int[8];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(byArray2, nArray2);
        int[] nArray3 = new int[8];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(byArray3, nArray3);
        Nat256.mulAddTo(nArray2, nArray3, nArray);
        byte[] byArray4 = new byte[64];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.a.a(nArray, 0, nArray.length, byArray4, 0);
        return com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(byArray4);
    }

    private static boolean a(byte[] byArray, byte by) {
        return byArray == null && by == 0 || byArray != null && byArray.length < 256;
    }

    private static int a(c c2) {
        int[] nArray = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] nArray2 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] nArray3 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sqr(c2.a, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sqr(c2.b, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray2, nArray3, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sub(nArray2, nArray3, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray, i, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.addOne(nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.add(nArray, nArray2, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(nArray3);
        return com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.isZero(nArray) & ~com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.isZero(nArray3);
    }

    private static int a(b b2) {
        int[] nArray = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] nArray2 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] nArray3 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] nArray4 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sqr(b2.a, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sqr(b2.b, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sqr(b2.c, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray2, nArray3, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sub(nArray2, nArray3, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray2, nArray4, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sqr(nArray4, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray, i, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.add(nArray, nArray4, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.add(nArray, nArray2, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(nArray4);
        return com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.isZero(nArray) & ~com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.isZero(nArray3) & ~com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.isZero(nArray4);
    }

    private static boolean a(byte[] byArray) {
        int n2;
        int n3;
        int n4 = n3 = com.enterprisedt.bouncycastle.math.ec.rfc8032.a.c(byArray, 28) & Integer.MAX_VALUE;
        int n5 = n3 ^ b[7];
        int n6 = n3 ^ c[7];
        int n7 = n3 ^ d[7];
        for (n2 = 6; n2 > 0; --n2) {
            int n8 = com.enterprisedt.bouncycastle.math.ec.rfc8032.a.c(byArray, n2 * 4);
            n4 |= n8;
            n5 |= n8 ^ b[n2];
            n6 |= n8 ^ c[n2];
            n7 |= n8 ^ d[n2];
        }
        n2 = com.enterprisedt.bouncycastle.math.ec.rfc8032.a.c(byArray, 0);
        if (n4 == 0 && n2 + Integer.MIN_VALUE <= -2147483647) {
            return false;
        }
        if (n5 == 0 && n2 + Integer.MIN_VALUE >= b[0] - 1 + Integer.MIN_VALUE) {
            return false;
        }
        return (n6 |= n2 ^ c[0]) != 0 & (n7 |= n2 ^ d[0]) != 0;
    }

    private static boolean b(c c2) {
        b b2 = new b();
        Ed25519.a(c2, b2);
        return Ed25519.b(b2);
    }

    private static boolean b(byte[] byArray) {
        if ((com.enterprisedt.bouncycastle.math.ec.rfc8032.a.c(byArray, 28) & Integer.MAX_VALUE) < b[7]) {
            return true;
        }
        int[] nArray = new int[8];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.a.a(byArray, 0, nArray, 0, 8);
        nArray[7] = nArray[7] & Integer.MAX_VALUE;
        return !Nat256.gte(nArray, b);
    }

    private static byte[] a(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    private static Digest a() {
        SHA512Digest sHA512Digest = new SHA512Digest();
        if (sHA512Digest.getDigestSize() != 64) {
            throw new IllegalStateException();
        }
        return sHA512Digest;
    }

    public static Digest createPrehash() {
        return Ed25519.a();
    }

    private static boolean a(byte[] byArray, boolean bl, c c2) {
        int n2 = (byArray[31] & 0x80) >>> 7;
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.decode(byArray, c2.b);
        int[] nArray = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] nArray2 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sqr(c2.b, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(i, nArray, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.subOne(nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.addOne(nArray2);
        if (!com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sqrtRatioVar(nArray, nArray2, c2.a)) {
            return false;
        }
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(c2.a);
        if (n2 == 1 && com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.isZeroVar(c2.a)) {
            return false;
        }
        if (bl ^ n2 != (c2.a[0] & 1)) {
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.negate(c2.a, c2.a);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(c2.a);
        }
        return true;
    }

    private static void a(Digest digest, byte by, byte[] byArray) {
        int n2 = a.length;
        byte[] byArray2 = new byte[n2 + 2 + byArray.length];
        System.arraycopy(a, 0, byArray2, 0, n2);
        byArray2[n2] = by;
        byArray2[n2 + 1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, n2 + 2, byArray.length);
        digest.update(byArray2, 0, byArray2.length);
    }

    private static void a(c c2, byte[] byArray, int n2) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.encode(c2.b, byArray, n2);
        int n3 = n2 + 32 - 1;
        byArray[n3] = (byte)(byArray[n3] | (c2.a[0] & 1) << 7);
    }

    public static void encodePublicPoint(PublicPoint publicPoint, byte[] pk, int pkOff) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.encode(publicPoint.a, 10, pk, pkOff);
        int n2 = pkOff + 32 - 1;
        pk[n2] = (byte)(pk[n2] | (publicPoint.a[0] & 1) << 7);
    }

    private static int a(b b2, byte[] byArray, int n2) {
        c c2 = new c();
        Ed25519.a(b2, c2);
        int n3 = Ed25519.a(c2);
        Ed25519.a(c2, byArray, n2);
        return n3;
    }

    private static PublicPoint c(c c2) {
        int[] nArray = new int[20];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(c2.a, 0, nArray, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(c2.b, 0, nArray, 10);
        return new PublicPoint(nArray);
    }

    public static void generatePrivateKey(SecureRandom random, byte[] k2) {
        if (k2.length != 32) {
            throw new IllegalArgumentException("k");
        }
        random.nextBytes(k2);
    }

    public static void generatePublicKey(byte[] sk, int skOff, byte[] pk, int pkOff) {
        Digest digest = Ed25519.a();
        byte[] byArray = new byte[64];
        digest.update(sk, skOff, 32);
        digest.doFinal(byArray, 0);
        byte[] byArray2 = new byte[32];
        Ed25519.a(byArray, 0, byArray2);
        Ed25519.a(byArray2, pk, pkOff);
    }

    public static PublicPoint generatePublicKey(byte[] sk, int skOff) {
        Digest digest = Ed25519.a();
        byte[] byArray = new byte[64];
        digest.update(sk, skOff, 32);
        digest.doFinal(byArray, 0);
        byte[] byArray2 = new byte[32];
        Ed25519.a(byArray, 0, byArray2);
        b b2 = new b();
        Ed25519.a(byArray2, b2);
        c c2 = new c();
        Ed25519.a(b2, c2);
        if (0 == Ed25519.a(c2)) {
            throw new IllegalStateException();
        }
        return Ed25519.c(c2);
    }

    private static void a(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = Interleave.shuffle2(nArray[i2]);
        }
    }

    private static void a(Digest digest, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, byte[] byArray4, byte by, byte[] byArray5, int n3, int n4, byte[] byArray6, int n5) {
        if (byArray4 != null) {
            Ed25519.a(digest, by, byArray4);
        }
        digest.update(byArray, 32, 32);
        digest.update(byArray5, n3, n4);
        digest.doFinal(byArray, 0);
        byte[] byArray7 = com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(byArray);
        byte[] byArray8 = new byte[32];
        Ed25519.a(byArray7, byArray8, 0);
        if (byArray4 != null) {
            Ed25519.a(digest, by, byArray4);
        }
        digest.update(byArray8, 0, 32);
        digest.update(byArray3, n2, 32);
        digest.update(byArray5, n3, n4);
        digest.doFinal(byArray, 0);
        byte[] byArray9 = com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(byArray);
        byte[] byArray10 = Ed25519.a(byArray7, byArray9, byArray2);
        System.arraycopy(byArray8, 0, byArray6, n5, 32);
        System.arraycopy(byArray10, 0, byArray6, n5 + 32, 32);
    }

    private static void a(byte[] byArray, int n2, byte[] byArray2, byte by, byte[] byArray3, int n3, int n4, byte[] byArray4, int n5) {
        if (!Ed25519.a(byArray2, by)) {
            throw new IllegalArgumentException("ctx");
        }
        Digest digest = Ed25519.a();
        byte[] byArray5 = new byte[64];
        digest.update(byArray, n2, 32);
        digest.doFinal(byArray5, 0);
        byte[] byArray6 = new byte[32];
        Ed25519.a(byArray5, 0, byArray6);
        byte[] byArray7 = new byte[32];
        Ed25519.a(byArray6, byArray7, 0);
        Ed25519.a(digest, byArray5, byArray6, byArray7, 0, byArray2, by, byArray3, n3, n4, byArray4, n5);
    }

    private static void a(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, byte by, byte[] byArray4, int n4, int n5, byte[] byArray5, int n6) {
        if (!Ed25519.a(byArray3, by)) {
            throw new IllegalArgumentException("ctx");
        }
        Digest digest = Ed25519.a();
        byte[] byArray6 = new byte[64];
        digest.update(byArray, n2, 32);
        digest.doFinal(byArray6, 0);
        byte[] byArray7 = new byte[32];
        Ed25519.a(byArray6, 0, byArray7);
        Ed25519.a(digest, byArray6, byArray7, byArray2, n3, byArray3, by, byArray4, n4, n5, byArray5, n6);
    }

    private static boolean a(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, byte by, byte[] byArray4, int n4, int n5) {
        if (!Ed25519.a(byArray3, by)) {
            throw new IllegalArgumentException("ctx");
        }
        byte[] byArray5 = Ed25519.a(byArray, n2, 32);
        byte[] byArray6 = Ed25519.a(byArray, n2 + 32, 32);
        byte[] byArray7 = Ed25519.a(byArray2, n3, 32);
        if (!Ed25519.b(byArray5)) {
            return false;
        }
        int[] nArray = new int[8];
        if (!com.enterprisedt.bouncycastle.math.ec.rfc8032.b.a(byArray6, nArray)) {
            return false;
        }
        if (!Ed25519.a(byArray7)) {
            return false;
        }
        c c2 = new c();
        if (!Ed25519.a(byArray5, true, c2)) {
            return false;
        }
        c c3 = new c();
        if (!Ed25519.a(byArray7, true, c3)) {
            return false;
        }
        Digest digest = Ed25519.a();
        byte[] byArray8 = new byte[64];
        if (byArray3 != null) {
            Ed25519.a(digest, by, byArray3);
        }
        digest.update(byArray5, 0, 32);
        digest.update(byArray7, 0, 32);
        digest.update(byArray4, n4, n5);
        digest.doFinal(byArray8, 0);
        byte[] byArray9 = com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(byArray8);
        int[] nArray2 = new int[8];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(byArray9, nArray2);
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(nArray2, nArray3, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.b.a(nArray, nArray4, nArray);
        b b2 = new b();
        Ed25519.a(nArray, nArray3, c3, nArray4, c2, b2);
        return Ed25519.b(b2);
    }

    private static boolean a(byte[] byArray, int n2, PublicPoint publicPoint, byte[] byArray2, byte by, byte[] byArray3, int n3, int n4) {
        if (!Ed25519.a(byArray2, by)) {
            throw new IllegalArgumentException("ctx");
        }
        byte[] byArray4 = Ed25519.a(byArray, n2, 32);
        byte[] byArray5 = Ed25519.a(byArray, n2 + 32, 32);
        if (!Ed25519.b(byArray4)) {
            return false;
        }
        int[] nArray = new int[8];
        if (!com.enterprisedt.bouncycastle.math.ec.rfc8032.b.a(byArray5, nArray)) {
            return false;
        }
        c c2 = new c();
        if (!Ed25519.a(byArray4, true, c2)) {
            return false;
        }
        c c3 = new c();
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.negate(publicPoint.a, c3.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(publicPoint.a, 10, c3.b, 0);
        byte[] byArray6 = new byte[32];
        Ed25519.encodePublicPoint(publicPoint, byArray6, 0);
        Digest digest = Ed25519.a();
        byte[] byArray7 = new byte[64];
        if (byArray2 != null) {
            Ed25519.a(digest, by, byArray2);
        }
        digest.update(byArray4, 0, 32);
        digest.update(byArray6, 0, 32);
        digest.update(byArray3, n3, n4);
        digest.doFinal(byArray7, 0);
        byte[] byArray8 = com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(byArray7);
        int[] nArray2 = new int[8];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(byArray8, nArray2);
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(nArray2, nArray3, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.b.a(nArray, nArray4, nArray);
        b b2 = new b();
        Ed25519.a(nArray, nArray3, c3, nArray4, c2, b2);
        return Ed25519.b(b2);
    }

    private static void a(d[] dArray) {
        int n2 = dArray.length;
        int[] nArray = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.createTable(n2);
        int[] nArray2 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(dArray[0].c, 0, nArray2, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(nArray2, 0, nArray, 0);
        int n3 = 0;
        while (++n3 < n2) {
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray2, dArray[n3].c, nArray2);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(nArray2, 0, nArray, n3 * 10);
        }
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.add(nArray2, nArray2, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.invVar(nArray2, nArray2);
        --n3;
        int[] nArray3 = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        while (n3 > 0) {
            int n4 = n3--;
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(nArray, n3 * 10, nArray3, 0);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray3, nArray2, nArray3);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray2, dArray[n4].c, nArray2);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(nArray3, 0, dArray[n4].c, 0);
        }
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(nArray2, 0, dArray[0].c, 0);
    }

    private static void a(b b2, c c2) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.inv(b2.c, c2.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(c2.b, b2.a, c2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(c2.b, b2.b, c2.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(c2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(c2.b);
    }

    private static boolean b(b b2) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(b2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(b2.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(b2.c);
        return com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.isZeroVar(b2.a) && !com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.isZeroVar(b2.b) && com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.areEqualVar(b2.b, b2.c);
    }

    private static void a(d d2, d d3, d d4, g g2) {
        int[] nArray = d4.a;
        int[] nArray2 = d4.b;
        int[] nArray3 = g2.a;
        int[] nArray4 = g2.b;
        int[] nArray5 = nArray;
        int[] nArray6 = nArray3;
        int[] nArray7 = nArray4;
        int[] nArray8 = nArray2;
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(d2.b, d2.a, nArray2, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(d3.b, d3.a, nArray4, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray, nArray3, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray2, nArray4, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(d2.d, d3.d, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray3, j, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.add(d2.c, d2.c, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray4, d3.c, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(nArray2, nArray, nArray8, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(nArray4, nArray3, nArray7, nArray6);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray5, nArray8, d4.d);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray6, nArray7, d4.c);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray5, nArray6, d4.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray8, nArray7, d4.b);
    }

    private static void a(e e2, b b2, g g2) {
        int[] nArray = b2.a;
        int[] nArray2 = b2.b;
        int[] nArray3 = g2.a;
        int[] nArray4 = b2.d;
        int[] nArray5 = nArray;
        int[] nArray6 = nArray2;
        int[] nArray7 = b2.e;
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(b2.b, b2.a, nArray2, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray, e2.a, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray2, e2.b, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(b2.d, b2.e, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray3, e2.c, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(nArray2, nArray, nArray7, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(b2.c, nArray3, nArray6, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray5, nArray6, b2.c);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray5, nArray4, b2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray6, nArray7, b2.b);
    }

    private static void a(boolean bl, e e2, b b2, g g2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3 = b2.a;
        int[] nArray4 = b2.b;
        int[] nArray5 = g2.a;
        int[] nArray6 = b2.d;
        int[] nArray7 = nArray3;
        int[] nArray8 = nArray4;
        int[] nArray9 = b2.e;
        if (bl) {
            nArray2 = nArray4;
            nArray = nArray3;
        } else {
            nArray2 = nArray3;
            nArray = nArray4;
        }
        int[] nArray10 = nArray2;
        int[] nArray11 = nArray;
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(b2.b, b2.a, nArray4, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray2, e2.a, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray, e2.b, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(b2.d, b2.e, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray5, e2.c, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(nArray4, nArray3, nArray9, nArray6);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(b2.c, nArray5, nArray11, nArray10);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray7, nArray8, b2.c);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray7, nArray6, b2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray8, nArray9, b2.b);
    }

    private static void a(boolean bl, f f2, b b2, g g2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3 = b2.a;
        int[] nArray4 = b2.b;
        int[] nArray5 = g2.a;
        int[] nArray6 = b2.c;
        int[] nArray7 = b2.d;
        int[] nArray8 = nArray3;
        int[] nArray9 = nArray4;
        int[] nArray10 = b2.e;
        if (bl) {
            nArray2 = nArray4;
            nArray = nArray3;
        } else {
            nArray2 = nArray3;
            nArray = nArray4;
        }
        int[] nArray11 = nArray2;
        int[] nArray12 = nArray;
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(b2.b, b2.a, nArray4, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray2, f2.a, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray, f2.b, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(b2.d, b2.e, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray5, f2.c, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(b2.c, f2.d, nArray6);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(nArray4, nArray3, nArray10, nArray7);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(nArray6, nArray5, nArray12, nArray11);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray8, nArray9, b2.c);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray8, nArray7, b2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray9, nArray10, b2.b);
    }

    private static void a(b b2, d d2) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(b2.a, 0, d2.a, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(b2.b, 0, d2.b, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(b2.c, 0, d2.c, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(b2.d, b2.e, d2.d);
    }

    private static void a(c c2, d d2) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(c2.a, 0, d2.a, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(c2.b, 0, d2.b, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.one(d2.c);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(c2.a, c2.b, d2.d);
    }

    private static void a(d d2, f f2) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(d2.b, d2.a, f2.b, f2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(d2.d, j, f2.c);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.add(d2.c, d2.c, f2.d);
    }

    private static void c(b b2) {
        int[] nArray = b2.a;
        int[] nArray2 = b2.b;
        int[] nArray3 = b2.c;
        int[] nArray4 = b2.d;
        int[] nArray5 = nArray;
        int[] nArray6 = nArray2;
        int[] nArray7 = b2.e;
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.add(b2.a, b2.b, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sqr(b2.a, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sqr(b2.b, nArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sqr(b2.c, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.add(nArray3, nArray3, nArray3);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(nArray, nArray2, nArray7, nArray6);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sqr(nArray4, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.sub(nArray7, nArray4, nArray4);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.add(nArray3, nArray6, nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.carry(nArray5);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray5, nArray6, b2.c);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray5, nArray4, b2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(nArray6, nArray7, b2.b);
    }

    private static void a(int n2, int n3, e e2) {
        int n4 = n2 * 8 * 3 * 10;
        for (int i2 = 0; i2 < 8; ++i2) {
            int n5 = (i2 ^ n3) - 1 >> 31;
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.cmov(n5, o, n4, e2.a, 0);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.cmov(n5, o, n4 += 10, e2.b, 0);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.cmov(n5, o, n4 += 10, e2.c, 0);
            n4 += 10;
        }
    }

    private static void a(c c2, d[] dArray, int n2, int n3, g g2) {
        dArray[n2] = new d();
        Ed25519.a(c2, dArray[n2]);
        d d2 = new d();
        Ed25519.a(dArray[n2], dArray[n2], d2, g2);
        for (int i2 = 1; i2 < n3; ++i2) {
            d d3 = new d();
            dArray[n2 + i2] = d3;
            Ed25519.a(dArray[n2 + i2 - 1], d2, d3, g2);
        }
    }

    private static void a(c c2, f[] fArray, int n2, g g2) {
        d d2 = new d();
        Ed25519.a(c2, d2);
        d d3 = new d();
        Ed25519.a(d2, d2, d3, g2);
        int n3 = 0;
        while (true) {
            f f2 = fArray[n3] = new f();
            Ed25519.a(d2, f2);
            if (++n3 == n2) break;
            Ed25519.a(d2, d3, d2, g2);
        }
    }

    private static void d(b b2) {
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.zero(b2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.one(b2.b);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.one(b2.c);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.zero(b2.d);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.one(b2.e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void precompute() {
        Object object = l;
        synchronized (object) {
            d d2;
            int n2;
            if (o != null) {
                return;
            }
            int n3 = 16;
            int n4 = 64;
            int n5 = n3 * 2 + n4;
            d[] dArray = new d[n5];
            g g2 = new g();
            c c2 = new c();
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(e, 0, c2.a, 0);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(f, 0, c2.b, 0);
            Ed25519.a(c2, dArray, 0, n3, g2);
            c c3 = new c();
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(g, 0, c3.a, 0);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(h, 0, c3.b, 0);
            Ed25519.a(c3, dArray, n3, n3, g2);
            b b2 = new b();
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(e, 0, b2.a, 0);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(f, 0, b2.b, 0);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.one(b2.c);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(b2.a, 0, b2.d, 0);
            com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(b2.b, 0, b2.e, 0);
            int n6 = n3 * 2;
            d[] dArray2 = new d[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                dArray2[i2] = new d();
            }
            d d3 = new d();
            for (n2 = 0; n2 < 8; ++n2) {
                int n7;
                int n8;
                int n9 = n6++;
                d d4 = new d();
                dArray[n9] = d4;
                d2 = d4;
                for (n8 = 0; n8 < 4; ++n8) {
                    if (n8 == 0) {
                        Ed25519.a(b2, d2);
                    } else {
                        Ed25519.a(b2, d3);
                        Ed25519.a(d2, d3, d2, g2);
                    }
                    Ed25519.c(b2);
                    Ed25519.a(b2, dArray2[n8]);
                    if (n2 + n8 == 10) continue;
                    for (n7 = 1; n7 < 8; ++n7) {
                        Ed25519.c(b2);
                    }
                }
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.negate(d2.a, d2.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.negate(d2.d, d2.d);
                for (n8 = 0; n8 < 3; ++n8) {
                    n7 = 1 << n8;
                    int n10 = 0;
                    while (n10 < n7) {
                        dArray[n6] = new d();
                        Ed25519.a(dArray[n6 - n7], dArray2[n8], dArray[n6], g2);
                        ++n10;
                        ++n6;
                    }
                }
            }
            Ed25519.a(dArray);
            m = new e[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                d2 = dArray[n2];
                e e2 = Ed25519.m[n2] = new e();
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(d2.a, d2.c, d2.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(d2.b, d2.c, d2.b);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(d2.b, d2.a, e2.b, e2.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(d2.a, d2.b, e2.c);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(e2.c, k, e2.c);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(e2.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(e2.b);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(e2.c);
            }
            n = new e[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                d2 = dArray[n3 + n2];
                e e3 = Ed25519.n[n2] = new e();
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(d2.a, d2.c, d2.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(d2.b, d2.c, d2.b);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(d2.b, d2.a, e3.b, e3.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(d2.a, d2.b, e3.c);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(e3.c, k, e3.c);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(e3.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(e3.b);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(e3.c);
            }
            o = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.createTable(n4 * 3);
            e e4 = new e();
            int n11 = 0;
            for (int i3 = n3 * 2; i3 < n5; ++i3) {
                d d5 = dArray[i3];
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(d5.a, d5.c, d5.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(d5.b, d5.c, d5.b);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.apm(d5.b, d5.a, e4.b, e4.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(d5.a, d5.b, e4.c);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.mul(e4.c, k, e4.c);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(e4.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(e4.b);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.normalize(e4.c);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(e4.a, 0, o, n11);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(e4.b, 0, o, n11 += 10);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(e4.c, 0, o, n11 += 10);
                n11 += 10;
            }
        }
    }

    private static void a(byte[] byArray, int n2, byte[] byArray2) {
        System.arraycopy(byArray, n2, byArray2, 0, 32);
        byArray2[0] = (byte)(byArray2[0] & 0xF8);
        byArray2[31] = (byte)(byArray2[31] & 0x7F);
        byArray2[31] = (byte)(byArray2[31] | 0x40);
    }

    private static void a(byte[] byArray, b b2) {
        Ed25519.precompute();
        int[] nArray = new int[8];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.b.b(byArray, nArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.b.a(256, nArray);
        Ed25519.a(nArray);
        e e2 = new e();
        g g2 = new g();
        Ed25519.d(b2);
        int n2 = 0;
        int n3 = 28;
        while (true) {
            for (int i2 = 0; i2 < 8; ++i2) {
                int n4 = nArray[i2] >>> n3;
                int n5 = n4 >>> 3 & 1;
                int n6 = (n4 ^ -n5) & 7;
                Ed25519.a(i2, n6, e2);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.cnegate(n2 ^ n5, b2.a);
                com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.cnegate(n2 ^ n5, b2.d);
                n2 = n5;
                Ed25519.a(e2, b2, g2);
            }
            if ((n3 -= 4) < 0) break;
            Ed25519.c(b2);
        }
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.cnegate(n2, b2.a);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.cnegate(n2, b2.d);
    }

    private static void a(byte[] byArray, byte[] byArray2, int n2) {
        b b2 = new b();
        Ed25519.a(byArray, b2);
        if (0 == Ed25519.a(b2, byArray2, n2)) {
            throw new IllegalStateException();
        }
    }

    public static void scalarMultBaseYZ(X25519.Friend friend, byte[] k2, int kOff, int[] y, int[] z) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by X25519");
        }
        byte[] byArray = new byte[32];
        Ed25519.a(k2, kOff, byArray);
        b b2 = new b();
        Ed25519.a(byArray, b2);
        if (0 == Ed25519.a(b2)) {
            throw new IllegalStateException();
        }
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(b2.b, 0, y, 0);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.copy(b2.c, 0, z, 0);
    }

    private static void a(c c2, b b2) {
        byte[] byArray = new byte[253];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.b.a(4, byArray);
        int n2 = 4;
        f[] fArray = new f[n2];
        g g2 = new g();
        Ed25519.a(c2, fArray, n2, g2);
        Ed25519.d(b2);
        int n3 = 252;
        while (true) {
            byte by;
            if ((by = byArray[n3]) != 0) {
                int n4 = by >> 1 ^ by >> 31;
                Ed25519.a(by < 0, fArray[n4], b2, g2);
            }
            if (--n3 < 0) break;
            Ed25519.c(b2);
        }
    }

    private static void a(int[] nArray, int[] nArray2, c c2, int[] nArray3, c c3, b b2) {
        Ed25519.precompute();
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[128];
        byte[] byArray3 = new byte[128];
        com.enterprisedt.bouncycastle.math.ec.rfc8032.e.a(nArray, 6, byArray);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.e.a(nArray2, 4, byArray2);
        com.enterprisedt.bouncycastle.math.ec.rfc8032.e.a(nArray3, 4, byArray3);
        int n2 = 4;
        f[] fArray = new f[n2];
        f[] fArray2 = new f[n2];
        g g2 = new g();
        Ed25519.a(c2, fArray, n2, g2);
        Ed25519.a(c3, fArray2, n2, g2);
        Ed25519.d(b2);
        int n3 = 128;
        while (--n3 >= 0 && (byArray[n3] | byArray[128 + n3] | byArray2[n3] | byArray3[n3]) == 0) {
        }
        while (n3 >= 0) {
            int n4;
            int n5;
            int n6;
            byte by = byArray[n3];
            if (by != 0) {
                n6 = by >> 1 ^ by >> 31;
                Ed25519.a(by < 0, m[n6], b2, g2);
            }
            if ((n6 = byArray[128 + n3]) != 0) {
                n5 = n6 >> 1 ^ n6 >> 31;
                Ed25519.a(n6 < 0, n[n5], b2, g2);
            }
            if ((n5 = byArray2[n3]) != 0) {
                n4 = n5 >> 1 ^ n5 >> 31;
                Ed25519.a(n5 < 0, fArray[n4], b2, g2);
            }
            if ((n4 = byArray3[n3]) != 0) {
                int n7 = n4 >> 1 ^ n4 >> 31;
                Ed25519.a(n4 < 0, fArray2[n7], b2, g2);
            }
            Ed25519.c(b2);
            --n3;
        }
        Ed25519.c(b2);
        Ed25519.c(b2);
    }

    public static void sign(byte[] sk, int skOff, byte[] m2, int mOff, int mLen, byte[] sig, int sigOff) {
        byte[] byArray = null;
        byte by = 0;
        Ed25519.a(sk, skOff, byArray, by, m2, mOff, mLen, sig, sigOff);
    }

    public static void sign(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] m2, int mOff, int mLen, byte[] sig, int sigOff) {
        byte[] byArray = null;
        byte by = 0;
        Ed25519.a(sk, skOff, pk, pkOff, byArray, by, m2, mOff, mLen, sig, sigOff);
    }

    public static void sign(byte[] sk, int skOff, byte[] ctx, byte[] m2, int mOff, int mLen, byte[] sig, int sigOff) {
        byte by = 0;
        Ed25519.a(sk, skOff, ctx, by, m2, mOff, mLen, sig, sigOff);
    }

    public static void sign(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, byte[] m2, int mOff, int mLen, byte[] sig, int sigOff) {
        byte by = 0;
        Ed25519.a(sk, skOff, pk, pkOff, ctx, by, m2, mOff, mLen, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] ctx, byte[] ph, int phOff, byte[] sig, int sigOff) {
        byte by = 1;
        Ed25519.a(sk, skOff, ctx, by, ph, phOff, 64, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, byte[] ph, int phOff, byte[] sig, int sigOff) {
        byte by = 1;
        Ed25519.a(sk, skOff, pk, pkOff, ctx, by, ph, phOff, 64, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] ctx, Digest ph, byte[] sig, int sigOff) {
        byte[] byArray = new byte[64];
        if (64 != ph.doFinal(byArray, 0)) {
            throw new IllegalArgumentException("ph");
        }
        byte by = 1;
        Ed25519.a(sk, skOff, ctx, by, byArray, 0, byArray.length, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, Digest ph, byte[] sig, int sigOff) {
        byte[] byArray = new byte[64];
        if (64 != ph.doFinal(byArray, 0)) {
            throw new IllegalArgumentException("ph");
        }
        byte by = 1;
        Ed25519.a(sk, skOff, pk, pkOff, ctx, by, byArray, 0, byArray.length, sig, sigOff);
    }

    public static boolean validatePublicKeyFull(byte[] pk, int pkOff) {
        byte[] byArray = Ed25519.a(pk, pkOff, 32);
        if (!Ed25519.a(byArray)) {
            return false;
        }
        c c2 = new c();
        if (!Ed25519.a(byArray, false, c2)) {
            return false;
        }
        return Ed25519.b(c2);
    }

    public static PublicPoint validatePublicKeyFullExport(byte[] pk, int pkOff) {
        byte[] byArray = Ed25519.a(pk, pkOff, 32);
        if (!Ed25519.a(byArray)) {
            return null;
        }
        c c2 = new c();
        if (!Ed25519.a(byArray, false, c2)) {
            return null;
        }
        if (!Ed25519.b(c2)) {
            return null;
        }
        return Ed25519.c(c2);
    }

    public static boolean validatePublicKeyPartial(byte[] pk, int pkOff) {
        byte[] byArray = Ed25519.a(pk, pkOff, 32);
        if (!Ed25519.a(byArray)) {
            return false;
        }
        c c2 = new c();
        return Ed25519.a(byArray, false, c2);
    }

    public static PublicPoint validatePublicKeyPartialExport(byte[] pk, int pkOff) {
        byte[] byArray = Ed25519.a(pk, pkOff, 32);
        if (!Ed25519.a(byArray)) {
            return null;
        }
        c c2 = new c();
        if (!Ed25519.a(byArray, false, c2)) {
            return null;
        }
        return Ed25519.c(c2);
    }

    public static boolean verify(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] m2, int mOff, int mLen) {
        byte[] byArray = null;
        byte by = 0;
        return Ed25519.a(sig, sigOff, pk, pkOff, byArray, by, m2, mOff, mLen);
    }

    public static boolean verify(byte[] sig, int sigOff, PublicPoint publicPoint, byte[] m2, int mOff, int mLen) {
        byte[] byArray = null;
        byte by = 0;
        return Ed25519.a(sig, sigOff, publicPoint, byArray, by, m2, mOff, mLen);
    }

    public static boolean verify(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, byte[] m2, int mOff, int mLen) {
        byte by = 0;
        return Ed25519.a(sig, sigOff, pk, pkOff, ctx, by, m2, mOff, mLen);
    }

    public static boolean verify(byte[] sig, int sigOff, PublicPoint publicPoint, byte[] ctx, byte[] m2, int mOff, int mLen) {
        byte by = 0;
        return Ed25519.a(sig, sigOff, publicPoint, ctx, by, m2, mOff, mLen);
    }

    public static boolean verifyPrehash(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, byte[] ph, int phOff) {
        byte by = 1;
        return Ed25519.a(sig, sigOff, pk, pkOff, ctx, by, ph, phOff, 64);
    }

    public static boolean verifyPrehash(byte[] sig, int sigOff, PublicPoint publicPoint, byte[] ctx, byte[] ph, int phOff) {
        byte by = 1;
        return Ed25519.a(sig, sigOff, publicPoint, ctx, by, ph, phOff, 64);
    }

    public static boolean verifyPrehash(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, Digest ph) {
        byte[] byArray = new byte[64];
        if (64 != ph.doFinal(byArray, 0)) {
            throw new IllegalArgumentException("ph");
        }
        byte by = 1;
        return Ed25519.a(sig, sigOff, pk, pkOff, ctx, by, byArray, 0, byArray.length);
    }

    public static boolean verifyPrehash(byte[] sig, int sigOff, PublicPoint publicPoint, byte[] ctx, Digest ph) {
        byte[] byArray = new byte[64];
        if (64 != ph.doFinal(byArray, 0)) {
            throw new IllegalArgumentException("ph");
        }
        byte by = 1;
        return Ed25519.a(sig, sigOff, publicPoint, ctx, by, byArray, 0, byArray.length);
    }

    private static class g {
        int[] a = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] b = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();

        private g() {
        }
    }

    private static class f {
        int[] a = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] b = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] c = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] d = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();

        private f() {
        }
    }

    private static class e {
        int[] a = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] b = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] c = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();

        private e() {
        }
    }

    private static class d {
        int[] a = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] b = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] c = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] d = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();

        private d() {
        }
    }

    private static class c {
        int[] a = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] b = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();

        private c() {
        }
    }

    private static class b {
        int[] a = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] b = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] c = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] d = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();
        int[] e = com.enterprisedt.bouncycastle.math.ec.rfc8032.Ed25519$a.create();

        private b() {
        }
    }

    private static class a
    extends X25519Field {
    }

    public static final class PublicPoint {
        final int[] a;

        PublicPoint(int[] data) {
            this.a = data;
        }
    }

    public static final class Algorithm {
        public static final int Ed25519 = 0;
        public static final int Ed25519ctx = 1;
        public static final int Ed25519ph = 2;
    }
}

