/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.field;

import com.enterprisedt.bouncycastle.math.field.FiniteField;
import com.enterprisedt.bouncycastle.math.field.PolynomialExtensionField;
import com.enterprisedt.bouncycastle.math.field.a;
import com.enterprisedt.bouncycastle.math.field.b;
import com.enterprisedt.bouncycastle.math.field.c;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public abstract class FiniteFields {
    static final FiniteField a = new c(BigInteger.valueOf(2L));
    static final FiniteField b = new c(BigInteger.valueOf(3L));

    public static PolynomialExtensionField getBinaryExtensionField(int[] exponents) {
        if (exponents[0] != 0) {
            throw new IllegalArgumentException("Irreducible polynomials in GF(2) must have constant term");
        }
        for (int i2 = 1; i2 < exponents.length; ++i2) {
            if (exponents[i2] > exponents[i2 - 1]) continue;
            throw new IllegalArgumentException("Polynomial exponents must be monotonically increasing");
        }
        return new b(a, new a(exponents));
    }

    public static FiniteField getPrimeField(BigInteger characteristic) {
        int n2 = characteristic.bitLength();
        if (characteristic.signum() <= 0 || n2 < 2) {
            throw new IllegalArgumentException("'characteristic' must be >= 2");
        }
        if (n2 < 3) {
            switch (BigIntegers.intValueExact(characteristic)) {
                case 2: {
                    return a;
                }
                case 3: {
                    return b;
                }
            }
        }
        return new c(characteristic);
    }
}

