/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

import com.enterprisedt.bouncycastle.math.raw.Nat256;

public abstract class Mont256 {
    public static int inverse32(int x) {
        int n2 = x;
        n2 *= 2 - x * n2;
        n2 *= 2 - x * n2;
        n2 *= 2 - x * n2;
        n2 *= 2 - x * n2;
        return n2;
    }

    public static void multAdd(int[] x, int[] y, int[] z, int[] m2, int mInv32) {
        int n2 = 0;
        long l2 = (long)y[0] & 0xFFFFFFFFL;
        for (int i2 = 0; i2 < 8; ++i2) {
            long l3 = (long)z[0] & 0xFFFFFFFFL;
            long l4 = (long)x[i2] & 0xFFFFFFFFL;
            long l5 = l4 * l2;
            long l6 = (l5 & 0xFFFFFFFFL) + l3;
            long l7 = (long)((int)l6 * mInv32) & 0xFFFFFFFFL;
            long l8 = l7 * ((long)m2[0] & 0xFFFFFFFFL);
            l6 += l8 & 0xFFFFFFFFL;
            l6 = (l6 >>> 32) + (l5 >>> 32) + (l8 >>> 32);
            for (int i3 = 1; i3 < 8; ++i3) {
                l5 = l4 * ((long)y[i3] & 0xFFFFFFFFL);
                l8 = l7 * ((long)m2[i3] & 0xFFFFFFFFL);
                z[i3 - 1] = (int)(l6 += (l5 & 0xFFFFFFFFL) + (l8 & 0xFFFFFFFFL) + ((long)z[i3] & 0xFFFFFFFFL));
                l6 = (l6 >>> 32) + (l5 >>> 32) + (l8 >>> 32);
            }
            z[7] = (int)(l6 += (long)n2 & 0xFFFFFFFFL);
            n2 = (int)(l6 >>> 32);
        }
        if (n2 != 0 || Nat256.gte(z, m2)) {
            Nat256.sub(z, m2, z);
        }
    }

    public static void multAddXF(int[] x, int[] y, int[] z, int[] m2) {
        int n2 = 0;
        long l2 = (long)y[0] & 0xFFFFFFFFL;
        for (int i2 = 0; i2 < 8; ++i2) {
            long l3 = (long)x[i2] & 0xFFFFFFFFL;
            long l4 = l3 * l2 + ((long)z[0] & 0xFFFFFFFFL);
            long l5 = l4 & 0xFFFFFFFFL;
            l4 = (l4 >>> 32) + l5;
            for (int i3 = 1; i3 < 8; ++i3) {
                long l6 = l3 * ((long)y[i3] & 0xFFFFFFFFL);
                long l7 = l5 * ((long)m2[i3] & 0xFFFFFFFFL);
                z[i3 - 1] = (int)(l4 += (l6 & 0xFFFFFFFFL) + (l7 & 0xFFFFFFFFL) + ((long)z[i3] & 0xFFFFFFFFL));
                l4 = (l4 >>> 32) + (l6 >>> 32) + (l7 >>> 32);
            }
            z[7] = (int)(l4 += (long)n2 & 0xFFFFFFFFL);
            n2 = (int)(l4 >>> 32);
        }
        if (n2 != 0 || Nat256.gte(z, m2)) {
            Nat256.sub(z, m2, z);
        }
    }

    public static void reduce(int[] z, int[] m2, int mInv32) {
        for (int i2 = 0; i2 < 8; ++i2) {
            int n2 = z[0];
            long l2 = (long)(n2 * mInv32) & 0xFFFFFFFFL;
            long l3 = l2 * ((long)m2[0] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL);
            l3 >>>= 32;
            for (int i3 = 1; i3 < 8; ++i3) {
                z[i3 - 1] = (int)(l3 += l2 * ((long)m2[i3] & 0xFFFFFFFFL) + ((long)z[i3] & 0xFFFFFFFFL));
                l3 >>>= 32;
            }
            z[7] = (int)l3;
        }
        if (Nat256.gte(z, m2)) {
            Nat256.sub(z, m2, z);
        }
    }

    public static void reduceXF(int[] z, int[] m2) {
        for (int i2 = 0; i2 < 8; ++i2) {
            long l2;
            int n2 = z[0];
            long l3 = l2 = (long)n2 & 0xFFFFFFFFL;
            for (int i3 = 1; i3 < 8; ++i3) {
                z[i3 - 1] = (int)(l3 += l2 * ((long)m2[i3] & 0xFFFFFFFFL) + ((long)z[i3] & 0xFFFFFFFFL));
                l3 >>>= 32;
            }
            z[7] = (int)l3;
        }
        if (Nat256.gte(z, m2)) {
            Nat256.sub(z, m2, z);
        }
    }
}

