/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat {
    public static int add(int len, int[] x, int[] y, int[] z) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[i2] = (int)(l2 += ((long)x[i2] & 0xFFFFFFFFL) + ((long)y[i2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int add33At(int len, int x, int[] z, int zPos) {
        long l2 = ((long)z[zPos + 0] & 0xFFFFFFFFL) + ((long)x & 0xFFFFFFFFL);
        z[zPos + 0] = (int)l2;
        l2 >>>= 32;
        z[zPos + 1] = (int)(l2 += ((long)z[zPos + 1] & 0xFFFFFFFFL) + 1L);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zPos + 2);
    }

    public static int add33At(int len, int x, int[] z, int zOff, int zPos) {
        long l2 = ((long)z[zOff + zPos] & 0xFFFFFFFFL) + ((long)x & 0xFFFFFFFFL);
        z[zOff + zPos] = (int)l2;
        l2 >>>= 32;
        z[zOff + zPos + 1] = (int)(l2 += ((long)z[zOff + zPos + 1] & 0xFFFFFFFFL) + 1L);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zOff, zPos + 2);
    }

    public static int add33To(int len, int x, int[] z) {
        long l2 = ((long)z[0] & 0xFFFFFFFFL) + ((long)x & 0xFFFFFFFFL);
        z[0] = (int)l2;
        l2 >>>= 32;
        z[1] = (int)(l2 += ((long)z[1] & 0xFFFFFFFFL) + 1L);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, 2);
    }

    public static int add33To(int len, int x, int[] z, int zOff) {
        long l2 = ((long)z[zOff + 0] & 0xFFFFFFFFL) + ((long)x & 0xFFFFFFFFL);
        z[zOff + 0] = (int)l2;
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += ((long)z[zOff + 1] & 0xFFFFFFFFL) + 1L);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zOff, 2);
    }

    public static int addBothTo(int len, int[] x, int[] y, int[] z) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[i2] = (int)(l2 += ((long)x[i2] & 0xFFFFFFFFL) + ((long)y[i2] & 0xFFFFFFFFL) + ((long)z[i2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int addBothTo(int len, int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[zOff + i2] = (int)(l2 += ((long)x[xOff + i2] & 0xFFFFFFFFL) + ((long)y[yOff + i2] & 0xFFFFFFFFL) + ((long)z[zOff + i2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int addDWordAt(int len, long x, int[] z, int zPos) {
        long l2 = ((long)z[zPos + 0] & 0xFFFFFFFFL) + (x & 0xFFFFFFFFL);
        z[zPos + 0] = (int)l2;
        l2 >>>= 32;
        z[zPos + 1] = (int)(l2 += ((long)z[zPos + 1] & 0xFFFFFFFFL) + (x >>> 32));
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zPos + 2);
    }

    public static int addDWordAt(int len, long x, int[] z, int zOff, int zPos) {
        long l2 = ((long)z[zOff + zPos] & 0xFFFFFFFFL) + (x & 0xFFFFFFFFL);
        z[zOff + zPos] = (int)l2;
        l2 >>>= 32;
        z[zOff + zPos + 1] = (int)(l2 += ((long)z[zOff + zPos + 1] & 0xFFFFFFFFL) + (x >>> 32));
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zOff, zPos + 2);
    }

    public static int addDWordTo(int len, long x, int[] z) {
        long l2 = ((long)z[0] & 0xFFFFFFFFL) + (x & 0xFFFFFFFFL);
        z[0] = (int)l2;
        l2 >>>= 32;
        z[1] = (int)(l2 += ((long)z[1] & 0xFFFFFFFFL) + (x >>> 32));
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, 2);
    }

    public static int addDWordTo(int len, long x, int[] z, int zOff) {
        long l2 = ((long)z[zOff + 0] & 0xFFFFFFFFL) + (x & 0xFFFFFFFFL);
        z[zOff + 0] = (int)l2;
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += ((long)z[zOff + 1] & 0xFFFFFFFFL) + (x >>> 32));
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zOff, 2);
    }

    public static int addTo(int len, int[] x, int[] z) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[i2] = (int)(l2 += ((long)x[i2] & 0xFFFFFFFFL) + ((long)z[i2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int addTo(int len, int[] x, int xOff, int[] z, int zOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[zOff + i2] = (int)(l2 += ((long)x[xOff + i2] & 0xFFFFFFFFL) + ((long)z[zOff + i2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int addTo(int len, int[] x, int xOff, int[] z, int zOff, int cIn) {
        long l2 = (long)cIn & 0xFFFFFFFFL;
        for (int i2 = 0; i2 < len; ++i2) {
            z[zOff + i2] = (int)(l2 += ((long)x[xOff + i2] & 0xFFFFFFFFL) + ((long)z[zOff + i2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int addToEachOther(int len, int[] u2, int uOff, int[] v2, int vOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            u2[uOff + i2] = (int)(l2 += ((long)u2[uOff + i2] & 0xFFFFFFFFL) + ((long)v2[vOff + i2] & 0xFFFFFFFFL));
            v2[vOff + i2] = (int)l2;
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int addWordAt(int len, int x, int[] z, int zPos) {
        long l2 = ((long)x & 0xFFFFFFFFL) + ((long)z[zPos] & 0xFFFFFFFFL);
        z[zPos] = (int)l2;
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zPos + 1);
    }

    public static int addWordAt(int len, int x, int[] z, int zOff, int zPos) {
        long l2 = ((long)x & 0xFFFFFFFFL) + ((long)z[zOff + zPos] & 0xFFFFFFFFL);
        z[zOff + zPos] = (int)l2;
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zOff, zPos + 1);
    }

    public static int addWordTo(int len, int x, int[] z) {
        long l2 = ((long)x & 0xFFFFFFFFL) + ((long)z[0] & 0xFFFFFFFFL);
        z[0] = (int)l2;
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, 1);
    }

    public static int addWordTo(int len, int x, int[] z, int zOff) {
        long l2 = ((long)x & 0xFFFFFFFFL) + ((long)z[zOff] & 0xFFFFFFFFL);
        z[zOff] = (int)l2;
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zOff, 1);
    }

    public static int cadd(int len, int mask, int[] x, int[] y, int[] z) {
        long l2 = (long)(-(mask & 1)) & 0xFFFFFFFFL;
        long l3 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[i2] = (int)(l3 += ((long)x[i2] & 0xFFFFFFFFL) + ((long)y[i2] & l2));
            l3 >>>= 32;
        }
        return (int)l3;
    }

    public static int caddTo(int len, int mask, int[] x, int[] z) {
        long l2 = (long)(-(mask & 1)) & 0xFFFFFFFFL;
        long l3 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[i2] = (int)(l3 += ((long)z[i2] & 0xFFFFFFFFL) + ((long)x[i2] & l2));
            l3 >>>= 32;
        }
        return (int)l3;
    }

    public static void cmov(int len, int mask, int[] x, int xOff, int[] z, int zOff) {
        mask = -(mask & 1);
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = z[zOff + i2];
            int n3 = n2 ^ x[xOff + i2];
            z[zOff + i2] = n2 ^= n3 & mask;
        }
    }

    public static int compare(int len, int[] x, int[] y) {
        for (int i2 = len - 1; i2 >= 0; --i2) {
            int n2 = x[i2] ^ Integer.MIN_VALUE;
            int n3 = y[i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return -1;
            }
            if (n2 <= n3) continue;
            return 1;
        }
        return 0;
    }

    public static int compare(int len, int[] x, int xOff, int[] y, int yOff) {
        for (int i2 = len - 1; i2 >= 0; --i2) {
            int n2 = x[xOff + i2] ^ Integer.MIN_VALUE;
            int n3 = y[yOff + i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return -1;
            }
            if (n2 <= n3) continue;
            return 1;
        }
        return 0;
    }

    public static int[] copy(int len, int[] x) {
        int[] nArray = new int[len];
        System.arraycopy(x, 0, nArray, 0, len);
        return nArray;
    }

    public static void copy(int len, int[] x, int[] z) {
        System.arraycopy(x, 0, z, 0, len);
    }

    public static void copy(int len, int[] x, int xOff, int[] z, int zOff) {
        System.arraycopy(x, xOff, z, zOff, len);
    }

    public static long[] copy64(int len, long[] x) {
        long[] lArray = new long[len];
        System.arraycopy(x, 0, lArray, 0, len);
        return lArray;
    }

    public static void copy64(int len, long[] x, long[] z) {
        System.arraycopy(x, 0, z, 0, len);
    }

    public static void copy64(int len, long[] x, int xOff, long[] z, int zOff) {
        System.arraycopy(x, xOff, z, zOff, len);
    }

    public static int[] create(int len) {
        return new int[len];
    }

    public static long[] create64(int len) {
        return new long[len];
    }

    public static int csub(int len, int mask, int[] x, int[] y, int[] z) {
        long l2 = (long)(-(mask & 1)) & 0xFFFFFFFFL;
        long l3 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[i2] = (int)(l3 += ((long)x[i2] & 0xFFFFFFFFL) - ((long)y[i2] & l2));
            l3 >>= 32;
        }
        return (int)l3;
    }

    public static int csub(int len, int mask, int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long l2 = (long)(-(mask & 1)) & 0xFFFFFFFFL;
        long l3 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[zOff + i2] = (int)(l3 += ((long)x[xOff + i2] & 0xFFFFFFFFL) - ((long)y[yOff + i2] & l2));
            l3 >>= 32;
        }
        return (int)l3;
    }

    public static int dec(int len, int[] z) {
        int n2 = 0;
        while (n2 < len) {
            int n3 = n2++;
            z[n3] = z[n3] - 1;
            if (z[n3] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static int dec(int len, int[] x, int[] z) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2;
            z[i2] = n2 = x[i2] - 1;
            if (n2 == -1) continue;
            while (i2 < len) {
                z[i2] = x[i2];
                ++i2;
            }
            return 0;
        }
        return -1;
    }

    public static int decAt(int len, int[] z, int zPos) {
        int n2 = zPos;
        while (n2 < len) {
            int n3 = n2++;
            z[n3] = z[n3] - 1;
            if (z[n3] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static int decAt(int len, int[] z, int zOff, int zPos) {
        for (int i2 = zPos; i2 < len; ++i2) {
            int n2 = zOff + i2;
            z[n2] = z[n2] - 1;
            if (z[n2] == -1) continue;
            return 0;
        }
        return -1;
    }

    public static boolean diff(int len, int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        boolean bl = Nat.gte(len, x, xOff, y, yOff);
        if (bl) {
            Nat.sub(len, x, xOff, y, yOff, z, zOff);
        } else {
            Nat.sub(len, y, yOff, x, xOff, z, zOff);
        }
        return bl;
    }

    public static boolean eq(int len, int[] x, int[] y) {
        for (int i2 = len - 1; i2 >= 0; --i2) {
            if (x[i2] == y[i2]) continue;
            return false;
        }
        return true;
    }

    public static int equalTo(int len, int[] x, int y) {
        int n2 = x[0] ^ y;
        for (int i2 = 1; i2 < len; ++i2) {
            n2 |= x[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static int equalTo(int len, int[] x, int xOff, int y) {
        int n2 = x[xOff] ^ y;
        for (int i2 = 1; i2 < len; ++i2) {
            n2 |= x[xOff + i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static int equalTo(int len, int[] x, int[] y) {
        int n2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            n2 |= x[i2] ^ y[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static int equalTo(int len, int[] x, int xOff, int[] y, int yOff) {
        int n2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            n2 |= x[xOff + i2] ^ y[yOff + i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static int equalToZero(int len, int[] x) {
        int n2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            n2 |= x[i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static int equalToZero(int len, int[] x, int xOff) {
        int n2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            n2 |= x[xOff + i2];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static int[] fromBigInteger(int bits, BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > bits) {
            throw new IllegalArgumentException();
        }
        int n2 = bits + 31 >> 5;
        int[] nArray = Nat.create(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = x.intValue();
            x = x.shiftRight(32);
        }
        return nArray;
    }

    public static long[] fromBigInteger64(int bits, BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > bits) {
            throw new IllegalArgumentException();
        }
        int n2 = bits + 63 >> 6;
        long[] lArray = Nat.create64(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = x.longValue();
            x = x.shiftRight(64);
        }
        return lArray;
    }

    public static int getBit(int[] x, int bit) {
        if (bit == 0) {
            return x[0] & 1;
        }
        int n2 = bit >> 5;
        if (n2 < 0 || n2 >= x.length) {
            return 0;
        }
        int n3 = bit & 0x1F;
        return x[n2] >>> n3 & 1;
    }

    public static boolean gte(int len, int[] x, int[] y) {
        for (int i2 = len - 1; i2 >= 0; --i2) {
            int n2 = x[i2] ^ Integer.MIN_VALUE;
            int n3 = y[i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static boolean gte(int len, int[] x, int xOff, int[] y, int yOff) {
        for (int i2 = len - 1; i2 >= 0; --i2) {
            int n2 = x[xOff + i2] ^ Integer.MIN_VALUE;
            int n3 = y[yOff + i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static int inc(int len, int[] z) {
        int n2 = 0;
        while (n2 < len) {
            int n3 = n2++;
            z[n3] = z[n3] + 1;
            if (z[n3] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static int inc(int len, int[] x, int[] z) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2;
            z[i2] = n2 = x[i2] + 1;
            if (n2 == 0) continue;
            while (i2 < len) {
                z[i2] = x[i2];
                ++i2;
            }
            return 0;
        }
        return 1;
    }

    public static int incAt(int len, int[] z, int zPos) {
        int n2 = zPos;
        while (n2 < len) {
            int n3 = n2++;
            z[n3] = z[n3] + 1;
            if (z[n3] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static int incAt(int len, int[] z, int zOff, int zPos) {
        for (int i2 = zPos; i2 < len; ++i2) {
            int n2 = zOff + i2;
            z[n2] = z[n2] + 1;
            if (z[n2] == 0) continue;
            return 0;
        }
        return 1;
    }

    public static boolean isOne(int len, int[] x) {
        if (x[0] != 1) {
            return false;
        }
        for (int i2 = 1; i2 < len; ++i2) {
            if (x[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int len, int[] x) {
        for (int i2 = 0; i2 < len; ++i2) {
            if (x[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static int lessThan(int len, int[] x, int[] y) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            l2 += ((long)x[i2] & 0xFFFFFFFFL) - ((long)y[i2] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int lessThan(int len, int[] x, int xOff, int[] y, int yOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            l2 += ((long)x[xOff + i2] & 0xFFFFFFFFL) - ((long)y[yOff + i2] & 0xFFFFFFFFL);
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static void mul(int len, int[] x, int[] y, int[] zz) {
        zz[len] = Nat.mulWord(len, x[0], y, zz);
        for (int i2 = 1; i2 < len; ++i2) {
            zz[i2 + len] = Nat.mulWordAddTo(len, x[i2], y, 0, zz, i2);
        }
    }

    public static void mul(int len, int[] x, int xOff, int[] y, int yOff, int[] zz, int zzOff) {
        zz[zzOff + len] = Nat.mulWord(len, x[xOff], y, yOff, zz, zzOff);
        for (int i2 = 1; i2 < len; ++i2) {
            zz[zzOff + i2 + len] = Nat.mulWordAddTo(len, x[xOff + i2], y, yOff, zz, zzOff + i2);
        }
    }

    public static void mul(int[] x, int xOff, int xLen, int[] y, int yOff, int yLen, int[] zz, int zzOff) {
        zz[zzOff + yLen] = Nat.mulWord(yLen, x[xOff], y, yOff, zz, zzOff);
        for (int i2 = 1; i2 < xLen; ++i2) {
            zz[zzOff + i2 + yLen] = Nat.mulWordAddTo(yLen, x[xOff + i2], y, yOff, zz, zzOff + i2);
        }
    }

    public static int mulAddTo(int len, int[] x, int[] y, int[] zz) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            l2 += (long)Nat.mulWordAddTo(len, x[i2], y, 0, zz, i2) & 0xFFFFFFFFL;
            zz[i2 + len] = (int)(l2 += (long)zz[i2 + len] & 0xFFFFFFFFL);
            l2 >>>= 32;
        }
        return (int)l2;
    }

    public static int mulAddTo(int len, int[] x, int xOff, int[] y, int yOff, int[] zz, int zzOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            l2 += (long)Nat.mulWordAddTo(len, x[xOff + i2], y, yOff, zz, zzOff) & 0xFFFFFFFFL;
            zz[zzOff + len] = (int)(l2 += (long)zz[zzOff + len] & 0xFFFFFFFFL);
            l2 >>>= 32;
            ++zzOff;
        }
        return (int)l2;
    }

    public static int mul31BothAdd(int len, int a2, int[] x, int b2, int[] y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)a2 & 0xFFFFFFFFL;
        long l4 = (long)b2 & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z[zOff + n2] = (int)(l2 += l3 * ((long)x[n2] & 0xFFFFFFFFL) + l4 * ((long)y[n2] & 0xFFFFFFFFL) + ((long)z[zOff + n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < len);
        return (int)l2;
    }

    public static int mulWord(int len, int x, int[] y, int[] z) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z[n2] = (int)(l2 += l3 * ((long)y[n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < len);
        return (int)l2;
    }

    public static int mulWord(int len, int x, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z[zOff + n2] = (int)(l2 += l3 * ((long)y[yOff + n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < len);
        return (int)l2;
    }

    public static int mulWordAddTo(int len, int x, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z[zOff + n2] = (int)(l2 += l3 * ((long)y[yOff + n2] & 0xFFFFFFFFL) + ((long)z[zOff + n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < len);
        return (int)l2;
    }

    public static int mulWordDwordAddAt(int len, int x, long y, int[] z, int zPos) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        z[zPos + 0] = (int)(l2 += l3 * (y & 0xFFFFFFFFL) + ((long)z[zPos + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zPos + 1] = (int)(l2 += l3 * (y >>> 32) + ((long)z[zPos + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zPos + 2] = (int)(l2 += (long)z[zPos + 2] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(len, z, zPos + 3);
    }

    public static int shiftDownBit(int len, int[] z, int c2) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = z[n2];
            z[n2] = n3 >>> 1 | c2 << 31;
            c2 = n3;
        }
        return c2 << 31;
    }

    public static int shiftDownBit(int len, int[] z, int zOff, int c2) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = z[zOff + n2];
            z[zOff + n2] = n3 >>> 1 | c2 << 31;
            c2 = n3;
        }
        return c2 << 31;
    }

    public static int shiftDownBit(int len, int[] x, int c2, int[] z) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = x[n2];
            z[n2] = n3 >>> 1 | c2 << 31;
            c2 = n3;
        }
        return c2 << 31;
    }

    public static int shiftDownBit(int len, int[] x, int xOff, int c2, int[] z, int zOff) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = x[xOff + n2];
            z[zOff + n2] = n3 >>> 1 | c2 << 31;
            c2 = n3;
        }
        return c2 << 31;
    }

    public static int shiftDownBits(int len, int[] z, int bits, int c2) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = z[n2];
            z[n2] = n3 >>> bits | c2 << -bits;
            c2 = n3;
        }
        return c2 << -bits;
    }

    public static int shiftDownBits(int len, int[] z, int zOff, int bits, int c2) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = z[zOff + n2];
            z[zOff + n2] = n3 >>> bits | c2 << -bits;
            c2 = n3;
        }
        return c2 << -bits;
    }

    public static int shiftDownBits(int len, int[] x, int bits, int c2, int[] z) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = x[n2];
            z[n2] = n3 >>> bits | c2 << -bits;
            c2 = n3;
        }
        return c2 << -bits;
    }

    public static int shiftDownBits(int len, int[] x, int xOff, int bits, int c2, int[] z, int zOff) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = x[xOff + n2];
            z[zOff + n2] = n3 >>> bits | c2 << -bits;
            c2 = n3;
        }
        return c2 << -bits;
    }

    public static int shiftDownWord(int len, int[] z, int c2) {
        int n2 = len;
        while (--n2 >= 0) {
            int n3 = z[n2];
            z[n2] = c2;
            c2 = n3;
        }
        return c2;
    }

    public static int shiftUpBit(int len, int[] z, int c2) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = z[i2];
            z[i2] = n2 << 1 | c2 >>> 31;
            c2 = n2;
        }
        return c2 >>> 31;
    }

    public static int shiftUpBit(int len, int[] z, int zOff, int c2) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = z[zOff + i2];
            z[zOff + i2] = n2 << 1 | c2 >>> 31;
            c2 = n2;
        }
        return c2 >>> 31;
    }

    public static int shiftUpBit(int len, int[] x, int c2, int[] z) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = x[i2];
            z[i2] = n2 << 1 | c2 >>> 31;
            c2 = n2;
        }
        return c2 >>> 31;
    }

    public static int shiftUpBit(int len, int[] x, int xOff, int c2, int[] z, int zOff) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = x[xOff + i2];
            z[zOff + i2] = n2 << 1 | c2 >>> 31;
            c2 = n2;
        }
        return c2 >>> 31;
    }

    public static long shiftUpBit64(int len, long[] x, int xOff, long c2, long[] z, int zOff) {
        for (int i2 = 0; i2 < len; ++i2) {
            long l2 = x[xOff + i2];
            z[zOff + i2] = l2 << 1 | c2 >>> 63;
            c2 = l2;
        }
        return c2 >>> 63;
    }

    public static int shiftUpBits(int len, int[] z, int bits, int c2) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = z[i2];
            z[i2] = n2 << bits | c2 >>> -bits;
            c2 = n2;
        }
        return c2 >>> -bits;
    }

    public static int shiftUpBits(int len, int[] z, int zOff, int bits, int c2) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = z[zOff + i2];
            z[zOff + i2] = n2 << bits | c2 >>> -bits;
            c2 = n2;
        }
        return c2 >>> -bits;
    }

    public static long shiftUpBits64(int len, long[] z, int zOff, int bits, long c2) {
        for (int i2 = 0; i2 < len; ++i2) {
            long l2 = z[zOff + i2];
            z[zOff + i2] = l2 << bits | c2 >>> -bits;
            c2 = l2;
        }
        return c2 >>> -bits;
    }

    public static int shiftUpBits(int len, int[] x, int bits, int c2, int[] z) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = x[i2];
            z[i2] = n2 << bits | c2 >>> -bits;
            c2 = n2;
        }
        return c2 >>> -bits;
    }

    public static int shiftUpBits(int len, int[] x, int xOff, int bits, int c2, int[] z, int zOff) {
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = x[xOff + i2];
            z[zOff + i2] = n2 << bits | c2 >>> -bits;
            c2 = n2;
        }
        return c2 >>> -bits;
    }

    public static long shiftUpBits64(int len, long[] x, int xOff, int bits, long c2, long[] z, int zOff) {
        for (int i2 = 0; i2 < len; ++i2) {
            long l2 = x[xOff + i2];
            z[zOff + i2] = l2 << bits | c2 >>> -bits;
            c2 = l2;
        }
        return c2 >>> -bits;
    }

    public static void square(int len, int[] x, int[] zz) {
        long l2;
        int n2 = len << 1;
        int n3 = 0;
        int n4 = len;
        int n5 = n2;
        do {
            l2 = (long)x[--n4] & 0xFFFFFFFFL;
            long l3 = l2 * l2;
            zz[--n5] = n3 << 31 | (int)(l3 >>> 33);
            zz[--n5] = (int)(l3 >>> 1);
            n3 = (int)l3;
        } while (n4 > 0);
        l2 = 0L;
        int n6 = 2;
        for (int i2 = 1; i2 < len; ++i2) {
            l2 += (long)Nat.squareWordAddTo(x, i2, zz) & 0xFFFFFFFFL;
            l2 += (long)zz[n6] & 0xFFFFFFFFL;
            zz[n6++] = (int)l2;
            l2 >>>= 32;
            l2 += (long)zz[n6] & 0xFFFFFFFFL;
            zz[n6++] = (int)l2;
            l2 >>>= 32;
        }
        Nat.shiftUpBit(n2, zz, x[0] << 31);
    }

    public static void square(int len, int[] x, int xOff, int[] zz, int zzOff) {
        long l2;
        int n2 = len << 1;
        int n3 = 0;
        int n4 = len;
        int n5 = n2;
        do {
            l2 = (long)x[xOff + --n4] & 0xFFFFFFFFL;
            long l3 = l2 * l2;
            zz[zzOff + --n5] = n3 << 31 | (int)(l3 >>> 33);
            zz[zzOff + --n5] = (int)(l3 >>> 1);
            n3 = (int)l3;
        } while (n4 > 0);
        l2 = 0L;
        int n6 = zzOff + 2;
        for (int i2 = 1; i2 < len; ++i2) {
            l2 += (long)Nat.squareWordAddTo(x, xOff, i2, zz, zzOff) & 0xFFFFFFFFL;
            l2 += (long)zz[n6] & 0xFFFFFFFFL;
            zz[n6++] = (int)l2;
            l2 >>>= 32;
            l2 += (long)zz[n6] & 0xFFFFFFFFL;
            zz[n6++] = (int)l2;
            l2 >>>= 32;
        }
        Nat.shiftUpBit(n2, zz, zzOff, x[xOff] << 31);
    }

    public static int squareWordAddTo(int[] x, int xPos, int[] z) {
        long l2 = 0L;
        long l3 = (long)x[xPos] & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z[xPos + n2] = (int)(l2 += l3 * ((long)x[n2] & 0xFFFFFFFFL) + ((long)z[xPos + n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < xPos);
        return (int)l2;
    }

    public static int squareWordAddTo(int[] x, int xOff, int xPos, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x[xOff + xPos] & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z[xPos + zOff] = (int)(l2 += l3 * ((long)x[xOff + n2] & 0xFFFFFFFFL) + ((long)z[xPos + zOff] & 0xFFFFFFFFL));
            l2 >>>= 32;
            ++zOff;
        } while (++n2 < xPos);
        return (int)l2;
    }

    public static int sub(int len, int[] x, int[] y, int[] z) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[i2] = (int)(l2 += ((long)x[i2] & 0xFFFFFFFFL) - ((long)y[i2] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int sub(int len, int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[zOff + i2] = (int)(l2 += ((long)x[xOff + i2] & 0xFFFFFFFFL) - ((long)y[yOff + i2] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int sub33At(int len, int x, int[] z, int zPos) {
        long l2 = ((long)z[zPos + 0] & 0xFFFFFFFFL) - ((long)x & 0xFFFFFFFFL);
        z[zPos + 0] = (int)l2;
        l2 >>= 32;
        z[zPos + 1] = (int)(l2 += ((long)z[zPos + 1] & 0xFFFFFFFFL) - 1L);
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z, zPos + 2);
    }

    public static int sub33At(int len, int x, int[] z, int zOff, int zPos) {
        long l2 = ((long)z[zOff + zPos] & 0xFFFFFFFFL) - ((long)x & 0xFFFFFFFFL);
        z[zOff + zPos] = (int)l2;
        l2 >>= 32;
        z[zOff + zPos + 1] = (int)(l2 += ((long)z[zOff + zPos + 1] & 0xFFFFFFFFL) - 1L);
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z, zOff, zPos + 2);
    }

    public static int sub33From(int len, int x, int[] z) {
        long l2 = ((long)z[0] & 0xFFFFFFFFL) - ((long)x & 0xFFFFFFFFL);
        z[0] = (int)l2;
        l2 >>= 32;
        z[1] = (int)(l2 += ((long)z[1] & 0xFFFFFFFFL) - 1L);
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z, 2);
    }

    public static int sub33From(int len, int x, int[] z, int zOff) {
        long l2 = ((long)z[zOff + 0] & 0xFFFFFFFFL) - ((long)x & 0xFFFFFFFFL);
        z[zOff + 0] = (int)l2;
        l2 >>= 32;
        z[zOff + 1] = (int)(l2 += ((long)z[zOff + 1] & 0xFFFFFFFFL) - 1L);
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z, zOff, 2);
    }

    public static int subBothFrom(int len, int[] x, int[] y, int[] z) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[i2] = (int)(l2 += ((long)z[i2] & 0xFFFFFFFFL) - ((long)x[i2] & 0xFFFFFFFFL) - ((long)y[i2] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int subBothFrom(int len, int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[zOff + i2] = (int)(l2 += ((long)z[zOff + i2] & 0xFFFFFFFFL) - ((long)x[xOff + i2] & 0xFFFFFFFFL) - ((long)y[yOff + i2] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int subDWordAt(int len, long x, int[] z, int zPos) {
        long l2 = ((long)z[zPos + 0] & 0xFFFFFFFFL) - (x & 0xFFFFFFFFL);
        z[zPos + 0] = (int)l2;
        l2 >>= 32;
        z[zPos + 1] = (int)(l2 += ((long)z[zPos + 1] & 0xFFFFFFFFL) - (x >>> 32));
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z, zPos + 2);
    }

    public static int subDWordAt(int len, long x, int[] z, int zOff, int zPos) {
        long l2 = ((long)z[zOff + zPos] & 0xFFFFFFFFL) - (x & 0xFFFFFFFFL);
        z[zOff + zPos] = (int)l2;
        l2 >>= 32;
        z[zOff + zPos + 1] = (int)(l2 += ((long)z[zOff + zPos + 1] & 0xFFFFFFFFL) - (x >>> 32));
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z, zOff, zPos + 2);
    }

    public static int subDWordFrom(int len, long x, int[] z) {
        long l2 = ((long)z[0] & 0xFFFFFFFFL) - (x & 0xFFFFFFFFL);
        z[0] = (int)l2;
        l2 >>= 32;
        z[1] = (int)(l2 += ((long)z[1] & 0xFFFFFFFFL) - (x >>> 32));
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z, 2);
    }

    public static int subDWordFrom(int len, long x, int[] z, int zOff) {
        long l2 = ((long)z[zOff + 0] & 0xFFFFFFFFL) - (x & 0xFFFFFFFFL);
        z[zOff + 0] = (int)l2;
        l2 >>= 32;
        z[zOff + 1] = (int)(l2 += ((long)z[zOff + 1] & 0xFFFFFFFFL) - (x >>> 32));
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z, zOff, 2);
    }

    public static int subFrom(int len, int[] x, int[] z) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[i2] = (int)(l2 += ((long)z[i2] & 0xFFFFFFFFL) - ((long)x[i2] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int subFrom(int len, int[] x, int xOff, int[] z, int zOff) {
        long l2 = 0L;
        for (int i2 = 0; i2 < len; ++i2) {
            z[zOff + i2] = (int)(l2 += ((long)z[zOff + i2] & 0xFFFFFFFFL) - ((long)x[xOff + i2] & 0xFFFFFFFFL));
            l2 >>= 32;
        }
        return (int)l2;
    }

    public static int subWordAt(int len, int x, int[] z, int zPos) {
        long l2 = ((long)z[zPos] & 0xFFFFFFFFL) - ((long)x & 0xFFFFFFFFL);
        z[zPos] = (int)l2;
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z, zPos + 1);
    }

    public static int subWordAt(int len, int x, int[] z, int zOff, int zPos) {
        long l2 = ((long)z[zOff + zPos] & 0xFFFFFFFFL) - ((long)x & 0xFFFFFFFFL);
        z[zOff + zPos] = (int)l2;
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z, zOff, zPos + 1);
    }

    public static int subWordFrom(int len, int x, int[] z) {
        long l2 = ((long)z[0] & 0xFFFFFFFFL) - ((long)x & 0xFFFFFFFFL);
        z[0] = (int)l2;
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z, 1);
    }

    public static int subWordFrom(int len, int x, int[] z, int zOff) {
        long l2 = ((long)z[zOff + 0] & 0xFFFFFFFFL) - ((long)x & 0xFFFFFFFFL);
        z[zOff + 0] = (int)l2;
        return (l2 >>= 32) == 0L ? 0 : Nat.decAt(len, z, zOff, 1);
    }

    public static BigInteger toBigInteger(int len, int[] x) {
        byte[] byArray = new byte[len << 2];
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = x[i2];
            if (n2 == 0) continue;
            Pack.intToBigEndian(n2, byArray, len - 1 - i2 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int len, int[] z) {
        for (int i2 = 0; i2 < len; ++i2) {
            z[i2] = 0;
        }
    }

    public static void zero(int len, int[] z, int zOff) {
        for (int i2 = 0; i2 < len; ++i2) {
            z[zOff + i2] = 0;
        }
    }

    public static void zero64(int len, long[] z) {
        for (int i2 = 0; i2 < len; ++i2) {
            z[i2] = 0L;
        }
    }
}

