/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat224 {
    public static int add(int[] x, int[] y, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) + ((long)y[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) + ((long)y[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) + ((long)y[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) + ((long)y[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[4] = (int)(l2 += ((long)x[4] & 0xFFFFFFFFL) + ((long)y[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[5] = (int)(l2 += ((long)x[5] & 0xFFFFFFFFL) + ((long)y[5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[6] = (int)(l2 += ((long)x[6] & 0xFFFFFFFFL) + ((long)y[6] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int add(int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        z[zOff + 0] = (int)(l2 += ((long)x[xOff + 0] & 0xFFFFFFFFL) + ((long)y[yOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += ((long)x[xOff + 1] & 0xFFFFFFFFL) + ((long)y[yOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += ((long)x[xOff + 2] & 0xFFFFFFFFL) + ((long)y[yOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 3] = (int)(l2 += ((long)x[xOff + 3] & 0xFFFFFFFFL) + ((long)y[yOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 4] = (int)(l2 += ((long)x[xOff + 4] & 0xFFFFFFFFL) + ((long)y[yOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 5] = (int)(l2 += ((long)x[xOff + 5] & 0xFFFFFFFFL) + ((long)y[yOff + 5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 6] = (int)(l2 += ((long)x[xOff + 6] & 0xFFFFFFFFL) + ((long)y[yOff + 6] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addBothTo(int[] x, int[] y, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) + ((long)y[0] & 0xFFFFFFFFL) + ((long)z[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) + ((long)y[1] & 0xFFFFFFFFL) + ((long)z[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) + ((long)y[2] & 0xFFFFFFFFL) + ((long)z[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) + ((long)y[3] & 0xFFFFFFFFL) + ((long)z[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[4] = (int)(l2 += ((long)x[4] & 0xFFFFFFFFL) + ((long)y[4] & 0xFFFFFFFFL) + ((long)z[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[5] = (int)(l2 += ((long)x[5] & 0xFFFFFFFFL) + ((long)y[5] & 0xFFFFFFFFL) + ((long)z[5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[6] = (int)(l2 += ((long)x[6] & 0xFFFFFFFFL) + ((long)y[6] & 0xFFFFFFFFL) + ((long)z[6] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addBothTo(int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        z[zOff + 0] = (int)(l2 += ((long)x[xOff + 0] & 0xFFFFFFFFL) + ((long)y[yOff + 0] & 0xFFFFFFFFL) + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += ((long)x[xOff + 1] & 0xFFFFFFFFL) + ((long)y[yOff + 1] & 0xFFFFFFFFL) + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += ((long)x[xOff + 2] & 0xFFFFFFFFL) + ((long)y[yOff + 2] & 0xFFFFFFFFL) + ((long)z[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 3] = (int)(l2 += ((long)x[xOff + 3] & 0xFFFFFFFFL) + ((long)y[yOff + 3] & 0xFFFFFFFFL) + ((long)z[zOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 4] = (int)(l2 += ((long)x[xOff + 4] & 0xFFFFFFFFL) + ((long)y[yOff + 4] & 0xFFFFFFFFL) + ((long)z[zOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 5] = (int)(l2 += ((long)x[xOff + 5] & 0xFFFFFFFFL) + ((long)y[yOff + 5] & 0xFFFFFFFFL) + ((long)z[zOff + 5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 6] = (int)(l2 += ((long)x[xOff + 6] & 0xFFFFFFFFL) + ((long)y[yOff + 6] & 0xFFFFFFFFL) + ((long)z[zOff + 6] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addTo(int[] x, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) + ((long)z[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) + ((long)z[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) + ((long)z[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) + ((long)z[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[4] = (int)(l2 += ((long)x[4] & 0xFFFFFFFFL) + ((long)z[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[5] = (int)(l2 += ((long)x[5] & 0xFFFFFFFFL) + ((long)z[5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[6] = (int)(l2 += ((long)x[6] & 0xFFFFFFFFL) + ((long)z[6] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addTo(int[] x, int[] z, int cIn) {
        long l2 = (long)cIn & 0xFFFFFFFFL;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) + ((long)z[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) + ((long)z[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) + ((long)z[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) + ((long)z[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[4] = (int)(l2 += ((long)x[4] & 0xFFFFFFFFL) + ((long)z[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[5] = (int)(l2 += ((long)x[5] & 0xFFFFFFFFL) + ((long)z[5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[6] = (int)(l2 += ((long)x[6] & 0xFFFFFFFFL) + ((long)z[6] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addTo(int[] x, int xOff, int[] z, int zOff, int cIn) {
        long l2 = (long)cIn & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += ((long)x[xOff + 0] & 0xFFFFFFFFL) + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += ((long)x[xOff + 1] & 0xFFFFFFFFL) + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += ((long)x[xOff + 2] & 0xFFFFFFFFL) + ((long)z[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 3] = (int)(l2 += ((long)x[xOff + 3] & 0xFFFFFFFFL) + ((long)z[zOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 4] = (int)(l2 += ((long)x[xOff + 4] & 0xFFFFFFFFL) + ((long)z[zOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 5] = (int)(l2 += ((long)x[xOff + 5] & 0xFFFFFFFFL) + ((long)z[zOff + 5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 6] = (int)(l2 += ((long)x[xOff + 6] & 0xFFFFFFFFL) + ((long)z[zOff + 6] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int addToEachOther(int[] u2, int uOff, int[] v2, int vOff) {
        long l2 = 0L;
        u2[uOff + 0] = (int)(l2 += ((long)u2[uOff + 0] & 0xFFFFFFFFL) + ((long)v2[vOff + 0] & 0xFFFFFFFFL));
        v2[vOff + 0] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 1] = (int)(l2 += ((long)u2[uOff + 1] & 0xFFFFFFFFL) + ((long)v2[vOff + 1] & 0xFFFFFFFFL));
        v2[vOff + 1] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 2] = (int)(l2 += ((long)u2[uOff + 2] & 0xFFFFFFFFL) + ((long)v2[vOff + 2] & 0xFFFFFFFFL));
        v2[vOff + 2] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 3] = (int)(l2 += ((long)u2[uOff + 3] & 0xFFFFFFFFL) + ((long)v2[vOff + 3] & 0xFFFFFFFFL));
        v2[vOff + 3] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 4] = (int)(l2 += ((long)u2[uOff + 4] & 0xFFFFFFFFL) + ((long)v2[vOff + 4] & 0xFFFFFFFFL));
        v2[vOff + 4] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 5] = (int)(l2 += ((long)u2[uOff + 5] & 0xFFFFFFFFL) + ((long)v2[vOff + 5] & 0xFFFFFFFFL));
        v2[vOff + 5] = (int)l2;
        l2 >>>= 32;
        u2[uOff + 6] = (int)(l2 += ((long)u2[uOff + 6] & 0xFFFFFFFFL) + ((long)v2[vOff + 6] & 0xFFFFFFFFL));
        v2[vOff + 6] = (int)l2;
        return (int)(l2 >>>= 32);
    }

    public static void copy(int[] x, int[] z) {
        z[0] = x[0];
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
        z[4] = x[4];
        z[5] = x[5];
        z[6] = x[6];
    }

    public static void copy(int[] x, int xOff, int[] z, int zOff) {
        z[zOff + 0] = x[xOff + 0];
        z[zOff + 1] = x[xOff + 1];
        z[zOff + 2] = x[xOff + 2];
        z[zOff + 3] = x[xOff + 3];
        z[zOff + 4] = x[xOff + 4];
        z[zOff + 5] = x[xOff + 5];
        z[zOff + 6] = x[xOff + 6];
    }

    public static int[] create() {
        return new int[7];
    }

    public static int[] createExt() {
        return new int[14];
    }

    public static boolean diff(int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        boolean bl = Nat224.gte(x, xOff, y, yOff);
        if (bl) {
            Nat224.sub(x, xOff, y, yOff, z, zOff);
        } else {
            Nat224.sub(y, yOff, x, xOff, z, zOff);
        }
        return bl;
    }

    public static boolean eq(int[] x, int[] y) {
        for (int i2 = 6; i2 >= 0; --i2) {
            if (x[i2] == y[i2]) continue;
            return false;
        }
        return true;
    }

    public static int[] fromBigInteger(BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > 224) {
            throw new IllegalArgumentException();
        }
        int[] nArray = Nat224.create();
        for (int i2 = 0; i2 < 7; ++i2) {
            nArray[i2] = x.intValue();
            x = x.shiftRight(32);
        }
        return nArray;
    }

    public static int getBit(int[] x, int bit) {
        if (bit == 0) {
            return x[0] & 1;
        }
        int n2 = bit >> 5;
        if (n2 < 0 || n2 >= 7) {
            return 0;
        }
        int n3 = bit & 0x1F;
        return x[n2] >>> n3 & 1;
    }

    public static boolean gte(int[] x, int[] y) {
        for (int i2 = 6; i2 >= 0; --i2) {
            int n2 = x[i2] ^ Integer.MIN_VALUE;
            int n3 = y[i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static boolean gte(int[] x, int xOff, int[] y, int yOff) {
        for (int i2 = 6; i2 >= 0; --i2) {
            int n2 = x[xOff + i2] ^ Integer.MIN_VALUE;
            int n3 = y[yOff + i2] ^ Integer.MIN_VALUE;
            if (n2 < n3) {
                return false;
            }
            if (n2 <= n3) continue;
            return true;
        }
        return true;
    }

    public static boolean isOne(int[] x) {
        if (x[0] != 1) {
            return false;
        }
        for (int i2 = 1; i2 < 7; ++i2) {
            if (x[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero(int[] x) {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (x[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] x, int[] y, int[] zz) {
        long l2 = (long)y[0] & 0xFFFFFFFFL;
        long l3 = (long)y[1] & 0xFFFFFFFFL;
        long l4 = (long)y[2] & 0xFFFFFFFFL;
        long l5 = (long)y[3] & 0xFFFFFFFFL;
        long l6 = (long)y[4] & 0xFFFFFFFFL;
        long l7 = (long)y[5] & 0xFFFFFFFFL;
        long l8 = (long)y[6] & 0xFFFFFFFFL;
        long l9 = 0L;
        long l10 = (long)x[0] & 0xFFFFFFFFL;
        zz[0] = (int)(l9 += l10 * l2);
        l9 >>>= 32;
        zz[1] = (int)(l9 += l10 * l3);
        l9 >>>= 32;
        zz[2] = (int)(l9 += l10 * l4);
        l9 >>>= 32;
        zz[3] = (int)(l9 += l10 * l5);
        l9 >>>= 32;
        zz[4] = (int)(l9 += l10 * l6);
        l9 >>>= 32;
        zz[5] = (int)(l9 += l10 * l7);
        l9 >>>= 32;
        zz[6] = (int)(l9 += l10 * l8);
        zz[7] = (int)(l9 >>>= 32);
        for (int i2 = 1; i2 < 7; ++i2) {
            long l11 = 0L;
            long l12 = (long)x[i2] & 0xFFFFFFFFL;
            zz[i2 + 0] = (int)(l11 += l12 * l2 + ((long)zz[i2 + 0] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 1] = (int)(l11 += l12 * l3 + ((long)zz[i2 + 1] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 2] = (int)(l11 += l12 * l4 + ((long)zz[i2 + 2] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 3] = (int)(l11 += l12 * l5 + ((long)zz[i2 + 3] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 4] = (int)(l11 += l12 * l6 + ((long)zz[i2 + 4] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 5] = (int)(l11 += l12 * l7 + ((long)zz[i2 + 5] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[i2 + 6] = (int)(l11 += l12 * l8 + ((long)zz[i2 + 6] & 0xFFFFFFFFL));
            zz[i2 + 7] = (int)(l11 >>>= 32);
        }
    }

    public static void mul(int[] x, int xOff, int[] y, int yOff, int[] zz, int zzOff) {
        long l2 = (long)y[yOff + 0] & 0xFFFFFFFFL;
        long l3 = (long)y[yOff + 1] & 0xFFFFFFFFL;
        long l4 = (long)y[yOff + 2] & 0xFFFFFFFFL;
        long l5 = (long)y[yOff + 3] & 0xFFFFFFFFL;
        long l6 = (long)y[yOff + 4] & 0xFFFFFFFFL;
        long l7 = (long)y[yOff + 5] & 0xFFFFFFFFL;
        long l8 = (long)y[yOff + 6] & 0xFFFFFFFFL;
        long l9 = 0L;
        long l10 = (long)x[xOff + 0] & 0xFFFFFFFFL;
        zz[zzOff + 0] = (int)(l9 += l10 * l2);
        l9 >>>= 32;
        zz[zzOff + 1] = (int)(l9 += l10 * l3);
        l9 >>>= 32;
        zz[zzOff + 2] = (int)(l9 += l10 * l4);
        l9 >>>= 32;
        zz[zzOff + 3] = (int)(l9 += l10 * l5);
        l9 >>>= 32;
        zz[zzOff + 4] = (int)(l9 += l10 * l6);
        l9 >>>= 32;
        zz[zzOff + 5] = (int)(l9 += l10 * l7);
        l9 >>>= 32;
        zz[zzOff + 6] = (int)(l9 += l10 * l8);
        zz[zzOff + 7] = (int)(l9 >>>= 32);
        for (int i2 = 1; i2 < 7; ++i2) {
            long l11 = 0L;
            long l12 = (long)x[xOff + i2] & 0xFFFFFFFFL;
            zz[zzOff + 0] = (int)(l11 += l12 * l2 + ((long)zz[++zzOff + 0] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 1] = (int)(l11 += l12 * l3 + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 2] = (int)(l11 += l12 * l4 + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 3] = (int)(l11 += l12 * l5 + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 4] = (int)(l11 += l12 * l6 + ((long)zz[zzOff + 4] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 5] = (int)(l11 += l12 * l7 + ((long)zz[zzOff + 5] & 0xFFFFFFFFL));
            l11 >>>= 32;
            zz[zzOff + 6] = (int)(l11 += l12 * l8 + ((long)zz[zzOff + 6] & 0xFFFFFFFFL));
            zz[zzOff + 7] = (int)(l11 >>>= 32);
        }
    }

    public static int mulAddTo(int[] x, int[] y, int[] zz) {
        long l2 = (long)y[0] & 0xFFFFFFFFL;
        long l3 = (long)y[1] & 0xFFFFFFFFL;
        long l4 = (long)y[2] & 0xFFFFFFFFL;
        long l5 = (long)y[3] & 0xFFFFFFFFL;
        long l6 = (long)y[4] & 0xFFFFFFFFL;
        long l7 = (long)y[5] & 0xFFFFFFFFL;
        long l8 = (long)y[6] & 0xFFFFFFFFL;
        long l9 = 0L;
        for (int i2 = 0; i2 < 7; ++i2) {
            long l10 = 0L;
            long l11 = (long)x[i2] & 0xFFFFFFFFL;
            zz[i2 + 0] = (int)(l10 += l11 * l2 + ((long)zz[i2 + 0] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[i2 + 1] = (int)(l10 += l11 * l3 + ((long)zz[i2 + 1] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[i2 + 2] = (int)(l10 += l11 * l4 + ((long)zz[i2 + 2] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[i2 + 3] = (int)(l10 += l11 * l5 + ((long)zz[i2 + 3] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[i2 + 4] = (int)(l10 += l11 * l6 + ((long)zz[i2 + 4] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[i2 + 5] = (int)(l10 += l11 * l7 + ((long)zz[i2 + 5] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[i2 + 6] = (int)(l10 += l11 * l8 + ((long)zz[i2 + 6] & 0xFFFFFFFFL));
            zz[i2 + 7] = (int)(l9 += (l10 >>>= 32) + ((long)zz[i2 + 7] & 0xFFFFFFFFL));
            l9 >>>= 32;
        }
        return (int)l9;
    }

    public static int mulAddTo(int[] x, int xOff, int[] y, int yOff, int[] zz, int zzOff) {
        long l2 = (long)y[yOff + 0] & 0xFFFFFFFFL;
        long l3 = (long)y[yOff + 1] & 0xFFFFFFFFL;
        long l4 = (long)y[yOff + 2] & 0xFFFFFFFFL;
        long l5 = (long)y[yOff + 3] & 0xFFFFFFFFL;
        long l6 = (long)y[yOff + 4] & 0xFFFFFFFFL;
        long l7 = (long)y[yOff + 5] & 0xFFFFFFFFL;
        long l8 = (long)y[yOff + 6] & 0xFFFFFFFFL;
        long l9 = 0L;
        for (int i2 = 0; i2 < 7; ++i2) {
            long l10 = 0L;
            long l11 = (long)x[xOff + i2] & 0xFFFFFFFFL;
            zz[zzOff + 0] = (int)(l10 += l11 * l2 + ((long)zz[zzOff + 0] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[zzOff + 1] = (int)(l10 += l11 * l3 + ((long)zz[zzOff + 1] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[zzOff + 2] = (int)(l10 += l11 * l4 + ((long)zz[zzOff + 2] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[zzOff + 3] = (int)(l10 += l11 * l5 + ((long)zz[zzOff + 3] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[zzOff + 4] = (int)(l10 += l11 * l6 + ((long)zz[zzOff + 4] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[zzOff + 5] = (int)(l10 += l11 * l7 + ((long)zz[zzOff + 5] & 0xFFFFFFFFL));
            l10 >>>= 32;
            zz[zzOff + 6] = (int)(l10 += l11 * l8 + ((long)zz[zzOff + 6] & 0xFFFFFFFFL));
            zz[zzOff + 7] = (int)(l9 += (l10 >>>= 32) + ((long)zz[zzOff + 7] & 0xFFFFFFFFL));
            l9 >>>= 32;
            ++zzOff;
        }
        return (int)l9;
    }

    public static long mul33Add(int w, int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)w & 0xFFFFFFFFL;
        long l4 = (long)x[xOff + 0] & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l3 * l4 + ((long)y[yOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l5 = (long)x[xOff + 1] & 0xFFFFFFFFL;
        z[zOff + 1] = (int)(l2 += l3 * l5 + l4 + ((long)y[yOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l6 = (long)x[xOff + 2] & 0xFFFFFFFFL;
        z[zOff + 2] = (int)(l2 += l3 * l6 + l5 + ((long)y[yOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l7 = (long)x[xOff + 3] & 0xFFFFFFFFL;
        z[zOff + 3] = (int)(l2 += l3 * l7 + l6 + ((long)y[yOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l8 = (long)x[xOff + 4] & 0xFFFFFFFFL;
        z[zOff + 4] = (int)(l2 += l3 * l8 + l7 + ((long)y[yOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l9 = (long)x[xOff + 5] & 0xFFFFFFFFL;
        z[zOff + 5] = (int)(l2 += l3 * l9 + l8 + ((long)y[yOff + 5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l10 = (long)x[xOff + 6] & 0xFFFFFFFFL;
        z[zOff + 6] = (int)(l2 += l3 * l10 + l9 + ((long)y[yOff + 6] & 0xFFFFFFFFL));
        l2 >>>= 32;
        return l2 += l10;
    }

    public static int mulByWord(int x, int[] z) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        z[0] = (int)(l2 += l3 * ((long)z[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[1] = (int)(l2 += l3 * ((long)z[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[2] = (int)(l2 += l3 * ((long)z[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[3] = (int)(l2 += l3 * ((long)z[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[4] = (int)(l2 += l3 * ((long)z[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[5] = (int)(l2 += l3 * ((long)z[5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[6] = (int)(l2 += l3 * ((long)z[6] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int mulByWordAddTo(int x, int[] y, int[] z) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        z[0] = (int)(l2 += l3 * ((long)z[0] & 0xFFFFFFFFL) + ((long)y[0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[1] = (int)(l2 += l3 * ((long)z[1] & 0xFFFFFFFFL) + ((long)y[1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[2] = (int)(l2 += l3 * ((long)z[2] & 0xFFFFFFFFL) + ((long)y[2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[3] = (int)(l2 += l3 * ((long)z[3] & 0xFFFFFFFFL) + ((long)y[3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[4] = (int)(l2 += l3 * ((long)z[4] & 0xFFFFFFFFL) + ((long)y[4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[5] = (int)(l2 += l3 * ((long)z[5] & 0xFFFFFFFFL) + ((long)y[5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[6] = (int)(l2 += l3 * ((long)z[6] & 0xFFFFFFFFL) + ((long)y[6] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int mulWordAddTo(int x, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l3 * ((long)y[yOff + 0] & 0xFFFFFFFFL) + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += l3 * ((long)y[yOff + 1] & 0xFFFFFFFFL) + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += l3 * ((long)y[yOff + 2] & 0xFFFFFFFFL) + ((long)z[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 3] = (int)(l2 += l3 * ((long)y[yOff + 3] & 0xFFFFFFFFL) + ((long)z[zOff + 3] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 4] = (int)(l2 += l3 * ((long)y[yOff + 4] & 0xFFFFFFFFL) + ((long)z[zOff + 4] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 5] = (int)(l2 += l3 * ((long)y[yOff + 5] & 0xFFFFFFFFL) + ((long)z[zOff + 5] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 6] = (int)(l2 += l3 * ((long)y[yOff + 6] & 0xFFFFFFFFL) + ((long)z[zOff + 6] & 0xFFFFFFFFL));
        return (int)(l2 >>>= 32);
    }

    public static int mul33DWordAdd(int x, long y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        long l4 = y & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l3 * l4 + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        long l5 = y >>> 32;
        z[zOff + 1] = (int)(l2 += l3 * l5 + l4 + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += l5 + ((long)z[zOff + 2] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 3] = (int)(l2 += (long)z[zOff + 3] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(7, z, zOff, 4);
    }

    public static int mul33WordAdd(int x, int y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        long l4 = (long)y & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l4 * l3 + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += l4 + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += (long)z[zOff + 2] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(7, z, zOff, 3);
    }

    public static int mulWordDwordAdd(int x, long y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        z[zOff + 0] = (int)(l2 += l3 * (y & 0xFFFFFFFFL) + ((long)z[zOff + 0] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 1] = (int)(l2 += l3 * (y >>> 32) + ((long)z[zOff + 1] & 0xFFFFFFFFL));
        l2 >>>= 32;
        z[zOff + 2] = (int)(l2 += (long)z[zOff + 2] & 0xFFFFFFFFL);
        return (l2 >>>= 32) == 0L ? 0 : Nat.incAt(7, z, zOff, 3);
    }

    public static int mulWord(int x, int[] y, int[] z, int zOff) {
        long l2 = 0L;
        long l3 = (long)x & 0xFFFFFFFFL;
        int n2 = 0;
        do {
            z[zOff + n2] = (int)(l2 += l3 * ((long)y[n2] & 0xFFFFFFFFL));
            l2 >>>= 32;
        } while (++n2 < 7);
        return (int)l2;
    }

    public static void square(int[] x, int[] zz) {
        long l2;
        long l3;
        long l4 = (long)x[0] & 0xFFFFFFFFL;
        int n2 = 0;
        int n3 = 6;
        int n4 = 14;
        do {
            l3 = (long)x[n3--] & 0xFFFFFFFFL;
            l2 = l3 * l3;
            zz[--n4] = n2 << 31 | (int)(l2 >>> 33);
            zz[--n4] = (int)(l2 >>> 1);
            n2 = (int)l2;
        } while (n3 > 0);
        l3 = l4 * l4;
        long l5 = (long)(n2 << 31) & 0xFFFFFFFFL | l3 >>> 33;
        zz[0] = (int)l3;
        n2 = (int)(l3 >>> 32) & 1;
        long l6 = (long)x[1] & 0xFFFFFFFFL;
        l3 = (long)zz[2] & 0xFFFFFFFFL;
        int n5 = (int)(l5 += l6 * l4);
        zz[1] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l3 += l5 >>> 32;
        l2 = (long)x[2] & 0xFFFFFFFFL;
        long l7 = (long)zz[3] & 0xFFFFFFFFL;
        long l8 = (long)zz[4] & 0xFFFFFFFFL;
        n5 = (int)(l3 += l2 * l4);
        zz[2] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l7 &= 0xFFFFFFFFL;
        long l9 = (long)x[3] & 0xFFFFFFFFL;
        long l10 = ((long)zz[5] & 0xFFFFFFFFL) + ((l8 += (l7 += (l3 >>> 32) + l2 * l6) >>> 32) >>> 32);
        l8 &= 0xFFFFFFFFL;
        long l11 = ((long)zz[6] & 0xFFFFFFFFL) + (l10 >>> 32);
        l10 &= 0xFFFFFFFFL;
        n5 = (int)(l7 += l9 * l4);
        zz[3] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l8 &= 0xFFFFFFFFL;
        l10 &= 0xFFFFFFFFL;
        long l12 = (long)x[4] & 0xFFFFFFFFL;
        long l13 = ((long)zz[7] & 0xFFFFFFFFL) + ((l11 += (l10 += ((l8 += (l7 >>> 32) + l9 * l6) >>> 32) + l9 * l2) >>> 32) >>> 32);
        l11 &= 0xFFFFFFFFL;
        long l14 = ((long)zz[8] & 0xFFFFFFFFL) + (l13 >>> 32);
        l13 &= 0xFFFFFFFFL;
        n5 = (int)(l8 += l12 * l4);
        zz[4] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l10 &= 0xFFFFFFFFL;
        l11 &= 0xFFFFFFFFL;
        l13 &= 0xFFFFFFFFL;
        long l15 = (long)x[5] & 0xFFFFFFFFL;
        long l16 = ((long)zz[9] & 0xFFFFFFFFL) + ((l14 += (l13 += ((l11 += ((l10 += (l8 >>> 32) + l12 * l6) >>> 32) + l12 * l2) >>> 32) + l12 * l9) >>> 32) >>> 32);
        l14 &= 0xFFFFFFFFL;
        long l17 = ((long)zz[10] & 0xFFFFFFFFL) + (l16 >>> 32);
        l16 &= 0xFFFFFFFFL;
        n5 = (int)(l10 += l15 * l4);
        zz[5] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l11 &= 0xFFFFFFFFL;
        l13 &= 0xFFFFFFFFL;
        l14 &= 0xFFFFFFFFL;
        l16 &= 0xFFFFFFFFL;
        long l18 = (long)x[6] & 0xFFFFFFFFL;
        long l19 = ((long)zz[11] & 0xFFFFFFFFL) + ((l17 += (l16 += ((l14 += ((l13 += ((l11 += (l10 >>> 32) + l15 * l6) >>> 32) + l15 * l2) >>> 32) + l15 * l9) >>> 32) + l15 * l12) >>> 32) >>> 32);
        l17 &= 0xFFFFFFFFL;
        long l20 = ((long)zz[12] & 0xFFFFFFFFL) + (l19 >>> 32);
        l19 &= 0xFFFFFFFFL;
        n5 = (int)(l11 += l18 * l4);
        zz[6] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l20 += (l19 += ((l17 += ((l16 += ((l14 += ((l13 += (l11 >>> 32) + l18 * l6) >>> 32) + l18 * l2) >>> 32) + l18 * l9) >>> 32) + l18 * l12) >>> 32) + l18 * l15) >>> 32;
        n5 = (int)l13;
        zz[7] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l14;
        zz[8] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l16;
        zz[9] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l17;
        zz[10] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l19;
        zz[11] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l20;
        zz[12] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = zz[13] + (int)(l20 >>> 32);
        zz[13] = n5 << 1 | n2;
    }

    public static void square(int[] x, int xOff, int[] zz, int zzOff) {
        long l2;
        long l3;
        long l4 = (long)x[xOff + 0] & 0xFFFFFFFFL;
        int n2 = 0;
        int n3 = 6;
        int n4 = 14;
        do {
            l3 = (long)x[xOff + n3--] & 0xFFFFFFFFL;
            l2 = l3 * l3;
            zz[zzOff + --n4] = n2 << 31 | (int)(l2 >>> 33);
            zz[zzOff + --n4] = (int)(l2 >>> 1);
            n2 = (int)l2;
        } while (n3 > 0);
        l3 = l4 * l4;
        long l5 = (long)(n2 << 31) & 0xFFFFFFFFL | l3 >>> 33;
        zz[zzOff + 0] = (int)l3;
        n2 = (int)(l3 >>> 32) & 1;
        long l6 = (long)x[xOff + 1] & 0xFFFFFFFFL;
        l3 = (long)zz[zzOff + 2] & 0xFFFFFFFFL;
        int n5 = (int)(l5 += l6 * l4);
        zz[zzOff + 1] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l3 += l5 >>> 32;
        l2 = (long)x[xOff + 2] & 0xFFFFFFFFL;
        long l7 = (long)zz[zzOff + 3] & 0xFFFFFFFFL;
        long l8 = (long)zz[zzOff + 4] & 0xFFFFFFFFL;
        n5 = (int)(l3 += l2 * l4);
        zz[zzOff + 2] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l7 &= 0xFFFFFFFFL;
        long l9 = (long)x[xOff + 3] & 0xFFFFFFFFL;
        long l10 = ((long)zz[zzOff + 5] & 0xFFFFFFFFL) + ((l8 += (l7 += (l3 >>> 32) + l2 * l6) >>> 32) >>> 32);
        l8 &= 0xFFFFFFFFL;
        long l11 = ((long)zz[zzOff + 6] & 0xFFFFFFFFL) + (l10 >>> 32);
        l10 &= 0xFFFFFFFFL;
        n5 = (int)(l7 += l9 * l4);
        zz[zzOff + 3] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l8 &= 0xFFFFFFFFL;
        l10 &= 0xFFFFFFFFL;
        long l12 = (long)x[xOff + 4] & 0xFFFFFFFFL;
        long l13 = ((long)zz[zzOff + 7] & 0xFFFFFFFFL) + ((l11 += (l10 += ((l8 += (l7 >>> 32) + l9 * l6) >>> 32) + l9 * l2) >>> 32) >>> 32);
        l11 &= 0xFFFFFFFFL;
        long l14 = ((long)zz[zzOff + 8] & 0xFFFFFFFFL) + (l13 >>> 32);
        l13 &= 0xFFFFFFFFL;
        n5 = (int)(l8 += l12 * l4);
        zz[zzOff + 4] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l10 &= 0xFFFFFFFFL;
        l11 &= 0xFFFFFFFFL;
        l13 &= 0xFFFFFFFFL;
        long l15 = (long)x[xOff + 5] & 0xFFFFFFFFL;
        long l16 = ((long)zz[zzOff + 9] & 0xFFFFFFFFL) + ((l14 += (l13 += ((l11 += ((l10 += (l8 >>> 32) + l12 * l6) >>> 32) + l12 * l2) >>> 32) + l12 * l9) >>> 32) >>> 32);
        l14 &= 0xFFFFFFFFL;
        long l17 = ((long)zz[zzOff + 10] & 0xFFFFFFFFL) + (l16 >>> 32);
        l16 &= 0xFFFFFFFFL;
        n5 = (int)(l10 += l15 * l4);
        zz[zzOff + 5] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l11 &= 0xFFFFFFFFL;
        l13 &= 0xFFFFFFFFL;
        l14 &= 0xFFFFFFFFL;
        l16 &= 0xFFFFFFFFL;
        long l18 = (long)x[xOff + 6] & 0xFFFFFFFFL;
        long l19 = ((long)zz[zzOff + 11] & 0xFFFFFFFFL) + ((l17 += (l16 += ((l14 += ((l13 += ((l11 += (l10 >>> 32) + l15 * l6) >>> 32) + l15 * l2) >>> 32) + l15 * l9) >>> 32) + l15 * l12) >>> 32) >>> 32);
        l17 &= 0xFFFFFFFFL;
        long l20 = ((long)zz[zzOff + 12] & 0xFFFFFFFFL) + (l19 >>> 32);
        l19 &= 0xFFFFFFFFL;
        n5 = (int)(l11 += l18 * l4);
        zz[zzOff + 6] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        l20 += (l19 += ((l17 += ((l16 += ((l14 += ((l13 += (l11 >>> 32) + l18 * l6) >>> 32) + l18 * l2) >>> 32) + l18 * l9) >>> 32) + l18 * l12) >>> 32) + l18 * l15) >>> 32;
        n5 = (int)l13;
        zz[zzOff + 7] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l14;
        zz[zzOff + 8] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l16;
        zz[zzOff + 9] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l17;
        zz[zzOff + 10] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l19;
        zz[zzOff + 11] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = (int)l20;
        zz[zzOff + 12] = n5 << 1 | n2;
        n2 = n5 >>> 31;
        n5 = zz[zzOff + 13] + (int)(l20 >>> 32);
        zz[zzOff + 13] = n5 << 1 | n2;
    }

    public static int sub(int[] x, int[] y, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)x[0] & 0xFFFFFFFFL) - ((long)y[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[1] = (int)(l2 += ((long)x[1] & 0xFFFFFFFFL) - ((long)y[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[2] = (int)(l2 += ((long)x[2] & 0xFFFFFFFFL) - ((long)y[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[3] = (int)(l2 += ((long)x[3] & 0xFFFFFFFFL) - ((long)y[3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[4] = (int)(l2 += ((long)x[4] & 0xFFFFFFFFL) - ((long)y[4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[5] = (int)(l2 += ((long)x[5] & 0xFFFFFFFFL) - ((long)y[5] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[6] = (int)(l2 += ((long)x[6] & 0xFFFFFFFFL) - ((long)y[6] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int sub(int[] x, int xOff, int[] y, int yOff, int[] z, int zOff) {
        long l2 = 0L;
        z[zOff + 0] = (int)(l2 += ((long)x[xOff + 0] & 0xFFFFFFFFL) - ((long)y[yOff + 0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 1] = (int)(l2 += ((long)x[xOff + 1] & 0xFFFFFFFFL) - ((long)y[yOff + 1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 2] = (int)(l2 += ((long)x[xOff + 2] & 0xFFFFFFFFL) - ((long)y[yOff + 2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 3] = (int)(l2 += ((long)x[xOff + 3] & 0xFFFFFFFFL) - ((long)y[yOff + 3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 4] = (int)(l2 += ((long)x[xOff + 4] & 0xFFFFFFFFL) - ((long)y[yOff + 4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 5] = (int)(l2 += ((long)x[xOff + 5] & 0xFFFFFFFFL) - ((long)y[yOff + 5] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 6] = (int)(l2 += ((long)x[xOff + 6] & 0xFFFFFFFFL) - ((long)y[yOff + 6] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subBothFrom(int[] x, int[] y, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)z[0] & 0xFFFFFFFFL) - ((long)x[0] & 0xFFFFFFFFL) - ((long)y[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[1] = (int)(l2 += ((long)z[1] & 0xFFFFFFFFL) - ((long)x[1] & 0xFFFFFFFFL) - ((long)y[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[2] = (int)(l2 += ((long)z[2] & 0xFFFFFFFFL) - ((long)x[2] & 0xFFFFFFFFL) - ((long)y[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[3] = (int)(l2 += ((long)z[3] & 0xFFFFFFFFL) - ((long)x[3] & 0xFFFFFFFFL) - ((long)y[3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[4] = (int)(l2 += ((long)z[4] & 0xFFFFFFFFL) - ((long)x[4] & 0xFFFFFFFFL) - ((long)y[4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[5] = (int)(l2 += ((long)z[5] & 0xFFFFFFFFL) - ((long)x[5] & 0xFFFFFFFFL) - ((long)y[5] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[6] = (int)(l2 += ((long)z[6] & 0xFFFFFFFFL) - ((long)x[6] & 0xFFFFFFFFL) - ((long)y[6] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subFrom(int[] x, int[] z) {
        long l2 = 0L;
        z[0] = (int)(l2 += ((long)z[0] & 0xFFFFFFFFL) - ((long)x[0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[1] = (int)(l2 += ((long)z[1] & 0xFFFFFFFFL) - ((long)x[1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[2] = (int)(l2 += ((long)z[2] & 0xFFFFFFFFL) - ((long)x[2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[3] = (int)(l2 += ((long)z[3] & 0xFFFFFFFFL) - ((long)x[3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[4] = (int)(l2 += ((long)z[4] & 0xFFFFFFFFL) - ((long)x[4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[5] = (int)(l2 += ((long)z[5] & 0xFFFFFFFFL) - ((long)x[5] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[6] = (int)(l2 += ((long)z[6] & 0xFFFFFFFFL) - ((long)x[6] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static int subFrom(int[] x, int xOff, int[] z, int zOff) {
        long l2 = 0L;
        z[zOff + 0] = (int)(l2 += ((long)z[zOff + 0] & 0xFFFFFFFFL) - ((long)x[xOff + 0] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 1] = (int)(l2 += ((long)z[zOff + 1] & 0xFFFFFFFFL) - ((long)x[xOff + 1] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 2] = (int)(l2 += ((long)z[zOff + 2] & 0xFFFFFFFFL) - ((long)x[xOff + 2] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 3] = (int)(l2 += ((long)z[zOff + 3] & 0xFFFFFFFFL) - ((long)x[xOff + 3] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 4] = (int)(l2 += ((long)z[zOff + 4] & 0xFFFFFFFFL) - ((long)x[xOff + 4] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 5] = (int)(l2 += ((long)z[zOff + 5] & 0xFFFFFFFFL) - ((long)x[xOff + 5] & 0xFFFFFFFFL));
        l2 >>= 32;
        z[zOff + 6] = (int)(l2 += ((long)z[zOff + 6] & 0xFFFFFFFFL) - ((long)x[xOff + 6] & 0xFFFFFFFFL));
        return (int)(l2 >>= 32);
    }

    public static BigInteger toBigInteger(int[] x) {
        byte[] byArray = new byte[28];
        for (int i2 = 0; i2 < 7; ++i2) {
            int n2 = x[i2];
            if (n2 == 0) continue;
            Pack.intToBigEndian(n2, byArray, 6 - i2 << 2);
        }
        return new BigInteger(1, byArray);
    }

    public static void zero(int[] z) {
        z[0] = 0;
        z[1] = 0;
        z[2] = 0;
        z[3] = 0;
        z[4] = 0;
        z[5] = 0;
        z[6] = 0;
    }
}

