/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.math.raw;

import com.enterprisedt.bouncycastle.math.raw.Nat;
import com.enterprisedt.bouncycastle.math.raw.Nat224;
import com.enterprisedt.bouncycastle.util.Pack;
import java.math.BigInteger;

public abstract class Nat448 {
    public static void copy64(long[] x, long[] z) {
        z[0] = x[0];
        z[1] = x[1];
        z[2] = x[2];
        z[3] = x[3];
        z[4] = x[4];
        z[5] = x[5];
        z[6] = x[6];
    }

    public static void copy64(long[] x, int xOff, long[] z, int zOff) {
        z[zOff + 0] = x[xOff + 0];
        z[zOff + 1] = x[xOff + 1];
        z[zOff + 2] = x[xOff + 2];
        z[zOff + 3] = x[xOff + 3];
        z[zOff + 4] = x[xOff + 4];
        z[zOff + 5] = x[xOff + 5];
        z[zOff + 6] = x[xOff + 6];
    }

    public static long[] create64() {
        return new long[7];
    }

    public static long[] createExt64() {
        return new long[14];
    }

    public static boolean eq64(long[] x, long[] y) {
        for (int i2 = 6; i2 >= 0; --i2) {
            if (x[i2] == y[i2]) continue;
            return false;
        }
        return true;
    }

    public static long[] fromBigInteger64(BigInteger x) {
        if (x.signum() < 0 || x.bitLength() > 448) {
            throw new IllegalArgumentException();
        }
        long[] lArray = Nat448.create64();
        for (int i2 = 0; i2 < 7; ++i2) {
            lArray[i2] = x.longValue();
            x = x.shiftRight(64);
        }
        return lArray;
    }

    public static boolean isOne64(long[] x) {
        if (x[0] != 1L) {
            return false;
        }
        for (int i2 = 1; i2 < 7; ++i2) {
            if (x[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] x) {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (x[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public static void mul(int[] x, int[] y, int[] zz) {
        Nat224.mul(x, y, zz);
        Nat224.mul(x, 7, y, 7, zz, 14);
        int n2 = Nat224.addToEachOther(zz, 7, zz, 14);
        int n3 = n2 + Nat224.addTo(zz, 0, zz, 7, 0);
        n2 += Nat224.addTo(zz, 21, zz, 14, n3);
        int[] nArray = Nat224.create();
        int[] nArray2 = Nat224.create();
        boolean bl = Nat224.diff(x, 7, x, 0, nArray, 0) != Nat224.diff(y, 7, y, 0, nArray2, 0);
        int[] nArray3 = Nat224.createExt();
        Nat224.mul(nArray, nArray2, nArray3);
        Nat.addWordAt(28, n2 += bl ? Nat.addTo(14, nArray3, 0, zz, 7) : Nat.subFrom(14, nArray3, 0, zz, 7), zz, 21);
    }

    public static void square(int[] x, int[] zz) {
        Nat224.square(x, zz);
        Nat224.square(x, 7, zz, 14);
        int n2 = Nat224.addToEachOther(zz, 7, zz, 14);
        int n3 = n2 + Nat224.addTo(zz, 0, zz, 7, 0);
        n2 += Nat224.addTo(zz, 21, zz, 14, n3);
        int[] nArray = Nat224.create();
        Nat224.diff(x, 7, x, 0, nArray, 0);
        int[] nArray2 = Nat224.createExt();
        Nat224.square(nArray, nArray2);
        Nat.addWordAt(28, n2 += Nat.subFrom(14, nArray2, 0, zz, 7), zz, 21);
    }

    public static BigInteger toBigInteger64(long[] x) {
        byte[] byArray = new byte[56];
        for (int i2 = 0; i2 < 7; ++i2) {
            long l2 = x[i2];
            if (l2 == 0L) continue;
            Pack.longToBigEndian(l2, byArray, 6 - i2 << 3);
        }
        return new BigInteger(1, byArray);
    }
}

