/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.pqc.asn1.FalconPublicKey;
import com.enterprisedt.bouncycastle.util.Arrays;

public class FalconPrivateKey
extends ASN1Object {
    private int a;
    private byte[] b;
    private byte[] c;
    private byte[] d;
    private FalconPublicKey e;

    public FalconPrivateKey(int version, byte[] f2, byte[] g2, byte[] f1, FalconPublicKey publicKey) {
        this.a = version;
        this.b = f2;
        this.c = g2;
        this.d = f1;
        this.e = publicKey;
    }

    public FalconPrivateKey(int version, byte[] f2, byte[] g2, byte[] f1) {
        this(version, f2, g2, f1, null);
    }

    public int getVersion() {
        return this.a;
    }

    public byte[] getf() {
        return Arrays.clone(this.b);
    }

    public byte[] getF() {
        return Arrays.clone(this.d);
    }

    public FalconPublicKey getPublicKey() {
        return this.e;
    }

    public byte[] getG() {
        return Arrays.clone(this.c);
    }

    private FalconPrivateKey(ASN1Sequence seq) {
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0)).intValueExact();
        if (this.a != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.b = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
        this.c = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets());
        this.d = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(3)).getOctets());
        if (seq.size() == 5) {
            this.e = FalconPublicKey.getInstance(seq.getObjectAt(4));
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new DEROctetString(this.b));
        aSN1EncodableVector.add(new DEROctetString(this.c));
        aSN1EncodableVector.add(new DEROctetString(this.d));
        if (this.e != null) {
            aSN1EncodableVector.add(new FalconPublicKey(this.e.getH()));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public static FalconPrivateKey getInstance(Object o2) {
        if (o2 instanceof FalconPrivateKey) {
            return (FalconPrivateKey)o2;
        }
        if (o2 != null) {
            return new FalconPrivateKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }
}

