/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.pqc.asn1.KyberPublicKey;
import com.enterprisedt.bouncycastle.util.Arrays;

public class KyberPrivateKey
extends ASN1Object {
    private int a;
    private byte[] b;
    private KyberPublicKey c;
    private byte[] d;
    private byte[] e;

    public KyberPrivateKey(int version, byte[] s2, byte[] hpk, byte[] nonce, KyberPublicKey publicKey) {
        this.a = version;
        this.b = s2;
        this.c = publicKey;
        this.d = hpk;
        this.e = nonce;
    }

    public KyberPrivateKey(int version, byte[] s2, byte[] hpk, byte[] nonce) {
        this(version, s2, hpk, nonce, null);
    }

    public int getVersion() {
        return this.a;
    }

    public byte[] getS() {
        return Arrays.clone(this.b);
    }

    public KyberPublicKey getPublicKey() {
        return this.c;
    }

    public byte[] getHpk() {
        return Arrays.clone(this.d);
    }

    public byte[] getNonce() {
        return Arrays.clone(this.e);
    }

    private KyberPrivateKey(ASN1Sequence seq) {
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0)).intValueExact();
        if (this.a != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.b = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
        int n2 = 1;
        if (seq.size() == 5) {
            n2 = 0;
            this.c = KyberPublicKey.getInstance(seq.getObjectAt(2));
        }
        this.d = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(3 - n2)).getOctets());
        this.e = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(4 - n2)).getOctets());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new DEROctetString(this.b));
        if (this.c != null) {
            aSN1EncodableVector.add(new KyberPublicKey(this.c.getT(), this.c.getRho()));
        }
        aSN1EncodableVector.add(new DEROctetString(this.d));
        aSN1EncodableVector.add(new DEROctetString(this.e));
        return new DERSequence(aSN1EncodableVector);
    }

    public static KyberPrivateKey getInstance(Object o2) {
        if (o2 instanceof KyberPrivateKey) {
            return (KyberPrivateKey)o2;
        }
        if (o2 != null) {
            return new KyberPrivateKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }
}

