/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.cmce;

import com.enterprisedt.bouncycastle.pqc.crypto.cmce.CMCEKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.cmce.CMCEParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.cmce.d;
import com.enterprisedt.bouncycastle.util.Arrays;

public class CMCEPrivateKeyParameters
extends CMCEKeyParameters {
    private final byte[] b;

    public byte[] getPrivateKey() {
        return Arrays.clone(this.b);
    }

    public CMCEPrivateKeyParameters(CMCEParameters params, byte[] privateKey) {
        super(true, params);
        this.b = Arrays.clone(privateKey);
    }

    public CMCEPrivateKeyParameters(CMCEParameters params, byte[] delta, byte[] C, byte[] g2, byte[] alpha, byte[] s2) {
        super(true, params);
        int n2 = delta.length + C.length + g2.length + alpha.length + s2.length;
        this.b = new byte[n2];
        int n3 = 0;
        System.arraycopy(delta, 0, this.b, n3, delta.length);
        System.arraycopy(C, 0, this.b, n3 += delta.length, C.length);
        System.arraycopy(g2, 0, this.b, n3 += C.length, g2.length);
        System.arraycopy(alpha, 0, this.b, n3 += g2.length, alpha.length);
        System.arraycopy(s2, 0, this.b, n3 += alpha.length, s2.length);
    }

    public byte[] reconstructPublicKey() {
        d d2 = this.getParameters().a();
        byte[] byArray = new byte[d2.b()];
        d2.a(this.b);
        return byArray;
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.b);
    }

    public byte[] getDelta() {
        return Arrays.copyOfRange(this.b, 0, 32);
    }

    public byte[] getC() {
        return Arrays.copyOfRange(this.b, 32, 40);
    }

    public byte[] getG() {
        return Arrays.copyOfRange(this.b, 40, 40 + this.getParameters().getT() * 2);
    }

    public byte[] getAlpha() {
        return Arrays.copyOfRange(this.b, 40 + this.getParameters().getT() * 2, this.b.length - 32);
    }

    public byte[] getS() {
        return Arrays.copyOfRange(this.b, this.b.length - 32, this.b.length);
    }
}

