/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium;

import com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium.a;
import com.enterprisedt.bouncycastle.util.Arrays;

public class DilithiumPrivateKeyParameters
extends DilithiumKeyParameters {
    final byte[] b;
    final byte[] c;
    final byte[] d;
    final byte[] e;
    final byte[] f;
    final byte[] g;
    private final byte[] h;

    public DilithiumPrivateKeyParameters(DilithiumParameters params, byte[] rho, byte[] K, byte[] tr, byte[] s1, byte[] s2, byte[] t0, byte[] t1) {
        super(true, params);
        this.b = Arrays.clone(rho);
        this.c = Arrays.clone(K);
        this.d = Arrays.clone(tr);
        this.e = Arrays.clone(s1);
        this.f = Arrays.clone(s2);
        this.g = Arrays.clone(t0);
        this.h = Arrays.clone(t1);
    }

    public DilithiumPrivateKeyParameters(DilithiumParameters params, byte[] encoding, DilithiumPublicKeyParameters pubKey) {
        super(true, params);
        a a2 = params.a(null);
        int n2 = 0;
        this.b = Arrays.copyOfRange(encoding, 0, 32);
        this.c = Arrays.copyOfRange(encoding, n2 += 32, n2 + 32);
        this.d = Arrays.copyOfRange(encoding, n2 += 32, n2 + 64);
        int n3 = a2.g() * a2.d();
        this.e = Arrays.copyOfRange(encoding, n2 += 64, n2 + n3);
        n2 += n3;
        n3 = a2.f() * a2.d();
        this.f = Arrays.copyOfRange(encoding, n2, n2 + n3);
        n2 += n3;
        n3 = a2.f() * 416;
        this.g = Arrays.copyOfRange(encoding, n2, n2 + n3);
        n2 += n3;
        this.h = (byte[])(pubKey != null ? pubKey.getT1() : null);
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(new byte[][]{this.b, this.c, this.d, this.e, this.f, this.g});
    }

    public byte[] getK() {
        return Arrays.clone(this.c);
    }

    public byte[] getPrivateKey() {
        return this.getEncoded();
    }

    public byte[] getPublicKey() {
        return DilithiumPublicKeyParameters.a(this.b, this.h);
    }

    public DilithiumPublicKeyParameters getPublicKeyParameters() {
        return new DilithiumPublicKeyParameters(this.getParameters(), this.b, this.h);
    }

    public byte[] getRho() {
        return Arrays.clone(this.b);
    }

    public byte[] getS1() {
        return Arrays.clone(this.e);
    }

    public byte[] getS2() {
        return Arrays.clone(this.f);
    }

    public byte[] getT0() {
        return Arrays.clone(this.g);
    }

    public byte[] getT1() {
        return Arrays.clone(this.h);
    }

    public byte[] getTr() {
        return Arrays.clone(this.d);
    }
}

