/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.lms;

import com.enterprisedt.bouncycastle.util.Encodable;
import java.io.ByteArrayOutputStream;

public class Composer {
    private final ByteArrayOutputStream a = new ByteArrayOutputStream();

    private Composer() {
    }

    public static Composer compose() {
        return new Composer();
    }

    public Composer u64str(long n2) {
        this.u32str((int)(n2 >>> 32));
        this.u32str((int)n2);
        return this;
    }

    public Composer u32str(int n2) {
        this.a.write((byte)(n2 >>> 24));
        this.a.write((byte)(n2 >>> 16));
        this.a.write((byte)(n2 >>> 8));
        this.a.write((byte)n2);
        return this;
    }

    public Composer u16str(int n2) {
        this.a.write((byte)((n2 &= 0xFFFF) >>> 8));
        this.a.write((byte)n2);
        return this;
    }

    public Composer bytes(Encodable[] encodable) {
        try {
            for (Encodable encodable2 : encodable) {
                this.a.write(encodable2.getEncoded());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        return this;
    }

    public Composer bytes(Encodable encodable) {
        try {
            this.a.write(encodable.getEncoded());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        return this;
    }

    public Composer pad(int v2, int len) {
        while (len >= 0) {
            try {
                this.a.write(v2);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
            --len;
        }
        return this;
    }

    public Composer bytes(byte[][] arrays) {
        try {
            for (byte[] byArray : arrays) {
                this.a.write(byArray);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        return this;
    }

    public Composer bytes(byte[][] arrays, int start, int end) {
        try {
            for (int i2 = start; i2 != end; ++i2) {
                this.a.write(arrays[i2]);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        return this;
    }

    public Composer bytes(byte[] array) {
        try {
            this.a.write(array);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        return this;
    }

    public Composer bytes(byte[] array, int start, int len) {
        try {
            this.a.write(array, start, len);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        return this;
    }

    public byte[] build() {
        return this.a.toByteArray();
    }

    public Composer padUntil(int v2, int requiredLen) {
        while (this.a.size() < requiredLen) {
            this.a.write(v2);
        }
        return this;
    }

    public Composer bool(boolean v2) {
        this.a.write(v2 ? 1 : 0);
        return this;
    }
}

