/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.lms;

import com.enterprisedt.bouncycastle.pqc.crypto.lms.Composer;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSContext;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSContextBasedSigner;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.a;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.b;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.d;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.g;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.h;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.i;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.l;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HSSPrivateKeyParameters
extends LMSKeyParameters
implements LMSContextBasedSigner {
    private final int b;
    private final boolean c;
    private List<LMSPrivateKeyParameters> d;
    private List<h> e;
    private final long f;
    private long g = 0L;
    private HSSPublicKeyParameters h;

    public HSSPrivateKeyParameters(int l2, List<LMSPrivateKeyParameters> keys, List<h> sig, long index, long indexLimit) {
        super(true);
        this.b = l2;
        this.d = Collections.unmodifiableList(keys);
        this.e = Collections.unmodifiableList(sig);
        this.g = index;
        this.f = indexLimit;
        this.c = false;
        this.g();
    }

    private HSSPrivateKeyParameters(int l2, List<LMSPrivateKeyParameters> keys, List<h> sig, long index, long indexLimit, boolean isShard) {
        super(true);
        this.b = l2;
        this.d = Collections.unmodifiableList(keys);
        this.e = Collections.unmodifiableList(sig);
        this.g = index;
        this.f = indexLimit;
        this.c = isShard;
    }

    public static HSSPrivateKeyParameters getInstance(byte[] privEnc, byte[] pubEnc) throws IOException {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = HSSPrivateKeyParameters.getInstance(privEnc);
        hSSPrivateKeyParameters.h = HSSPublicKeyParameters.getInstance(pubEnc);
        return hSSPrivateKeyParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HSSPrivateKeyParameters getInstance(Object src) throws IOException {
        if (src instanceof HSSPrivateKeyParameters) {
            return (HSSPrivateKeyParameters)src;
        }
        if (src instanceof DataInputStream) {
            int n2;
            if (((DataInputStream)src).readInt() != 0) {
                throw new IllegalStateException("unknown version for hss private key");
            }
            int n3 = ((DataInputStream)src).readInt();
            long l2 = ((DataInputStream)src).readLong();
            long l3 = ((DataInputStream)src).readLong();
            boolean bl = ((DataInputStream)src).readBoolean();
            ArrayList<LMSPrivateKeyParameters> arrayList = new ArrayList<LMSPrivateKeyParameters>();
            ArrayList<h> arrayList2 = new ArrayList<h>();
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList.add(LMSPrivateKeyParameters.getInstance(src));
            }
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                arrayList2.add(com.enterprisedt.bouncycastle.pqc.crypto.lms.h.a(src));
            }
            return new HSSPrivateKeyParameters(n3, arrayList, arrayList2, l2, l3, bl);
        }
        if (src instanceof byte[]) {
            try (InputStream inputStream = null;){
                inputStream = new DataInputStream(new ByteArrayInputStream((byte[])src));
                HSSPrivateKeyParameters hSSPrivateKeyParameters = HSSPrivateKeyParameters.getInstance(inputStream);
                return hSSPrivateKeyParameters;
            }
        }
        if (src instanceof InputStream) {
            return HSSPrivateKeyParameters.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    public int getL() {
        return this.b;
    }

    public synchronized long getIndex() {
        return this.g;
    }

    public synchronized LMSParameters[] getLMSParameters() {
        int n2 = this.d.size();
        LMSParameters[] lMSParametersArray = new LMSParameters[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            LMSPrivateKeyParameters lMSPrivateKeyParameters = this.d.get(i2);
            lMSParametersArray[i2] = new LMSParameters(lMSPrivateKeyParameters.getSigParameters(), lMSPrivateKeyParameters.getOtsParameters());
        }
        return lMSParametersArray;
    }

    synchronized void a() {
        ++this.g;
    }

    private static HSSPrivateKeyParameters a(HSSPrivateKeyParameters hSSPrivateKeyParameters) {
        try {
            return HSSPrivateKeyParameters.getInstance(hSSPrivateKeyParameters.getEncoded());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHierarchy(LMSPrivateKeyParameters[] newKeys, h[] newSig) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = this;
        synchronized (hSSPrivateKeyParameters) {
            this.d = Collections.unmodifiableList(java.util.Arrays.asList(newKeys));
            this.e = Collections.unmodifiableList(java.util.Arrays.asList(newSig));
        }
    }

    boolean b() {
        return this.c;
    }

    long c() {
        return this.f;
    }

    @Override
    public long getUsagesRemaining() {
        return this.f - this.g;
    }

    LMSPrivateKeyParameters d() {
        return this.d.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HSSPrivateKeyParameters extractKeyShard(int usageCount) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = this;
        synchronized (hSSPrivateKeyParameters) {
            if (this.getUsagesRemaining() < (long)usageCount) {
                throw new IllegalArgumentException("usageCount exceeds usages remaining in current leaf");
            }
            long l2 = this.g + (long)usageCount;
            long l3 = this.g;
            this.g += (long)usageCount;
            ArrayList<LMSPrivateKeyParameters> arrayList = new ArrayList<LMSPrivateKeyParameters>(this.e());
            ArrayList<h> arrayList2 = new ArrayList<h>(this.f());
            HSSPrivateKeyParameters hSSPrivateKeyParameters2 = HSSPrivateKeyParameters.a(new HSSPrivateKeyParameters(this.b, arrayList, arrayList2, l3, l2, true));
            this.g();
            return hSSPrivateKeyParameters2;
        }
    }

    synchronized List<LMSPrivateKeyParameters> e() {
        return this.d;
    }

    synchronized List<h> f() {
        return this.e;
    }

    void g() {
        LMSPrivateKeyParameters[] lMSPrivateKeyParametersArray;
        int n2;
        List<LMSPrivateKeyParameters> list = this.e();
        long[] lArray = new long[list.size()];
        long l2 = this.getIndex();
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            lMSPrivateKeyParametersArray = list.get(n2).getSigParameters();
            int n3 = (1 << lMSPrivateKeyParametersArray.getH()) - 1;
            lArray[n2] = l2 & (long)n3;
            l2 >>>= lMSPrivateKeyParametersArray.getH();
        }
        n2 = 0;
        lMSPrivateKeyParametersArray = list.toArray(new LMSPrivateKeyParameters[list.size()]);
        h[] hArray = this.e.toArray(new h[this.e.size()]);
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this.d();
        if ((long)(lMSPrivateKeyParametersArray[0].getIndex() - 1) != lArray[0]) {
            lMSPrivateKeyParametersArray[0] = com.enterprisedt.bouncycastle.pqc.crypto.lms.g.a(lMSPrivateKeyParameters.getSigParameters(), lMSPrivateKeyParameters.getOtsParameters(), (int)lArray[0], lMSPrivateKeyParameters.getI(), lMSPrivateKeyParameters.getMasterSecret());
            n2 = 1;
        }
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            boolean bl;
            LMSPrivateKeyParameters lMSPrivateKeyParameters2 = lMSPrivateKeyParametersArray[i2 - 1];
            int n4 = lMSPrivateKeyParameters2.getOtsParameters().getN();
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[n4];
            l l3 = new l(lMSPrivateKeyParameters2.getI(), lMSPrivateKeyParameters2.getMasterSecret(), a.a(lMSPrivateKeyParameters2.getOtsParameters()));
            l3.a((int)lArray[i2 - 1]);
            l3.b(-2);
            l3.a(byArray2, true);
            byte[] byArray3 = new byte[n4];
            l3.a(byArray3, false);
            System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
            boolean bl2 = i2 < lArray.length - 1 ? lArray[i2] == (long)(lMSPrivateKeyParametersArray[i2].getIndex() - 1) : lArray[i2] == (long)lMSPrivateKeyParametersArray[i2].getIndex();
            boolean bl3 = bl = Arrays.areEqual(byArray, lMSPrivateKeyParametersArray[i2].getI()) && Arrays.areEqual(byArray2, lMSPrivateKeyParametersArray[i2].getMasterSecret());
            if (!bl) {
                lMSPrivateKeyParametersArray[i2] = com.enterprisedt.bouncycastle.pqc.crypto.lms.g.a(list.get(i2).getSigParameters(), list.get(i2).getOtsParameters(), (int)lArray[i2], byArray, byArray2);
                hArray[i2 - 1] = com.enterprisedt.bouncycastle.pqc.crypto.lms.g.a(lMSPrivateKeyParametersArray[i2 - 1], lMSPrivateKeyParametersArray[i2].getPublicKey().a());
                n2 = 1;
                continue;
            }
            if (bl2) continue;
            lMSPrivateKeyParametersArray[i2] = com.enterprisedt.bouncycastle.pqc.crypto.lms.g.a(list.get(i2).getSigParameters(), list.get(i2).getOtsParameters(), (int)lArray[i2], byArray, byArray2);
            n2 = 1;
        }
        if (n2 != 0) {
            this.updateHierarchy(lMSPrivateKeyParametersArray, hArray);
        }
    }

    public synchronized HSSPublicKeyParameters getPublicKey() {
        return new HSSPublicKeyParameters(this.b, this.d().getPublicKey());
    }

    void a(int n2) {
        d d2 = this.d.get(n2 - 1).b();
        int n3 = d2.b().getN();
        l l2 = d2.a();
        l2.b(-2);
        byte[] byArray = new byte[n3];
        l2.a(byArray, true);
        byte[] byArray2 = new byte[n3];
        l2.a(byArray2, false);
        byte[] byArray3 = new byte[16];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        ArrayList<LMSPrivateKeyParameters> arrayList = new ArrayList<LMSPrivateKeyParameters>(this.d);
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this.d.get(n2);
        arrayList.set(n2, com.enterprisedt.bouncycastle.pqc.crypto.lms.g.a(lMSPrivateKeyParameters.getSigParameters(), lMSPrivateKeyParameters.getOtsParameters(), 0, byArray3, byArray));
        ArrayList<h> arrayList2 = new ArrayList<h>(this.e);
        arrayList2.set(n2 - 1, com.enterprisedt.bouncycastle.pqc.crypto.lms.g.a((LMSPrivateKeyParameters)arrayList.get(n2 - 1), ((LMSPrivateKeyParameters)arrayList.get(n2)).getPublicKey().a()));
        this.d = Collections.unmodifiableList(arrayList);
        this.e = Collections.unmodifiableList(arrayList2);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        HSSPrivateKeyParameters hSSPrivateKeyParameters = (HSSPrivateKeyParameters)o2;
        if (this.b != hSSPrivateKeyParameters.b) {
            return false;
        }
        if (this.c != hSSPrivateKeyParameters.c) {
            return false;
        }
        if (this.f != hSSPrivateKeyParameters.f) {
            return false;
        }
        if (this.g != hSSPrivateKeyParameters.g) {
            return false;
        }
        if (!this.d.equals(hSSPrivateKeyParameters.d)) {
            return false;
        }
        return this.e.equals(hSSPrivateKeyParameters.e);
    }

    @Override
    public synchronized byte[] getEncoded() throws IOException {
        Composer composer = Composer.compose().u32str(0).u32str(this.b).u64str(this.g).u64str(this.f).bool(this.c);
        for (LMSPrivateKeyParameters encodable : this.d) {
            composer.bytes(encodable);
        }
        for (h h2 : this.e) {
            composer.bytes(h2);
        }
        return composer.build();
    }

    public int hashCode() {
        int n2 = this.b;
        n2 = 31 * n2 + (this.c ? 1 : 0);
        n2 = 31 * n2 + this.d.hashCode();
        n2 = 31 * n2 + this.e.hashCode();
        n2 = 31 * n2 + (int)(this.f ^ this.f >>> 32);
        n2 = 31 * n2 + (int)(this.g ^ this.g >>> 32);
        return n2;
    }

    protected Object clone() throws CloneNotSupportedException {
        return HSSPrivateKeyParameters.a(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LMSContext generateLMSContext() {
        i[] iArray;
        LMSPrivateKeyParameters lMSPrivateKeyParameters;
        int n2 = this.getL();
        HSSPrivateKeyParameters hSSPrivateKeyParameters = this;
        synchronized (hSSPrivateKeyParameters) {
            com.enterprisedt.bouncycastle.pqc.crypto.lms.b.a(this);
            List<LMSPrivateKeyParameters> list = this.e();
            List<h> list2 = this.f();
            lMSPrivateKeyParameters = this.e().get(n2 - 1);
            iArray = new i[n2 - 1];
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                iArray[i2] = new i(list2.get(i2), list.get(i2 + 1).getPublicKey());
            }
            this.a();
        }
        return lMSPrivateKeyParameters.generateLMSContext().a(iArray);
    }

    @Override
    public byte[] generateSignature(LMSContext context) {
        try {
            return com.enterprisedt.bouncycastle.pqc.crypto.lms.b.a(this.getL(), context).getEncoded();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode signature: " + iOException.getMessage(), iOException);
        }
    }
}

