/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.lms;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.pqc.crypto.ExhaustedPrivateKeyException;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.Composer;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSContext;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSContextBasedSigner;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSigParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.d;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.g;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.j;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.k;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;

public class LMSPrivateKeyParameters
extends LMSKeyParameters
implements LMSContextBasedSigner {
    private static a b = new a(1);
    private static a[] c = new a[129];
    private final byte[] d;
    private final LMSigParameters e;
    private final LMOtsParameters f;
    private final int g;
    private final byte[] h;
    private final Map<a, byte[]> i;
    private final int j;
    private final Digest k;
    private int l;
    private LMSPublicKeyParameters m;

    public LMSPrivateKeyParameters(LMSigParameters lmsParameter, LMOtsParameters otsParameters, int q2, byte[] I, int maxQ, byte[] masterSecret) {
        super(true);
        this.e = lmsParameter;
        this.f = otsParameters;
        this.l = q2;
        this.d = Arrays.clone(I);
        this.g = maxQ;
        this.h = Arrays.clone(masterSecret);
        this.j = 1 << this.e.getH() + 1;
        this.i = new WeakHashMap<a, byte[]>();
        this.k = com.enterprisedt.bouncycastle.pqc.crypto.lms.a.a(lmsParameter);
    }

    private LMSPrivateKeyParameters(LMSPrivateKeyParameters parent, int q2, int maxQ) {
        super(true);
        this.e = parent.e;
        this.f = parent.f;
        this.l = q2;
        this.d = parent.d;
        this.g = maxQ;
        this.h = parent.h;
        this.j = 1 << this.e.getH();
        this.i = parent.i;
        this.k = com.enterprisedt.bouncycastle.pqc.crypto.lms.a.a(this.e);
        this.m = parent.m;
    }

    public static LMSPrivateKeyParameters getInstance(byte[] privEnc, byte[] pubEnc) throws IOException {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = LMSPrivateKeyParameters.getInstance(privEnc);
        lMSPrivateKeyParameters.m = LMSPublicKeyParameters.getInstance(pubEnc);
        return lMSPrivateKeyParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LMSPrivateKeyParameters getInstance(Object src) throws IOException {
        if (src instanceof LMSPrivateKeyParameters) {
            return (LMSPrivateKeyParameters)src;
        }
        if (src instanceof DataInputStream) {
            DataInputStream dataInputStream = (DataInputStream)src;
            if (dataInputStream.readInt() != 0) {
                throw new IllegalStateException("expected version 0 lms private key");
            }
            LMSigParameters lMSigParameters = LMSigParameters.a(dataInputStream.readInt());
            LMOtsParameters lMOtsParameters = LMOtsParameters.getParametersForType(dataInputStream.readInt());
            byte[] byArray = new byte[16];
            dataInputStream.readFully(byArray);
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            if (n4 < 0) {
                throw new IllegalStateException("secret length less than zero");
            }
            if (n4 > dataInputStream.available()) {
                throw new IOException("secret length exceeded " + dataInputStream.available());
            }
            byte[] byArray2 = new byte[n4];
            dataInputStream.readFully(byArray2);
            return new LMSPrivateKeyParameters(lMSigParameters, lMOtsParameters, n2, byArray, n3, byArray2);
        }
        if (src instanceof byte[]) {
            try (InputStream inputStream = null;){
                inputStream = new DataInputStream(new ByteArrayInputStream((byte[])src));
                LMSPrivateKeyParameters lMSPrivateKeyParameters = LMSPrivateKeyParameters.getInstance(inputStream);
                return lMSPrivateKeyParameters;
            }
        }
        if (src instanceof InputStream) {
            return LMSPrivateKeyParameters.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    d b() {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        synchronized (lMSPrivateKeyParameters) {
            if (this.l >= this.g) {
                throw new ExhaustedPrivateKeyException("ots private keys expired");
            }
            return new d(this.f, this.d, this.l, this.h);
        }
    }

    public synchronized int getIndex() {
        return this.l;
    }

    synchronized void c() {
        ++this.l;
    }

    @Override
    public LMSContext generateLMSContext() {
        LMSigParameters lMSigParameters = this.getSigParameters();
        int n2 = lMSigParameters.getH();
        int n3 = this.getIndex();
        d d2 = this.a();
        int n4 = (1 << n2) + n3;
        byte[][] byArrayArray = new byte[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = n4 / (1 << i2) ^ 1;
            byArrayArray[i2] = this.a(n5);
        }
        return d2.a(this.getSigParameters(), byArrayArray);
    }

    @Override
    public byte[] generateSignature(LMSContext context) {
        try {
            return com.enterprisedt.bouncycastle.pqc.crypto.lms.g.a(context).getEncoded();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode signature: " + iOException.getMessage(), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    d a() {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        synchronized (lMSPrivateKeyParameters) {
            if (this.l >= this.g) {
                throw new ExhaustedPrivateKeyException("ots private key exhausted");
            }
            d d2 = new d(this.f, this.d, this.l, this.h);
            this.c();
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LMSPrivateKeyParameters extractKeyShard(int usageCount) {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        synchronized (lMSPrivateKeyParameters) {
            if (this.l + usageCount >= this.g) {
                throw new IllegalArgumentException("usageCount exceeds usages remaining");
            }
            LMSPrivateKeyParameters lMSPrivateKeyParameters2 = new LMSPrivateKeyParameters(this, this.l, this.l + usageCount);
            this.l += usageCount;
            return lMSPrivateKeyParameters2;
        }
    }

    public LMSigParameters getSigParameters() {
        return this.e;
    }

    public LMOtsParameters getOtsParameters() {
        return this.f;
    }

    public byte[] getI() {
        return Arrays.clone(this.d);
    }

    public byte[] getMasterSecret() {
        return Arrays.clone(this.h);
    }

    @Override
    public long getUsagesRemaining() {
        return this.g - this.l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LMSPublicKeyParameters getPublicKey() {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        synchronized (lMSPrivateKeyParameters) {
            if (this.m == null) {
                this.m = new LMSPublicKeyParameters(this.e, this.f, this.a(b), this.d);
            }
            return this.m;
        }
    }

    byte[] a(int n2) {
        if (n2 < this.j) {
            return this.a(n2 < c.length ? c[n2] : new a(n2));
        }
        return this.b(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] a(a a2) {
        Map<a, byte[]> map = this.i;
        synchronized (map) {
            byte[] byArray = this.i.get(a2);
            if (byArray != null) {
                return byArray;
            }
            byArray = this.b(a2.a);
            this.i.put(a2, byArray);
            return byArray;
        }
    }

    private byte[] b(int n2) {
        int n3 = this.getSigParameters().getH();
        int n4 = 1 << n3;
        if (n2 >= n4) {
            com.enterprisedt.bouncycastle.pqc.crypto.lms.k.a(this.getI(), this.k);
            com.enterprisedt.bouncycastle.pqc.crypto.lms.k.a(n2, this.k);
            com.enterprisedt.bouncycastle.pqc.crypto.lms.k.a((short)-32126, this.k);
            byte[] byArray = com.enterprisedt.bouncycastle.pqc.crypto.lms.j.a(this.getOtsParameters(), this.getI(), n2 - n4, this.getMasterSecret());
            com.enterprisedt.bouncycastle.pqc.crypto.lms.k.a(byArray, this.k);
            byte[] byArray2 = new byte[this.k.getDigestSize()];
            this.k.doFinal(byArray2, 0);
            return byArray2;
        }
        byte[] byArray = this.a(2 * n2);
        byte[] byArray3 = this.a(2 * n2 + 1);
        com.enterprisedt.bouncycastle.pqc.crypto.lms.k.a(this.getI(), this.k);
        com.enterprisedt.bouncycastle.pqc.crypto.lms.k.a(n2, this.k);
        com.enterprisedt.bouncycastle.pqc.crypto.lms.k.a((short)-31869, this.k);
        com.enterprisedt.bouncycastle.pqc.crypto.lms.k.a(byArray, this.k);
        com.enterprisedt.bouncycastle.pqc.crypto.lms.k.a(byArray3, this.k);
        byte[] byArray4 = new byte[this.k.getDigestSize()];
        this.k.doFinal(byArray4, 0);
        return byArray4;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        LMSPrivateKeyParameters lMSPrivateKeyParameters = (LMSPrivateKeyParameters)o2;
        if (this.l != lMSPrivateKeyParameters.l) {
            return false;
        }
        if (this.g != lMSPrivateKeyParameters.g) {
            return false;
        }
        if (!Arrays.areEqual(this.d, lMSPrivateKeyParameters.d)) {
            return false;
        }
        if (this.e != null ? !this.e.equals(lMSPrivateKeyParameters.e) : lMSPrivateKeyParameters.e != null) {
            return false;
        }
        if (this.f != null ? !this.f.equals(lMSPrivateKeyParameters.f) : lMSPrivateKeyParameters.f != null) {
            return false;
        }
        if (!Arrays.areEqual(this.h, lMSPrivateKeyParameters.h)) {
            return false;
        }
        if (this.m != null && lMSPrivateKeyParameters.m != null) {
            return this.m.equals(lMSPrivateKeyParameters.m);
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.l;
        n2 = 31 * n2 + Arrays.hashCode(this.d);
        n2 = 31 * n2 + (this.e != null ? this.e.hashCode() : 0);
        n2 = 31 * n2 + (this.f != null ? this.f.hashCode() : 0);
        n2 = 31 * n2 + this.g;
        n2 = 31 * n2 + Arrays.hashCode(this.h);
        n2 = 31 * n2 + (this.m != null ? this.m.hashCode() : 0);
        return n2;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(0).u32str(this.e.getType()).u32str(this.f.getType()).bytes(this.d).u32str(this.l).u32str(this.g).u32str(this.h.length).bytes(this.h).build();
    }

    static {
        LMSPrivateKeyParameters.c[1] = b;
        for (int i2 = 2; i2 < c.length; ++i2) {
            LMSPrivateKeyParameters.c[i2] = new a(i2);
        }
    }

    private static class a {
        private final int a;

        a(int n2) {
            this.a = n2;
        }

        public int hashCode() {
            return this.a;
        }

        public boolean equals(Object o2) {
            if (o2 instanceof a) {
                return ((a)o2).a == this.a;
            }
            return false;
        }
    }
}

