/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.lms;

import com.enterprisedt.bouncycastle.pqc.crypto.lms.Composer;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSContext;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSContextBasedVerifier;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSigParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.e;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.g;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.h;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LMSPublicKeyParameters
extends LMSKeyParameters
implements LMSContextBasedVerifier {
    private final LMSigParameters b;
    private final LMOtsParameters c;
    private final byte[] d;
    private final byte[] e;

    public LMSPublicKeyParameters(LMSigParameters parameterSet, LMOtsParameters lmOtsType, byte[] T1, byte[] I) {
        super(false);
        this.b = parameterSet;
        this.c = lmOtsType;
        this.d = Arrays.clone(I);
        this.e = Arrays.clone(T1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LMSPublicKeyParameters getInstance(Object src) throws IOException {
        if (src instanceof LMSPublicKeyParameters) {
            return (LMSPublicKeyParameters)src;
        }
        if (src instanceof DataInputStream) {
            int n2 = ((DataInputStream)src).readInt();
            LMSigParameters lMSigParameters = LMSigParameters.a(n2);
            LMOtsParameters lMOtsParameters = LMOtsParameters.getParametersForType(((DataInputStream)src).readInt());
            byte[] byArray = new byte[16];
            ((DataInputStream)src).readFully(byArray);
            byte[] byArray2 = new byte[lMSigParameters.getM()];
            ((DataInputStream)src).readFully(byArray2);
            return new LMSPublicKeyParameters(lMSigParameters, lMOtsParameters, byArray2, byArray);
        }
        if (src instanceof byte[]) {
            try (InputStream inputStream = null;){
                inputStream = new DataInputStream(new ByteArrayInputStream((byte[])src));
                LMSPublicKeyParameters lMSPublicKeyParameters = LMSPublicKeyParameters.getInstance(inputStream);
                return lMSPublicKeyParameters;
            }
        }
        if (src instanceof InputStream) {
            return LMSPublicKeyParameters.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.a();
    }

    public LMSigParameters getSigParameters() {
        return this.b;
    }

    public LMOtsParameters getOtsParameters() {
        return this.c;
    }

    public LMSParameters getLMSParameters() {
        return new LMSParameters(this.getSigParameters(), this.getOtsParameters());
    }

    public byte[] getT1() {
        return Arrays.clone(this.e);
    }

    boolean a(byte[] byArray) {
        return Arrays.constantTimeAreEqual(this.e, byArray);
    }

    public byte[] getI() {
        return Arrays.clone(this.d);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        LMSPublicKeyParameters lMSPublicKeyParameters = (LMSPublicKeyParameters)o2;
        if (!this.b.equals(lMSPublicKeyParameters.b)) {
            return false;
        }
        if (!this.c.equals(lMSPublicKeyParameters.c)) {
            return false;
        }
        if (!Arrays.areEqual(this.d, lMSPublicKeyParameters.d)) {
            return false;
        }
        return Arrays.areEqual(this.e, lMSPublicKeyParameters.e);
    }

    public int hashCode() {
        int n2 = this.b.hashCode();
        n2 = 31 * n2 + this.c.hashCode();
        n2 = 31 * n2 + Arrays.hashCode(this.d);
        n2 = 31 * n2 + Arrays.hashCode(this.e);
        return n2;
    }

    byte[] a() {
        return Composer.compose().u32str(this.b.getType()).u32str(this.c.getType()).bytes(this.d).bytes(this.e).build();
    }

    @Override
    public LMSContext generateLMSContext(byte[] signature) {
        try {
            return this.a(h.a(signature));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot parse signature: " + iOException.getMessage());
        }
    }

    LMSContext a(h h2) {
        int n2 = this.getOtsParameters().getType();
        if (h2.b().a().getType() != n2) {
            throw new IllegalArgumentException("ots type from lsm signature does not match ots signature type from embedded ots signature");
        }
        return new e(LMOtsParameters.getParametersForType(n2), this.d, h2.a(), null).a(h2);
    }

    @Override
    public boolean verify(LMSContext context) {
        return g.a(this, context);
    }
}

