/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.ntru;

import com.enterprisedt.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.enterprisedt.bouncycastle.crypto.SecretWithEncapsulation;
import com.enterprisedt.bouncycastle.crypto.digests.SHA3Digest;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.a;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.b;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.e;
import com.enterprisedt.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import com.enterprisedt.bouncycastle.pqc.math.ntru.Polynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class NTRUKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom a;

    public NTRUKEMGenerator(SecureRandom random) {
        this.a = random;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        NTRUParameterSet nTRUParameterSet = ((NTRUPublicKeyParameters)recipientKey).getParameters().a;
        b b2 = new b(nTRUParameterSet);
        a a2 = new a(nTRUParameterSet);
        byte[] byArray = new byte[nTRUParameterSet.owcpaMsgBytes()];
        byte[] byArray2 = new byte[nTRUParameterSet.sampleRmBytes()];
        this.a.nextBytes(byArray2);
        e e2 = b2.b(byArray2);
        Polynomial polynomial = e2.c();
        Polynomial polynomial2 = e2.d();
        byte[] byArray3 = polynomial.s3ToBytes(nTRUParameterSet.owcpaMsgBytes());
        System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
        byte[] byArray4 = polynomial2.s3ToBytes(byArray.length - nTRUParameterSet.packTrinaryBytes());
        System.arraycopy(byArray4, 0, byArray, nTRUParameterSet.packTrinaryBytes(), byArray4.length);
        SHA3Digest sHA3Digest = new SHA3Digest(256);
        sHA3Digest.update(byArray, 0, byArray.length);
        byte[] byArray5 = new byte[sHA3Digest.getDigestSize()];
        sHA3Digest.doFinal(byArray5, 0);
        polynomial.z3ToZq();
        byte[] byArray6 = a2.a(polynomial, polynomial2, ((NTRUPublicKeyParameters)recipientKey).b);
        byte[] byArray7 = Arrays.copyOfRange(byArray5, 0, nTRUParameterSet.sharedKeyBytes());
        Arrays.clear(byArray5);
        return new SecretWithEncapsulationImpl(byArray7, byArray6);
    }
}

