/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.ntruprime;

import com.enterprisedt.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.enterprisedt.bouncycastle.crypto.SecretWithEncapsulation;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a;
import com.enterprisedt.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class NTRULPRimeKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom a;

    public NTRULPRimeKEMGenerator(SecureRandom random) {
        this.a = random;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        NTRULPRimePublicKeyParameters nTRULPRimePublicKeyParameters = (NTRULPRimePublicKeyParameters)recipientKey;
        NTRULPRimeParameters nTRULPRimeParameters = nTRULPRimePublicKeyParameters.getParameters();
        int n2 = nTRULPRimeParameters.getP();
        int n3 = nTRULPRimeParameters.getQ();
        int n4 = nTRULPRimeParameters.getW();
        int n5 = nTRULPRimeParameters.getRoundedPolynomialBytes();
        int n6 = nTRULPRimeParameters.getTau0();
        int n7 = nTRULPRimeParameters.getTau1();
        byte[] byArray = new byte[]{4};
        byte[] byArray2 = com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(byArray, nTRULPRimePublicKeyParameters.getEncoded());
        byte[] byArray3 = new byte[256];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.b(this.a, byArray3);
        byte[] byArray4 = new byte[32];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.b(byArray4, byArray3);
        short[] sArray = new short[n2];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.d(sArray, nTRULPRimePublicKeyParameters.b(), n2, n3);
        short[] sArray2 = new short[n2];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.b(sArray2, nTRULPRimePublicKeyParameters.a(), n2, n3);
        byte[] byArray5 = new byte[]{5};
        byte[] byArray6 = com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(byArray5, byArray4);
        byte[] byArray7 = Arrays.copyOfRange(byArray6, 0, byArray6.length / 2);
        int[] nArray = new int[n2];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(nArray, byArray7);
        byte[] byArray8 = new byte[n2];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(byArray8, nArray, n2, n4);
        short[] sArray3 = new short[n2];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(sArray3, sArray2, byArray8, n2, n3);
        short[] sArray4 = new short[n2];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(sArray4, sArray3);
        byte[] byArray9 = new byte[n5];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.b(byArray9, sArray4, n2, n3);
        short[] sArray5 = new short[n2];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(sArray5, sArray, byArray8, n2, n3);
        byte[] byArray10 = new byte[256];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(byArray10, sArray5, byArray3, n3, n6, n7);
        byte[] byArray11 = new byte[128];
        com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.c(byArray11, byArray10);
        byte[] byArray12 = new byte[byArray4.length + byArray2.length / 2];
        System.arraycopy(byArray4, 0, byArray12, 0, byArray4.length);
        System.arraycopy(byArray2, 0, byArray12, byArray4.length, byArray2.length / 2);
        byte[] byArray13 = new byte[]{2};
        byte[] byArray14 = com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(byArray13, byArray12);
        byte[] byArray15 = new byte[byArray9.length + byArray11.length + byArray14.length / 2];
        System.arraycopy(byArray9, 0, byArray15, 0, byArray9.length);
        System.arraycopy(byArray11, 0, byArray15, byArray9.length, byArray11.length);
        System.arraycopy(byArray14, 0, byArray15, byArray9.length + byArray11.length, byArray14.length / 2);
        byte[] byArray16 = new byte[byArray4.length + byArray15.length];
        System.arraycopy(byArray4, 0, byArray16, 0, byArray4.length);
        System.arraycopy(byArray15, 0, byArray16, byArray4.length, byArray15.length);
        byte[] byArray17 = new byte[]{1};
        byte[] byArray18 = com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.a.a(byArray17, byArray16);
        byte[] byArray19 = Arrays.copyOfRange(byArray18, 0, nTRULPRimeParameters.getSessionKeySize() / 8);
        return new SecretWithEncapsulationImpl(byArray19, byArray15);
    }
}

