/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.ntruprime;

import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeParameters;
import com.enterprisedt.bouncycastle.util.Arrays;

public class NTRULPRimePrivateKeyParameters
extends NTRULPRimeKeyParameters {
    private final byte[] b;
    private final byte[] c;
    private final byte[] d;
    private final byte[] e;

    public NTRULPRimePrivateKeyParameters(NTRULPRimeParameters params, byte[] enca, byte[] pk, byte[] rho, byte[] hash) {
        super(true, params);
        this.b = Arrays.clone(enca);
        this.c = Arrays.clone(pk);
        this.d = Arrays.clone(rho);
        this.e = Arrays.clone(hash);
    }

    public byte[] getEnca() {
        return Arrays.clone(this.b);
    }

    public byte[] getPk() {
        return Arrays.clone(this.c);
    }

    public byte[] getRho() {
        return Arrays.clone(this.d);
    }

    public byte[] getHash() {
        return Arrays.clone(this.e);
    }

    public byte[] getEncoded() {
        byte[] byArray = new byte[this.getParameters().getPrivateKeyBytes()];
        System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        System.arraycopy(this.c, 0, byArray, this.b.length, this.c.length);
        System.arraycopy(this.d, 0, byArray, this.b.length + this.c.length, this.d.length);
        System.arraycopy(this.e, 0, byArray, this.b.length + this.c.length + this.d.length, this.e.length);
        return byArray;
    }
}

