/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.sphincsplus;

import com.enterprisedt.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincsplus.j;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincsplus.n;
import com.enterprisedt.bouncycastle.util.Arrays;

public class SPHINCSPlusPrivateKeyParameters
extends SPHINCSPlusKeyParameters {
    final n c;
    final j d;

    public SPHINCSPlusPrivateKeyParameters(SPHINCSPlusParameters parameters, byte[] skpkEncoded) {
        super(true, parameters);
        int n2 = parameters.a();
        if (skpkEncoded.length != 4 * n2) {
            throw new IllegalArgumentException("private key encoding does not match parameters");
        }
        this.c = new n(Arrays.copyOfRange(skpkEncoded, 0, n2), Arrays.copyOfRange(skpkEncoded, n2, 2 * n2));
        this.d = new j(Arrays.copyOfRange(skpkEncoded, 2 * n2, 3 * n2), Arrays.copyOfRange(skpkEncoded, 3 * n2, 4 * n2));
    }

    public SPHINCSPlusPrivateKeyParameters(SPHINCSPlusParameters parameters, byte[] skSeed, byte[] prf, byte[] pkSeed, byte[] pkRoot) {
        super(true, parameters);
        this.c = new n(skSeed, prf);
        this.d = new j(pkSeed, pkRoot);
    }

    SPHINCSPlusPrivateKeyParameters(SPHINCSPlusParameters parameters, n sk, j pk) {
        super(true, parameters);
        this.c = sk;
        this.d = pk;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.c.a);
    }

    public byte[] getPrf() {
        return Arrays.clone(this.c.b);
    }

    public byte[] getPublicSeed() {
        return Arrays.clone(this.d.a);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.d.b);
    }

    public byte[] getPublicKey() {
        return Arrays.concatenate(this.d.a, this.d.b);
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(new byte[][]{this.c.a, this.c.b, this.d.a, this.d.b});
    }

    public byte[] getEncodedPublicKey() {
        return Arrays.concatenate(this.d.a, this.d.b);
    }
}

