/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.util;

import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.EncapsulatedSecretExtractor;
import com.enterprisedt.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.enterprisedt.bouncycastle.crypto.SecretWithEncapsulation;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.util.DEROtherInfo;
import com.enterprisedt.bouncycastle.pqc.crypto.KEMParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMExtractor;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyPairGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUKEMExtractor;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUKEMGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUKeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUKeyPairGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import com.enterprisedt.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import java.io.IOException;
import java.security.SecureRandom;

public class PQCOtherInfoGenerator {
    protected final DEROtherInfo.Builder otherInfoBuilder;
    protected final SecureRandom random;
    protected boolean used = false;

    public PQCOtherInfoGenerator(AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo, SecureRandom random) {
        this.otherInfoBuilder = new DEROtherInfo.Builder(algorithmID, partyUInfo, partyVInfo);
        this.random = random;
    }

    private static byte[] b(AsymmetricKeyParameter asymmetricKeyParameter) {
        try {
            return SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(asymmetricKeyParameter).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static AsymmetricKeyParameter b(byte[] byArray) throws IOException {
        return PublicKeyFactory.createKey(byArray);
    }

    public static class PartyV
    extends PQCOtherInfoGenerator {
        private EncapsulatedSecretGenerator a;

        public PartyV(KEMParameters kemParams, AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo, SecureRandom random) {
            super(algorithmID, partyUInfo, partyVInfo, random);
            if (kemParams instanceof KyberParameters) {
                this.a = new KyberKEMGenerator(random);
            } else if (kemParams instanceof NTRUParameters) {
                this.a = new NTRUKEMGenerator(random);
            } else {
                throw new IllegalArgumentException("unknown KEMParameters");
            }
        }

        public PQCOtherInfoGenerator withSuppPubInfo(byte[] suppPubInfo) {
            this.otherInfoBuilder.withSuppPubInfo(suppPubInfo);
            return this;
        }

        public byte[] getSuppPrivInfoPartB(byte[] suppPrivInfoPartA) {
            this.used = false;
            try {
                SecretWithEncapsulation secretWithEncapsulation = this.a.generateEncapsulated(PQCOtherInfoGenerator.b(suppPrivInfoPartA));
                this.otherInfoBuilder.withSuppPrivInfo(secretWithEncapsulation.getSecret());
                return secretWithEncapsulation.getEncapsulation();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("cannot decode public key");
            }
        }

        public DEROtherInfo generate() {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            return this.otherInfoBuilder.build();
        }
    }

    public static class PartyU
    extends PQCOtherInfoGenerator {
        private AsymmetricCipherKeyPair a;
        private EncapsulatedSecretExtractor b;

        public PartyU(KEMParameters kemParams, AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo, SecureRandom random) {
            super(algorithmID, partyUInfo, partyVInfo, random);
            if (kemParams instanceof KyberParameters) {
                KyberKeyPairGenerator kyberKeyPairGenerator = new KyberKeyPairGenerator();
                kyberKeyPairGenerator.init(new KyberKeyGenerationParameters(random, (KyberParameters)kemParams));
                this.a = kyberKeyPairGenerator.generateKeyPair();
                this.b = new KyberKEMExtractor((KyberPrivateKeyParameters)this.a.getPrivate());
            } else if (kemParams instanceof NTRUParameters) {
                NTRUKeyPairGenerator nTRUKeyPairGenerator = new NTRUKeyPairGenerator();
                nTRUKeyPairGenerator.init(new NTRUKeyGenerationParameters(random, (NTRUParameters)kemParams));
                this.a = nTRUKeyPairGenerator.generateKeyPair();
                this.b = new NTRUKEMExtractor((NTRUPrivateKeyParameters)this.a.getPrivate());
            } else {
                throw new IllegalArgumentException("unknown KEMParameters");
            }
        }

        public PQCOtherInfoGenerator withSuppPubInfo(byte[] suppPubInfo) {
            this.otherInfoBuilder.withSuppPubInfo(suppPubInfo);
            return this;
        }

        public byte[] getSuppPrivInfoPartA() {
            return PQCOtherInfoGenerator.b(this.a.getPublic());
        }

        public DEROtherInfo generate(byte[] suppPrivInfoPartB) {
            this.otherInfoBuilder.withSuppPrivInfo(this.b.extractSecret(suppPrivInfoPartB));
            return this.otherInfoBuilder.build();
        }
    }
}

