/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.util;

import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.asn1.McElieceCCA2PublicKey;
import com.enterprisedt.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.enterprisedt.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSMTPublicKey;
import com.enterprisedt.bouncycastle.pqc.asn1.XMSSPublicKey;
import com.enterprisedt.bouncycastle.pqc.crypto.bike.BIKEPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.cmce.CMCEPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.frodo.FrodoPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.Composer;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.picnic.PicnicPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.util.a;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.qtesla.QTESLAPublicKeyParameters;
import java.io.IOException;

public class SubjectPublicKeyInfoFactory {
    private SubjectPublicKeyInfoFactory() {
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter publicKey) throws IOException {
        if (publicKey instanceof QTESLAPublicKeyParameters) {
            QTESLAPublicKeyParameters qTESLAPublicKeyParameters = (QTESLAPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = a.a(qTESLAPublicKeyParameters.getSecurityCategory());
            return new SubjectPublicKeyInfo(algorithmIdentifier, qTESLAPublicKeyParameters.getPublicData());
        }
        if (publicKey instanceof SPHINCSPublicKeyParameters) {
            SPHINCSPublicKeyParameters sPHINCSPublicKeyParameters = (SPHINCSPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(a.a(sPHINCSPublicKeyParameters.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, sPHINCSPublicKeyParameters.getKeyData());
        }
        if (publicKey instanceof NHPublicKeyParameters) {
            NHPublicKeyParameters nHPublicKeyParameters = (NHPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            return new SubjectPublicKeyInfo(algorithmIdentifier, nHPublicKeyParameters.getPubData());
        }
        if (publicKey instanceof LMSPublicKeyParameters) {
            LMSPublicKeyParameters lMSPublicKeyParameters = (LMSPublicKeyParameters)publicKey;
            byte[] byArray = Composer.compose().u32str(1).bytes(lMSPublicKeyParameters).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        if (publicKey instanceof HSSPublicKeyParameters) {
            HSSPublicKeyParameters hSSPublicKeyParameters = (HSSPublicKeyParameters)publicKey;
            byte[] byArray = Composer.compose().u32str(hSSPublicKeyParameters.getL()).bytes(hSSPublicKeyParameters.getLMSPublicKey()).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        if (publicKey instanceof SPHINCSPlusPublicKeyParameters) {
            SPHINCSPlusPublicKeyParameters sPHINCSPlusPublicKeyParameters = (SPHINCSPlusPublicKeyParameters)publicKey;
            byte[] byArray = sPHINCSPlusPublicKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(sPHINCSPlusPublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, byArray);
        }
        if (publicKey instanceof CMCEPublicKeyParameters) {
            CMCEPublicKeyParameters cMCEPublicKeyParameters = (CMCEPublicKeyParameters)publicKey;
            byte[] byArray = cMCEPublicKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(cMCEPublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, byArray);
        }
        if (publicKey instanceof XMSSPublicKeyParameters) {
            XMSSPublicKeyParameters xMSSPublicKeyParameters = (XMSSPublicKeyParameters)publicKey;
            byte[] byArray = xMSSPublicKeyParameters.getPublicSeed();
            byte[] byArray2 = xMSSPublicKeyParameters.getRoot();
            byte[] byArray3 = xMSSPublicKeyParameters.getEncoded();
            if (byArray3.length > byArray.length + byArray2.length) {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(IsaraObjectIdentifiers.id_alg_xmss);
                return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray3));
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(xMSSPublicKeyParameters.getParameters().getHeight(), a.b(xMSSPublicKeyParameters.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSPublicKey(byArray, byArray2));
        }
        if (publicKey instanceof XMSSMTPublicKeyParameters) {
            XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters = (XMSSMTPublicKeyParameters)publicKey;
            byte[] byArray = xMSSMTPublicKeyParameters.getPublicSeed();
            byte[] byArray4 = xMSSMTPublicKeyParameters.getRoot();
            byte[] byArray5 = xMSSMTPublicKeyParameters.getEncoded();
            if (byArray5.length > byArray.length + byArray4.length) {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(IsaraObjectIdentifiers.id_alg_xmssmt);
                return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray5));
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(xMSSMTPublicKeyParameters.getParameters().getHeight(), xMSSMTPublicKeyParameters.getParameters().getLayers(), a.b(xMSSMTPublicKeyParameters.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSMTPublicKey(xMSSMTPublicKeyParameters.getPublicSeed(), xMSSMTPublicKeyParameters.getRoot()));
        }
        if (publicKey instanceof McElieceCCA2PublicKeyParameters) {
            McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters = (McElieceCCA2PublicKeyParameters)publicKey;
            McElieceCCA2PublicKey mcElieceCCA2PublicKey = new McElieceCCA2PublicKey(mcElieceCCA2PublicKeyParameters.getN(), mcElieceCCA2PublicKeyParameters.getT(), mcElieceCCA2PublicKeyParameters.getG(), a.c(mcElieceCCA2PublicKeyParameters.getDigest()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
            return new SubjectPublicKeyInfo(algorithmIdentifier, mcElieceCCA2PublicKey);
        }
        if (publicKey instanceof FrodoPublicKeyParameters) {
            FrodoPublicKeyParameters frodoPublicKeyParameters = (FrodoPublicKeyParameters)publicKey;
            byte[] byArray = frodoPublicKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(frodoPublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        if (publicKey instanceof SABERPublicKeyParameters) {
            SABERPublicKeyParameters sABERPublicKeyParameters = (SABERPublicKeyParameters)publicKey;
            byte[] byArray = sABERPublicKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(sABERPublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DERSequence(new DEROctetString(byArray)));
        }
        if (publicKey instanceof PicnicPublicKeyParameters) {
            PicnicPublicKeyParameters picnicPublicKeyParameters = (PicnicPublicKeyParameters)publicKey;
            byte[] byArray = picnicPublicKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(picnicPublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        if (publicKey instanceof NTRUPublicKeyParameters) {
            NTRUPublicKeyParameters nTRUPublicKeyParameters = (NTRUPublicKeyParameters)publicKey;
            byte[] byArray = nTRUPublicKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(nTRUPublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        if (publicKey instanceof FalconPublicKeyParameters) {
            FalconPublicKeyParameters falconPublicKeyParameters = (FalconPublicKeyParameters)publicKey;
            byte[] byArray = falconPublicKeyParameters.getH();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(falconPublicKeyParameters.getParameters()));
            byte[] byArray6 = new byte[byArray.length + 1];
            byArray6[0] = (byte)(0 + falconPublicKeyParameters.getParameters().getLogN());
            System.arraycopy(byArray, 0, byArray6, 1, byArray.length);
            return new SubjectPublicKeyInfo(algorithmIdentifier, byArray6);
        }
        if (publicKey instanceof KyberPublicKeyParameters) {
            KyberPublicKeyParameters kyberPublicKeyParameters = (KyberPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(kyberPublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, kyberPublicKeyParameters.getEncoded());
        }
        if (publicKey instanceof NTRULPRimePublicKeyParameters) {
            NTRULPRimePublicKeyParameters nTRULPRimePublicKeyParameters = (NTRULPRimePublicKeyParameters)publicKey;
            byte[] byArray = nTRULPRimePublicKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(nTRULPRimePublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        if (publicKey instanceof SNTRUPrimePublicKeyParameters) {
            SNTRUPrimePublicKeyParameters sNTRUPrimePublicKeyParameters = (SNTRUPrimePublicKeyParameters)publicKey;
            byte[] byArray = sNTRUPrimePublicKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(sNTRUPrimePublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        if (publicKey instanceof DilithiumPublicKeyParameters) {
            DilithiumPublicKeyParameters dilithiumPublicKeyParameters = (DilithiumPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(dilithiumPublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, dilithiumPublicKeyParameters.getEncoded());
        }
        if (publicKey instanceof BIKEPublicKeyParameters) {
            BIKEPublicKeyParameters bIKEPublicKeyParameters = (BIKEPublicKeyParameters)publicKey;
            byte[] byArray = bIKEPublicKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(bIKEPublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, byArray);
        }
        if (publicKey instanceof HQCPublicKeyParameters) {
            HQCPublicKeyParameters hQCPublicKeyParameters = (HQCPublicKeyParameters)publicKey;
            byte[] byArray = hQCPublicKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(hQCPublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, byArray);
        }
        if (publicKey instanceof RainbowPublicKeyParameters) {
            RainbowPublicKeyParameters rainbowPublicKeyParameters = (RainbowPublicKeyParameters)publicKey;
            byte[] byArray = rainbowPublicKeyParameters.getEncoded();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(a.a(rainbowPublicKeyParameters.getParameters()));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        throw new IOException("key parameters not recognized");
    }
}

