/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import com.enterprisedt.bouncycastle.util.Pack;

final class HashTreeAddress
extends XMSSAddress {
    private final int a;
    private final int b;
    private final int c;

    private HashTreeAddress(Builder builder) {
        super(builder);
        this.a = 0;
        this.b = builder.a;
        this.c = builder.b;
    }

    @Override
    protected byte[] toByteArray() {
        byte[] byArray = super.toByteArray();
        Pack.intToBigEndian(this.a, byArray, 16);
        Pack.intToBigEndian(this.b, byArray, 20);
        Pack.intToBigEndian(this.c, byArray, 24);
        return byArray;
    }

    protected int a() {
        return this.b;
    }

    protected int b() {
        return this.c;
    }

    protected static class Builder
    extends XMSSAddress.Builder<Builder> {
        private int a = 0;
        private int b = 0;

        protected Builder() {
            super(2);
        }

        protected Builder withTreeHeight(int val) {
            this.a = val;
            return this;
        }

        protected Builder withTreeIndex(int val) {
            this.b = val;
            return this;
        }

        @Override
        protected XMSSAddress build() {
            return new HashTreeAddress(this);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

