/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSKeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSKeyPairGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSSigner;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.d;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.h;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;
import java.text.ParseException;

public class XMSS {
    private final XMSSParameters a;
    private d b;
    private SecureRandom c;
    private XMSSPrivateKeyParameters d;
    private XMSSPublicKeyParameters e;

    public XMSS(XMSSParameters params, SecureRandom prng) {
        if (params == null) {
            throw new NullPointerException("params == null");
        }
        this.a = params;
        this.b = params.d();
        this.c = prng;
    }

    public void generateKeys() {
        XMSSKeyPairGenerator xMSSKeyPairGenerator = new XMSSKeyPairGenerator();
        xMSSKeyPairGenerator.init(new XMSSKeyGenerationParameters(this.getParams(), this.c));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = xMSSKeyPairGenerator.generateKeyPair();
        this.d = (XMSSPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        this.e = (XMSSPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        this.b.a(new byte[this.a.getTreeDigestSize()], this.d.getPublicSeed());
    }

    public void importState(XMSSPrivateKeyParameters privateKey, XMSSPublicKeyParameters publicKey) {
        if (!Arrays.areEqual(privateKey.getRoot(), publicKey.getRoot())) {
            throw new IllegalStateException("root of private key and public key do not match");
        }
        if (!Arrays.areEqual(privateKey.getPublicSeed(), publicKey.getPublicSeed())) {
            throw new IllegalStateException("public seed of private key and public key do not match");
        }
        this.d = privateKey;
        this.e = publicKey;
        this.b.a(new byte[this.a.getTreeDigestSize()], this.d.getPublicSeed());
    }

    public void importState(byte[] privateKey, byte[] publicKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey == null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = new XMSSPrivateKeyParameters.Builder(this.a).withPrivateKey(privateKey).build();
        XMSSPublicKeyParameters xMSSPublicKeyParameters = new XMSSPublicKeyParameters.Builder(this.a).withPublicKey(publicKey).build();
        if (!Arrays.areEqual(xMSSPrivateKeyParameters.getRoot(), xMSSPublicKeyParameters.getRoot())) {
            throw new IllegalStateException("root of private key and public key do not match");
        }
        if (!Arrays.areEqual(xMSSPrivateKeyParameters.getPublicSeed(), xMSSPublicKeyParameters.getPublicSeed())) {
            throw new IllegalStateException("public seed of private key and public key do not match");
        }
        this.d = xMSSPrivateKeyParameters;
        this.e = xMSSPublicKeyParameters;
        this.b.a(new byte[this.a.getTreeDigestSize()], this.d.getPublicSeed());
    }

    public byte[] sign(byte[] message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        XMSSSigner xMSSSigner = new XMSSSigner();
        xMSSSigner.init(true, this.d);
        byte[] byArray = xMSSSigner.generateSignature(message);
        this.d = (XMSSPrivateKeyParameters)xMSSSigner.getUpdatedPrivateKey();
        this.importState(this.d, this.e);
        return byArray;
    }

    public boolean verifySignature(byte[] message, byte[] signature, byte[] publicKey) throws ParseException {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (signature == null) {
            throw new NullPointerException("signature == null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSSigner xMSSSigner = new XMSSSigner();
        xMSSSigner.init(false, new XMSSPublicKeyParameters.Builder(this.getParams()).withPublicKey(publicKey).build());
        return xMSSSigner.verifySignature(message, signature);
    }

    public XMSSPrivateKeyParameters exportPrivateKey() {
        return this.d;
    }

    public XMSSPublicKeyParameters exportPublicKey() {
        return this.e;
    }

    protected h wotsSign(byte[] messageDigest, OTSHashAddress otsHashAddress) {
        if (messageDigest.length != this.a.getTreeDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (otsHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.b.a(this.b.b(this.d.getSecretKeySeed(), otsHashAddress), this.getPublicSeed());
        return this.b.a(messageDigest, otsHashAddress);
    }

    public XMSSParameters getParams() {
        return this.a;
    }

    protected d getWOTSPlus() {
        return this.b;
    }

    public byte[] getRoot() {
        return this.d.getRoot();
    }

    protected void setRoot(byte[] root) {
        this.d = new XMSSPrivateKeyParameters.Builder(this.a).withSecretKeySeed(this.d.getSecretKeySeed()).withSecretKeyPRF(this.d.getSecretKeyPRF()).withPublicSeed(this.getPublicSeed()).withRoot(root).withBDSState(this.d.b()).build();
        this.e = new XMSSPublicKeyParameters.Builder(this.a).withRoot(root).withPublicSeed(this.getPublicSeed()).build();
    }

    public int getIndex() {
        return this.d.getIndex();
    }

    protected void setIndex(int index) {
        this.d = new XMSSPrivateKeyParameters.Builder(this.a).withSecretKeySeed(this.d.getSecretKeySeed()).withSecretKeyPRF(this.d.getSecretKeyPRF()).withPublicSeed(this.d.getPublicSeed()).withRoot(this.d.getRoot()).withBDSState(this.d.b()).build();
    }

    public byte[] getPublicSeed() {
        return this.d.getPublicSeed();
    }

    protected void setPublicSeed(byte[] publicSeed) {
        this.d = new XMSSPrivateKeyParameters.Builder(this.a).withSecretKeySeed(this.d.getSecretKeySeed()).withSecretKeyPRF(this.d.getSecretKeyPRF()).withPublicSeed(publicSeed).withRoot(this.getRoot()).withBDSState(this.d.b()).build();
        this.e = new XMSSPublicKeyParameters.Builder(this.a).withRoot(this.getRoot()).withPublicSeed(publicSeed).build();
        this.b.a(new byte[this.a.getTreeDigestSize()], publicSeed);
    }

    public XMSSPrivateKeyParameters getPrivateKey() {
        return this.d;
    }
}

