/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTKeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTKeyPairGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTSigner;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;
import java.text.ParseException;

public final class XMSSMT {
    private XMSSMTParameters a;
    private XMSSParameters b;
    private SecureRandom c;
    private XMSSMTPrivateKeyParameters d;
    private XMSSMTPublicKeyParameters e;

    public XMSSMT(XMSSMTParameters params, SecureRandom prng) {
        if (params == null) {
            throw new NullPointerException("params == null");
        }
        this.a = params;
        this.b = params.getXMSSParameters();
        this.c = prng;
        this.d = new XMSSMTPrivateKeyParameters.Builder(params).build();
        this.e = new XMSSMTPublicKeyParameters.Builder(params).build();
    }

    public void generateKeys() {
        XMSSMTKeyPairGenerator xMSSMTKeyPairGenerator = new XMSSMTKeyPairGenerator();
        xMSSMTKeyPairGenerator.init(new XMSSMTKeyGenerationParameters(this.getParams(), this.c));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = xMSSMTKeyPairGenerator.generateKeyPair();
        this.d = (XMSSMTPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        this.e = (XMSSMTPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        this.a(this.d, this.e);
    }

    private void a(XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters, XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters) {
        this.b.d().a(new byte[this.a.getTreeDigestSize()], this.d.getPublicSeed());
        this.d = xMSSMTPrivateKeyParameters;
        this.e = xMSSMTPublicKeyParameters;
    }

    public void importState(byte[] privateKey, byte[] publicKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey == null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = new XMSSMTPrivateKeyParameters.Builder(this.a).withPrivateKey(privateKey).build();
        XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters = new XMSSMTPublicKeyParameters.Builder(this.a).withPublicKey(publicKey).build();
        if (!Arrays.areEqual(xMSSMTPrivateKeyParameters.getRoot(), xMSSMTPublicKeyParameters.getRoot())) {
            throw new IllegalStateException("root of private key and public key do not match");
        }
        if (!Arrays.areEqual(xMSSMTPrivateKeyParameters.getPublicSeed(), xMSSMTPublicKeyParameters.getPublicSeed())) {
            throw new IllegalStateException("public seed of private key and public key do not match");
        }
        this.b.d().a(new byte[this.a.getTreeDigestSize()], xMSSMTPrivateKeyParameters.getPublicSeed());
        this.d = xMSSMTPrivateKeyParameters;
        this.e = xMSSMTPublicKeyParameters;
    }

    public byte[] sign(byte[] message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        XMSSMTSigner xMSSMTSigner = new XMSSMTSigner();
        xMSSMTSigner.init(true, this.d);
        byte[] byArray = xMSSMTSigner.generateSignature(message);
        this.d = (XMSSMTPrivateKeyParameters)xMSSMTSigner.getUpdatedPrivateKey();
        this.a(this.d, this.e);
        return byArray;
    }

    public boolean verifySignature(byte[] message, byte[] signature, byte[] publicKey) throws ParseException {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (signature == null) {
            throw new NullPointerException("signature == null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTSigner xMSSMTSigner = new XMSSMTSigner();
        xMSSMTSigner.init(false, new XMSSMTPublicKeyParameters.Builder(this.getParams()).withPublicKey(publicKey).build());
        return xMSSMTSigner.verifySignature(message, signature);
    }

    public byte[] exportPrivateKey() {
        return this.d.toByteArray();
    }

    public byte[] exportPublicKey() {
        return this.e.toByteArray();
    }

    public XMSSMTParameters getParams() {
        return this.a;
    }

    public byte[] getPublicSeed() {
        return this.d.getPublicSeed();
    }

    protected XMSSParameters getXMSS() {
        return this.b;
    }
}

