/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Encodable;
import java.io.IOException;

public final class XMSSMTPrivateKeyParameters
extends XMSSMTKeyParameters
implements XMSSStoreableObjectInterface,
Encodable {
    private final XMSSMTParameters b;
    private final byte[] c;
    private final byte[] d;
    private final byte[] e;
    private final byte[] f;
    private volatile long g;
    private volatile BDSStateMap h;
    private volatile boolean i;

    private XMSSMTPrivateKeyParameters(Builder builder) {
        super(true, builder.a.getTreeDigest());
        this.b = builder.a;
        if (this.b == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.b.getTreeDigestSize();
        byte[] byArray = builder.i;
        if (byArray != null) {
            if (builder.j == null) {
                throw new NullPointerException("xmss == null");
            }
            int n3 = this.b.getHeight();
            int n4 = (n3 + 7) / 8;
            int n5 = n2;
            int n6 = n2;
            int n7 = n2;
            int n8 = n2;
            int n9 = 0;
            this.g = XMSSUtil.bytesToXBigEndian(byArray, n9, n4);
            if (!XMSSUtil.isIndexValid(n3, this.g)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.c = XMSSUtil.extractBytesAtOffset(byArray, n9 += n4, n5);
            this.d = XMSSUtil.extractBytesAtOffset(byArray, n9 += n5, n6);
            this.e = XMSSUtil.extractBytesAtOffset(byArray, n9 += n6, n7);
            this.f = XMSSUtil.extractBytesAtOffset(byArray, n9 += n7, n8);
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n8, byArray.length - n9);
            try {
                BDSStateMap bDSStateMap = (BDSStateMap)XMSSUtil.deserialize(byArray2, BDSStateMap.class);
                this.h = bDSStateMap.withWOTSDigest(builder.j.getTreeDigestOID());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
            }
        } else {
            this.g = builder.b;
            byte[] byArray3 = builder.d;
            if (byArray3 != null) {
                if (byArray3.length != n2) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.c = byArray3;
            } else {
                this.c = new byte[n2];
            }
            byte[] byArray4 = builder.e;
            if (byArray4 != null) {
                if (byArray4.length != n2) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.d = byArray4;
            } else {
                this.d = new byte[n2];
            }
            byte[] byArray5 = builder.f;
            if (byArray5 != null) {
                if (byArray5.length != n2) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.e = byArray5;
            } else {
                this.e = new byte[n2];
            }
            byte[] byArray6 = builder.g;
            if (byArray6 != null) {
                if (byArray6.length != n2) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.f = byArray6;
            } else {
                this.f = new byte[n2];
            }
            BDSStateMap bDSStateMap = builder.h;
            if (bDSStateMap != null) {
                this.h = bDSStateMap;
            } else {
                long l2 = builder.b;
                int n10 = this.b.getHeight();
                this.h = XMSSUtil.isIndexValid(n10, l2) && byArray5 != null && byArray3 != null ? new BDSStateMap(this.b, builder.b, byArray5, byArray3) : new BDSStateMap(builder.c + 1L);
            }
            if (builder.c >= 0L && builder.c != this.h.getMaxIndex()) {
                throw new IllegalArgumentException("maxIndex set but not reflected in state");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncoded() throws IOException {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            return this.toByteArray();
        }
    }

    @Override
    public byte[] toByteArray() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            int n2 = this.b.getTreeDigestSize();
            int n3 = (this.b.getHeight() + 7) / 8;
            int n4 = n2;
            int n5 = n2;
            int n6 = n2;
            int n7 = n2;
            int n8 = n3 + n4 + n5 + n6 + n7;
            byte[] byArray = new byte[n8];
            int n9 = 0;
            byte[] byArray2 = XMSSUtil.toBytesBigEndian(this.g, n3);
            XMSSUtil.copyBytesAtOffset(byArray, byArray2, n9);
            XMSSUtil.copyBytesAtOffset(byArray, this.c, n9 += n3);
            XMSSUtil.copyBytesAtOffset(byArray, this.d, n9 += n4);
            XMSSUtil.copyBytesAtOffset(byArray, this.e, n9 += n5);
            XMSSUtil.copyBytesAtOffset(byArray, this.f, n9 += n6);
            try {
                return Arrays.concatenate(byArray, XMSSUtil.serialize(this.h));
            }
            catch (IOException iOException) {
                throw new IllegalStateException("error serializing bds state: " + iOException.getMessage(), iOException);
            }
        }
    }

    public long getIndex() {
        return this.g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsagesRemaining() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            return this.h.getMaxIndex() - this.getIndex() + 1L;
        }
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray(this.c);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray(this.d);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.e);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.f);
    }

    BDSStateMap a() {
        return this.h;
    }

    public XMSSMTParameters getParameters() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMSSMTPrivateKeyParameters getNextKey() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            return this.extractKeyShard(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMSSMTPrivateKeyParameters b() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            if (this.getIndex() < this.h.getMaxIndex()) {
                this.h.a(this.b, this.g, this.e, this.c);
                ++this.g;
                this.i = false;
            } else {
                this.g = this.h.getMaxIndex() + 1L;
                this.h = new BDSStateMap(this.h.getMaxIndex());
                this.i = false;
            }
            return this;
        }
    }

    public XMSSMTPrivateKeyParameters extractKeyShard(int usageCount) {
        if (usageCount < 1) {
            throw new IllegalArgumentException("cannot ask for a shard with 0 keys");
        }
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            if ((long)usageCount <= this.getUsagesRemaining()) {
                XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters2 = new Builder(this.b).withSecretKeySeed(this.c).withSecretKeyPRF(this.d).withPublicSeed(this.e).withRoot(this.f).withIndex(this.getIndex()).withBDSState(new BDSStateMap(this.h, this.getIndex() + (long)usageCount - 1L)).build();
                for (int i2 = 0; i2 != usageCount; ++i2) {
                    this.b();
                }
                return xMSSMTPrivateKeyParameters2;
            }
            throw new IllegalArgumentException("usageCount exceeds usages remaining");
        }
    }

    public static class Builder {
        private final XMSSMTParameters a;
        private long b = 0L;
        private long c = -1L;
        private byte[] d = null;
        private byte[] e = null;
        private byte[] f = null;
        private byte[] g = null;
        private BDSStateMap h = null;
        private byte[] i = null;
        private XMSSParameters j = null;

        public Builder(XMSSMTParameters params) {
            this.a = params;
        }

        public Builder withIndex(long val) {
            this.b = val;
            return this;
        }

        public Builder withMaxIndex(long val) {
            this.c = val;
            return this;
        }

        public Builder withSecretKeySeed(byte[] val) {
            this.d = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withSecretKeyPRF(byte[] val) {
            this.e = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicSeed(byte[] val) {
            this.f = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withRoot(byte[] val) {
            this.g = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withBDSState(BDSStateMap val) {
            this.h = val.getMaxIndex() == 0L ? new BDSStateMap(val, (1L << this.a.getHeight()) - 1L) : val;
            return this;
        }

        public Builder withPrivateKey(byte[] privateKeyVal) {
            this.i = XMSSUtil.cloneArray(privateKeyVal);
            this.j = this.a.getXMSSParameters();
            return this;
        }

        public XMSSMTPrivateKeyParameters build() {
            return new XMSSMTPrivateKeyParameters(this);
        }
    }
}

