/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.util.Encodable;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.IOException;

public final class XMSSMTPublicKeyParameters
extends XMSSMTKeyParameters
implements XMSSStoreableObjectInterface,
Encodable {
    private final XMSSMTParameters b;
    private final int c;
    private final byte[] d;
    private final byte[] e;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XMSSMTPublicKeyParameters(Builder builder) {
        super(false, builder.a.getTreeDigest());
        this.b = builder.a;
        if (this.b == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.b.getTreeDigestSize();
        byte[] byArray = builder.d;
        if (byArray != null) {
            int n3 = 4;
            int n4 = n2;
            int n5 = n2;
            int n6 = 0;
            if (byArray.length == n4 + n5) {
                this.c = 0;
                this.d = XMSSUtil.extractBytesAtOffset(byArray, n6, n4);
                this.e = XMSSUtil.extractBytesAtOffset(byArray, n6 += n4, n5);
                return;
            } else {
                if (byArray.length != n3 + n4 + n5) throw new IllegalArgumentException("public key has wrong size");
                this.c = Pack.bigEndianToInt(byArray, 0);
                this.d = XMSSUtil.extractBytesAtOffset(byArray, n6 += n3, n4);
                this.e = XMSSUtil.extractBytesAtOffset(byArray, n6 += n4, n5);
            }
            return;
        } else {
            this.c = this.b.getOid() != null ? this.b.getOid().getOid() : 0;
            byte[] byArray2 = builder.b;
            if (byArray2 != null) {
                if (byArray2.length != n2) {
                    throw new IllegalArgumentException("length of root must be equal to length of digest");
                }
                this.d = byArray2;
            } else {
                this.d = new byte[n2];
            }
            byte[] byArray3 = builder.c;
            if (byArray3 != null) {
                if (byArray3.length != n2) {
                    throw new IllegalArgumentException("length of publicSeed must be equal to length of digest");
                }
                this.e = byArray3;
                return;
            } else {
                this.e = new byte[n2];
            }
        }
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.toByteArray();
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray;
        int n2 = this.b.getTreeDigestSize();
        int n3 = 4;
        int n4 = n2;
        int n5 = n2;
        int n6 = 0;
        if (this.c != 0) {
            byArray = new byte[n3 + n4 + n5];
            Pack.intToBigEndian(this.c, byArray, n6);
            n6 += n3;
        } else {
            byArray = new byte[n4 + n5];
        }
        XMSSUtil.copyBytesAtOffset(byArray, this.d, n6);
        XMSSUtil.copyBytesAtOffset(byArray, this.e, n6 += n4);
        return byArray;
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.d);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.e);
    }

    public XMSSMTParameters getParameters() {
        return this.b;
    }

    public static class Builder {
        private final XMSSMTParameters a;
        private byte[] b = null;
        private byte[] c = null;
        private byte[] d = null;

        public Builder(XMSSMTParameters params) {
            this.a = params;
        }

        public Builder withRoot(byte[] val) {
            this.b = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicSeed(byte[] val) {
            this.c = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicKey(byte[] val) {
            this.d = XMSSUtil.cloneArray(val);
            return this;
        }

        public XMSSMTPublicKeyParameters build() {
            return new XMSSMTPublicKeyParameters(this);
        }
    }
}

