/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.DefaultXMSSOid;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSOid;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.b;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.d;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.f;
import com.enterprisedt.bouncycastle.util.Integers;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class XMSSParameters {
    private static final Map<Integer, XMSSParameters> a;
    private final XMSSOid b;
    private final int c;
    private final int d;
    private final ASN1ObjectIdentifier e;
    private final int f;
    private final String g;
    private final int h;
    private final f i;

    public XMSSParameters(int height, Digest treeDigest) {
        this(height, com.enterprisedt.bouncycastle.pqc.crypto.xmss.b.a(treeDigest.getAlgorithmName()));
    }

    public XMSSParameters(int height, ASN1ObjectIdentifier treeDigestOID) {
        if (height < 2) {
            throw new IllegalArgumentException("height must be >= 2");
        }
        if (treeDigestOID == null) {
            throw new NullPointerException("digest == null");
        }
        this.c = height;
        this.d = this.g();
        this.g = com.enterprisedt.bouncycastle.pqc.crypto.xmss.b.b(treeDigestOID);
        this.e = treeDigestOID;
        this.i = new f(treeDigestOID);
        this.h = this.i.a();
        this.f = this.i.b();
        this.b = DefaultXMSSOid.lookup(this.g, this.h, this.f, this.i.c(), height);
    }

    private int g() {
        for (int i2 = 2; i2 <= this.c; ++i2) {
            if ((this.c - i2) % 2 != 0) continue;
            return i2;
        }
        throw new IllegalStateException("should never happen...");
    }

    public int getTreeDigestSize() {
        return this.h;
    }

    public ASN1ObjectIdentifier getTreeDigestOID() {
        return this.e;
    }

    public int getHeight() {
        return this.c;
    }

    String a() {
        return this.g;
    }

    int b() {
        return this.i.c();
    }

    int c() {
        return this.f;
    }

    d d() {
        return new d(this.i);
    }

    XMSSOid e() {
        return this.b;
    }

    int f() {
        return this.d;
    }

    public static XMSSParameters lookupByOID(int oid) {
        return a.get(Integers.valueOf(oid));
    }

    static {
        HashMap<Integer, XMSSParameters> hashMap = new HashMap<Integer, XMSSParameters>();
        hashMap.put(Integers.valueOf(1), new XMSSParameters(10, NISTObjectIdentifiers.id_sha256));
        hashMap.put(Integers.valueOf(2), new XMSSParameters(16, NISTObjectIdentifiers.id_sha256));
        hashMap.put(Integers.valueOf(3), new XMSSParameters(20, NISTObjectIdentifiers.id_sha256));
        hashMap.put(Integers.valueOf(4), new XMSSParameters(10, NISTObjectIdentifiers.id_sha512));
        hashMap.put(Integers.valueOf(5), new XMSSParameters(16, NISTObjectIdentifiers.id_sha512));
        hashMap.put(Integers.valueOf(6), new XMSSParameters(20, NISTObjectIdentifiers.id_sha512));
        hashMap.put(Integers.valueOf(7), new XMSSParameters(10, NISTObjectIdentifiers.id_shake128));
        hashMap.put(Integers.valueOf(8), new XMSSParameters(16, NISTObjectIdentifiers.id_shake128));
        hashMap.put(Integers.valueOf(9), new XMSSParameters(20, NISTObjectIdentifiers.id_shake128));
        hashMap.put(Integers.valueOf(10), new XMSSParameters(10, NISTObjectIdentifiers.id_shake256));
        hashMap.put(Integers.valueOf(11), new XMSSParameters(16, NISTObjectIdentifiers.id_shake256));
        hashMap.put(Integers.valueOf(12), new XMSSParameters(20, NISTObjectIdentifiers.id_shake256));
        a = Collections.unmodifiableMap(hashMap);
    }
}

