/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.HashSet;
import java.util.Set;

public class XMSSUtil {
    public static int log2(int n2) {
        int n3 = 0;
        while ((n2 >>= 1) != 0) {
            ++n3;
        }
        return n3;
    }

    public static byte[] toBytesBigEndian(long value, int sizeInByte) {
        byte[] byArray = new byte[sizeInByte];
        for (int i2 = sizeInByte - 1; i2 >= 0; --i2) {
            byArray[i2] = (byte)value;
            value >>>= 8;
        }
        return byArray;
    }

    public static void longToBigEndian(long value, byte[] in, int offset) {
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        if (in.length - offset < 8) {
            throw new IllegalArgumentException("not enough space in array");
        }
        in[offset] = (byte)(value >> 56 & 0xFFL);
        in[offset + 1] = (byte)(value >> 48 & 0xFFL);
        in[offset + 2] = (byte)(value >> 40 & 0xFFL);
        in[offset + 3] = (byte)(value >> 32 & 0xFFL);
        in[offset + 4] = (byte)(value >> 24 & 0xFFL);
        in[offset + 5] = (byte)(value >> 16 & 0xFFL);
        in[offset + 6] = (byte)(value >> 8 & 0xFFL);
        in[offset + 7] = (byte)(value & 0xFFL);
    }

    public static long bytesToXBigEndian(byte[] in, int offset, int size) {
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        long l2 = 0L;
        for (int i2 = offset; i2 < offset + size; ++i2) {
            l2 = l2 << 8 | (long)(in[i2] & 0xFF);
        }
        return l2;
    }

    public static byte[] cloneArray(byte[] in) {
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        byte[] byArray = new byte[in.length];
        System.arraycopy(in, 0, byArray, 0, in.length);
        return byArray;
    }

    public static byte[][] cloneArray(byte[][] in) {
        if (XMSSUtil.hasNullPointer(in)) {
            throw new NullPointerException("in has null pointers");
        }
        byte[][] byArrayArray = new byte[in.length][];
        for (int i2 = 0; i2 < in.length; ++i2) {
            byArrayArray[i2] = new byte[in[i2].length];
            System.arraycopy(in[i2], 0, byArrayArray[i2], 0, in[i2].length);
        }
        return byArrayArray;
    }

    public static boolean areEqual(byte[][] a2, byte[][] b2) {
        if (XMSSUtil.hasNullPointer(a2) || XMSSUtil.hasNullPointer(b2)) {
            throw new NullPointerException("a or b == null");
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (Arrays.areEqual(a2[i2], b2[i2])) continue;
            return false;
        }
        return true;
    }

    public static void dumpByteArray(byte[][] x) {
        if (XMSSUtil.hasNullPointer(x)) {
            throw new NullPointerException("x has null pointers");
        }
        for (int i2 = 0; i2 < x.length; ++i2) {
            System.out.println(Hex.toHexString(x[i2]));
        }
    }

    public static boolean hasNullPointer(byte[][] in) {
        if (in == null) {
            return true;
        }
        for (int i2 = 0; i2 < in.length; ++i2) {
            if (in[i2] != null) continue;
            return true;
        }
        return false;
    }

    public static void copyBytesAtOffset(byte[] dst, byte[] src, int offset) {
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset hast to be >= 0");
        }
        if (src.length + offset > dst.length) {
            throw new IllegalArgumentException("src length + offset must not be greater than size of destination");
        }
        for (int i2 = 0; i2 < src.length; ++i2) {
            dst[offset + i2] = src[i2];
        }
    }

    public static byte[] extractBytesAtOffset(byte[] src, int offset, int length) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset hast to be >= 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length hast to be >= 0");
        }
        if (offset + length > src.length) {
            throw new IllegalArgumentException("offset + length must not be greater then size of source array");
        }
        byte[] byArray = new byte[length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = src[offset + i2];
        }
        return byArray;
    }

    public static boolean isIndexValid(int height, long index) {
        if (index < 0L) {
            throw new IllegalStateException("index must not be negative");
        }
        return index < 1L << height;
    }

    public static int getDigestSize(Digest digest) {
        if (digest == null) {
            throw new NullPointerException("digest == null");
        }
        String string = digest.getAlgorithmName();
        if (string.equals("SHAKE128")) {
            return 32;
        }
        if (string.equals("SHAKE256")) {
            return 64;
        }
        return digest.getDigestSize();
    }

    public static long getTreeIndex(long index, int xmssTreeHeight) {
        return index >> xmssTreeHeight;
    }

    public static int getLeafIndex(long index, int xmssTreeHeight) {
        return (int)(index & (1L << xmssTreeHeight) - 1L);
    }

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(obj);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserialize(byte[] data, Class clazz) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        a a2 = new a(clazz, byteArrayInputStream);
        Object object = a2.readObject();
        if (a2.available() != 0) {
            throw new IOException("unexpected data found at end of ObjectInputStream");
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        throw new IOException("unexpected class found in ObjectInputStream");
    }

    public static int calculateTau(int index, int height) {
        int n2 = 0;
        for (int i2 = 0; i2 < height; ++i2) {
            if ((index >> i2 & 1) != 0) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    public static boolean isNewBDSInitNeeded(long globalIndex, int xmssHeight, int layer) {
        if (globalIndex == 0L) {
            return false;
        }
        return globalIndex % (long)Math.pow(1 << xmssHeight, layer + 1) == 0L;
    }

    public static boolean isNewAuthenticationPathNeeded(long globalIndex, int xmssHeight, int layer) {
        if (globalIndex == 0L) {
            return false;
        }
        return (globalIndex + 1L) % (long)Math.pow(1 << xmssHeight, layer) == 0L;
    }

    private static class a
    extends ObjectInputStream {
        private static final Set a = new HashSet();
        private final Class b;
        private boolean c = false;

        a(Class clazz, InputStream inputStream) throws IOException {
            super(inputStream);
            this.b = clazz;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (!this.c) {
                if (!desc.getName().equals(this.b.getName())) {
                    throw new InvalidClassException("unexpected class: ", desc.getName());
                }
                this.c = true;
            } else if (!a.contains(desc.getName())) {
                throw new InvalidClassException("unexpected class: ", desc.getName());
            }
            return super.resolveClass(desc);
        }

        static {
            a.add("java.util.TreeMap");
            a.add("java.lang.Integer");
            a.add("java.lang.Number");
            a.add("com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDS");
            a.add("java.util.ArrayList");
            a.add("com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSNode");
            a.add("[B");
            a.add("java.util.LinkedList");
            a.add("java.util.Stack");
            a.add("java.util.Vector");
            a.add("[Ljava.lang.Object;");
            a.add("com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDSTreeHash");
        }
    }
}

