/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSDigestProvider;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSLeaf;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSRootCalc;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSRootSig;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.Treehash;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.util.GMSSRandom;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.util.WinternitzOTSignature;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.util.Vector;

public class GMSSPrivateKeyParameters
extends GMSSKeyParameters {
    private int[] b;
    private byte[][] c;
    private byte[][] d;
    private byte[][][] e;
    private byte[][][] f;
    private Treehash[][] g;
    private Treehash[][] h;
    private Vector[] i;
    private Vector[] j;
    private Vector[][] k;
    private Vector[][] l;
    private byte[][][] m;
    private GMSSLeaf[] n;
    private GMSSLeaf[] o;
    private GMSSLeaf[] p;
    private int[] q;
    private GMSSParameters r;
    private byte[][] s;
    private GMSSRootCalc[] t;
    private byte[][] u;
    private GMSSRootSig[] v;
    private GMSSDigestProvider w;
    private boolean x = false;
    private int[] y;
    private int[] z;
    private int[] A;
    private int B;
    private Digest C;
    private int D;
    private GMSSRandom E;
    private int[] F;

    public GMSSPrivateKeyParameters(byte[][] currentSeed, byte[][] nextNextSeed, byte[][][] currentAuthPath, byte[][][] nextAuthPath, Treehash[][] currentTreehash, Treehash[][] nextTreehash, Vector[] currentStack, Vector[] nextStack, Vector[][] currentRetain, Vector[][] nextRetain, byte[][] nextRoot, byte[][] currentRootSig, GMSSParameters gmssParameterset, GMSSDigestProvider digestProvider) {
        this(null, currentSeed, nextNextSeed, currentAuthPath, nextAuthPath, null, currentTreehash, nextTreehash, currentStack, nextStack, currentRetain, nextRetain, null, null, null, null, nextRoot, null, currentRootSig, null, gmssParameterset, digestProvider);
    }

    public GMSSPrivateKeyParameters(int[] index, byte[][] currentSeeds, byte[][] nextNextSeeds, byte[][][] currentAuthPaths, byte[][][] nextAuthPaths, byte[][][] keep, Treehash[][] currentTreehash, Treehash[][] nextTreehash, Vector[] currentStack, Vector[] nextStack, Vector[][] currentRetain, Vector[][] nextRetain, GMSSLeaf[] nextNextLeaf, GMSSLeaf[] upperLeaf, GMSSLeaf[] upperTreehashLeaf, int[] minTreehash, byte[][] nextRoot, GMSSRootCalc[] nextNextRoot, byte[][] currentRootSig, GMSSRootSig[] nextRootSig, GMSSParameters gmssParameterset, GMSSDigestProvider digestProvider) {
        super(true, gmssParameterset);
        int n2;
        this.C = digestProvider.get();
        this.D = this.C.getDigestSize();
        this.r = gmssParameterset;
        this.z = gmssParameterset.getWinternitzParameter();
        this.A = gmssParameterset.getK();
        this.y = gmssParameterset.getHeightOfTrees();
        this.B = this.r.getNumOfLayers();
        if (index == null) {
            this.b = new int[this.B];
            for (n2 = 0; n2 < this.B; ++n2) {
                this.b[n2] = 0;
            }
        } else {
            this.b = index;
        }
        this.c = currentSeeds;
        this.d = nextNextSeeds;
        this.e = Arrays.clone(currentAuthPaths);
        this.f = nextAuthPaths;
        if (keep == null) {
            this.m = new byte[this.B][][];
            for (n2 = 0; n2 < this.B; ++n2) {
                this.m[n2] = new byte[(int)Math.floor(this.y[n2] / 2)][this.D];
            }
        } else {
            this.m = keep;
        }
        if (currentStack == null) {
            this.i = new Vector[this.B];
            for (n2 = 0; n2 < this.B; ++n2) {
                this.i[n2] = new Vector();
            }
        } else {
            this.i = currentStack;
        }
        if (nextStack == null) {
            this.j = new Vector[this.B - 1];
            for (n2 = 0; n2 < this.B - 1; ++n2) {
                this.j[n2] = new Vector();
            }
        } else {
            this.j = nextStack;
        }
        this.g = currentTreehash;
        this.h = nextTreehash;
        this.k = currentRetain;
        this.l = nextRetain;
        this.s = nextRoot;
        this.w = digestProvider;
        if (nextNextRoot == null) {
            this.t = new GMSSRootCalc[this.B - 1];
            for (n2 = 0; n2 < this.B - 1; ++n2) {
                this.t[n2] = new GMSSRootCalc(this.y[n2 + 1], this.A[n2 + 1], this.w);
            }
        } else {
            this.t = nextNextRoot;
        }
        this.u = currentRootSig;
        this.F = new int[this.B];
        for (n2 = 0; n2 < this.B; ++n2) {
            this.F[n2] = 1 << this.y[n2];
        }
        this.E = new GMSSRandom(this.C);
        if (this.B > 1) {
            if (nextNextLeaf == null) {
                this.n = new GMSSLeaf[this.B - 2];
                for (n2 = 0; n2 < this.B - 2; ++n2) {
                    this.n[n2] = new GMSSLeaf(digestProvider.get(), this.z[n2 + 1], this.F[n2 + 2], this.d[n2]);
                }
            } else {
                this.n = nextNextLeaf;
            }
        } else {
            this.n = new GMSSLeaf[0];
        }
        if (upperLeaf == null) {
            this.o = new GMSSLeaf[this.B - 1];
            for (n2 = 0; n2 < this.B - 1; ++n2) {
                this.o[n2] = new GMSSLeaf(digestProvider.get(), this.z[n2], this.F[n2 + 1], this.c[n2]);
            }
        } else {
            this.o = upperLeaf;
        }
        if (upperTreehashLeaf == null) {
            this.p = new GMSSLeaf[this.B - 1];
            for (n2 = 0; n2 < this.B - 1; ++n2) {
                this.p[n2] = new GMSSLeaf(digestProvider.get(), this.z[n2], this.F[n2 + 1]);
            }
        } else {
            this.p = upperTreehashLeaf;
        }
        if (minTreehash == null) {
            this.q = new int[this.B - 1];
            for (n2 = 0; n2 < this.B - 1; ++n2) {
                this.q[n2] = -1;
            }
        } else {
            this.q = minTreehash;
        }
        byte[] byArray = new byte[this.D];
        byte[] byArray2 = new byte[this.D];
        if (nextRootSig == null) {
            this.v = new GMSSRootSig[this.B - 1];
            for (int i2 = 0; i2 < this.B - 1; ++i2) {
                System.arraycopy(currentSeeds[i2], 0, byArray, 0, this.D);
                this.E.nextSeed(byArray);
                byArray2 = this.E.nextSeed(byArray);
                this.v[i2] = new GMSSRootSig(digestProvider.get(), this.z[i2], this.y[i2 + 1]);
                this.v[i2].initSign(byArray2, nextRoot[i2]);
            }
        } else {
            this.v = nextRootSig;
        }
    }

    private GMSSPrivateKeyParameters(GMSSPrivateKeyParameters original) {
        super(true, original.getParameters());
        this.b = Arrays.clone(original.b);
        this.c = Arrays.clone(original.c);
        this.d = Arrays.clone(original.d);
        this.e = Arrays.clone(original.e);
        this.f = Arrays.clone(original.f);
        this.g = original.g;
        this.h = original.h;
        this.i = original.i;
        this.j = original.j;
        this.k = original.k;
        this.l = original.l;
        this.m = Arrays.clone(original.m);
        this.n = original.n;
        this.o = original.o;
        this.p = original.p;
        this.q = original.q;
        this.r = original.r;
        this.s = Arrays.clone(original.s);
        this.t = original.t;
        this.u = original.u;
        this.v = original.v;
        this.w = original.w;
        this.y = original.y;
        this.z = original.z;
        this.A = original.A;
        this.B = original.B;
        this.C = original.C;
        this.D = original.D;
        this.E = original.E;
        this.F = original.F;
    }

    public boolean isUsed() {
        return this.x;
    }

    public void markUsed() {
        this.x = true;
    }

    public GMSSPrivateKeyParameters nextKey() {
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = new GMSSPrivateKeyParameters(this);
        gMSSPrivateKeyParameters.a(this.r.getNumOfLayers() - 1);
        return gMSSPrivateKeyParameters;
    }

    private void a(int n2) {
        if (n2 == this.B - 1) {
            int n3 = n2;
            this.b[n3] = this.b[n3] + 1;
        }
        if (this.b[n2] == this.F[n2]) {
            if (this.B != 1) {
                this.b(n2);
                this.b[n2] = 0;
            }
        } else {
            this.c(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void b(int n2) {
        if (n2 > 0) {
            int n3 = n2 - 1;
            this.b[n3] = this.b[n3] + 1;
            boolean bl = true;
            int n4 = n2;
            do {
                if (this.b[--n4] >= this.F[n4]) continue;
                bl = false;
            } while (bl && n4 > 0);
            if (!bl) {
                int n5;
                this.E.nextSeed(this.c[n2]);
                this.v[n2 - 1].updateSign();
                if (n2 > 1) {
                    this.n[n2 - 1 - 1] = this.n[n2 - 1 - 1].a();
                }
                this.o[n2 - 1] = this.o[n2 - 1].a();
                if (this.q[n2 - 1] >= 0) {
                    this.p[n2 - 1] = this.p[n2 - 1].a();
                    byte[] byArray = this.p[n2 - 1].getLeaf();
                    try {
                        this.g[n2 - 1][this.q[n2 - 1]].update(this.E, byArray);
                        if (!this.g[n2 - 1][this.q[n2 - 1]].wasFinished()) {
                            // empty if block
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
                this.g(n2);
                this.u[n2 - 1] = this.v[n2 - 1].getSig();
                for (n5 = 0; n5 < this.y[n2] - this.A[n2]; ++n5) {
                    this.g[n2][n5] = this.h[n2 - 1][n5];
                    this.h[n2 - 1][n5] = this.t[n2 - 1].getTreehash()[n5];
                }
                for (n5 = 0; n5 < this.y[n2]; ++n5) {
                    System.arraycopy(this.f[n2 - 1][n5], 0, this.e[n2][n5], 0, this.D);
                    System.arraycopy(this.t[n2 - 1].getAuthPath()[n5], 0, this.f[n2 - 1][n5], 0, this.D);
                }
                for (n5 = 0; n5 < this.A[n2] - 1; ++n5) {
                    this.k[n2][n5] = this.l[n2 - 1][n5];
                    this.l[n2 - 1][n5] = this.t[n2 - 1].getRetain()[n5];
                }
                this.i[n2] = this.j[n2 - 1];
                this.j[n2 - 1] = this.t[n2 - 1].getStack();
                this.s[n2 - 1] = this.t[n2 - 1].getRoot();
                byte[] byArray = new byte[this.D];
                byte[] byArray2 = new byte[this.D];
                System.arraycopy(this.c[n2 - 1], 0, byArray2, 0, this.D);
                byArray = this.E.nextSeed(byArray2);
                byArray = this.E.nextSeed(byArray2);
                byArray = this.E.nextSeed(byArray2);
                this.v[n2 - 1].initSign(byArray, this.s[n2 - 1]);
                this.a(n2 - 1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void c(int n2) {
        this.e(n2);
        if (n2 > 0) {
            if (n2 > 1) {
                this.n[n2 - 1 - 1] = this.n[n2 - 1 - 1].a();
            }
            this.o[n2 - 1] = this.o[n2 - 1].a();
            int n3 = (int)Math.floor((double)(this.getNumLeafs(n2) * 2) / (double)(this.y[n2 - 1] - this.A[n2 - 1]));
            if (this.b[n2] % n3 == 1) {
                byte[] byArray;
                if (this.b[n2] > 1 && this.q[n2 - 1] >= 0) {
                    byArray = this.p[n2 - 1].getLeaf();
                    try {
                        this.g[n2 - 1][this.q[n2 - 1]].update(this.E, byArray);
                        if (!this.g[n2 - 1][this.q[n2 - 1]].wasFinished()) {
                            // empty if block
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
                this.q[n2 - 1] = this.d(n2 - 1);
                if (this.q[n2 - 1] >= 0) {
                    byArray = this.g[n2 - 1][this.q[n2 - 1]].getSeedActive();
                    this.p[n2 - 1] = new GMSSLeaf(this.w.get(), this.z[n2 - 1], n3, byArray);
                    this.p[n2 - 1] = this.p[n2 - 1].a();
                }
            } else if (this.q[n2 - 1] >= 0) {
                this.p[n2 - 1] = this.p[n2 - 1].a();
            }
            this.v[n2 - 1].updateSign();
            if (this.b[n2] == 1) {
                this.t[n2 - 1].initialize(new Vector());
            }
            this.g(n2);
        }
    }

    private int d(int n2) {
        int n3 = -1;
        for (int i2 = 0; i2 < this.y[n2] - this.A[n2]; ++i2) {
            if (!this.g[n2][i2].wasInitialized() || this.g[n2][i2].wasFinished()) continue;
            if (n3 == -1) {
                n3 = i2;
                continue;
            }
            if (this.g[n2][i2].getLowestNodeHeight() >= this.g[n2][n3].getLowestNodeHeight()) continue;
            n3 = i2;
        }
        return n3;
    }

    private void e(int n2) {
        int n3;
        Object object;
        int n4;
        int n5 = this.b[n2];
        int n6 = this.y[n2];
        int n7 = this.A[n2];
        for (n4 = 0; n4 < n6 - n7; ++n4) {
            this.g[n2][n4].updateNextSeed(this.E);
        }
        n4 = this.f(n5);
        byte[] byArray = new byte[this.D];
        byArray = this.E.nextSeed(this.c[n2]);
        int n8 = n5 >>> n4 + 1 & 1;
        byte[] byArray2 = new byte[this.D];
        if (n4 < n6 - 1 && n8 == 0) {
            System.arraycopy(this.e[n2][n4], 0, byArray2, 0, this.D);
        }
        byte[] byArray3 = new byte[this.D];
        if (n4 == 0) {
            if (n2 == this.B - 1) {
                object = new WinternitzOTSignature(byArray, this.w.get(), this.z[n2]);
                byArray3 = ((WinternitzOTSignature)object).getPublicKey();
            } else {
                object = new byte[this.D];
                System.arraycopy(this.c[n2], 0, object, 0, this.D);
                this.E.nextSeed((byte[])object);
                byArray3 = this.o[n2].getLeaf();
                this.o[n2].a((byte[])object);
            }
            System.arraycopy(byArray3, 0, this.e[n2][0], 0, this.D);
        } else {
            object = new byte[this.D << 1];
            System.arraycopy(this.e[n2][n4 - 1], 0, object, 0, this.D);
            System.arraycopy(this.m[n2][(int)Math.floor((n4 - 1) / 2)], 0, object, this.D, this.D);
            this.C.update((byte[])object, 0, ((Object)object).length);
            this.e[n2][n4] = new byte[this.C.getDigestSize()];
            this.C.doFinal(this.e[n2][n4], 0);
            for (n3 = 0; n3 < n4; ++n3) {
                int n9;
                if (n3 < n6 - n7) {
                    if (this.g[n2][n3].wasFinished()) {
                        System.arraycopy(this.g[n2][n3].getFirstNode(), 0, this.e[n2][n3], 0, this.D);
                        this.g[n2][n3].destroy();
                    } else {
                        System.err.println("Treehash (" + n2 + "," + n3 + ") not finished when needed in AuthPathComputation");
                    }
                }
                if (n3 < n6 - 1 && n3 >= n6 - n7 && this.k[n2][n3 - (n6 - n7)].size() > 0) {
                    System.arraycopy(this.k[n2][n3 - (n6 - n7)].lastElement(), 0, this.e[n2][n3], 0, this.D);
                    this.k[n2][n3 - (n6 - n7)].removeElementAt(this.k[n2][n3 - (n6 - n7)].size() - 1);
                }
                if (n3 >= n6 - n7 || (n9 = n5 + 3 * (1 << n3)) >= this.F[n2]) continue;
                this.g[n2][n3].initialize();
            }
        }
        if (n4 < n6 - 1 && n8 == 0) {
            System.arraycopy(byArray2, 0, this.m[n2][(int)Math.floor(n4 / 2)], 0, this.D);
        }
        if (n2 == this.B - 1) {
            for (int i2 = 1; i2 <= (n6 - n7) / 2; ++i2) {
                n3 = this.d(n2);
                if (n3 < 0) continue;
                try {
                    byte[] byArray4 = new byte[this.D];
                    System.arraycopy(this.g[n2][n3].getSeedActive(), 0, byArray4, 0, this.D);
                    byte[] byArray5 = this.E.nextSeed(byArray4);
                    WinternitzOTSignature winternitzOTSignature = new WinternitzOTSignature(byArray5, this.w.get(), this.z[n2]);
                    byte[] byArray6 = winternitzOTSignature.getPublicKey();
                    this.g[n2][n3].update(this.E, byArray6);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        } else {
            this.q[n2] = this.d(n2);
        }
    }

    private int f(int n2) {
        if (n2 == 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = 1;
        while (n2 % n4 == 0) {
            n4 *= 2;
            ++n3;
        }
        return n3 - 1;
    }

    private void g(int n2) {
        byte[] byArray = new byte[this.D];
        byArray = this.E.nextSeed(this.d[n2 - 1]);
        if (n2 == this.B - 1) {
            WinternitzOTSignature winternitzOTSignature = new WinternitzOTSignature(byArray, this.w.get(), this.z[n2]);
            this.t[n2 - 1].update(this.d[n2 - 1], winternitzOTSignature.getPublicKey());
        } else {
            this.t[n2 - 1].update(this.d[n2 - 1], this.n[n2 - 1].getLeaf());
            this.n[n2 - 1].a(this.d[n2 - 1]);
        }
    }

    public int[] getIndex() {
        return this.b;
    }

    public int getIndex(int i2) {
        return this.b[i2];
    }

    public byte[][] getCurrentSeeds() {
        return Arrays.clone(this.c);
    }

    public byte[][][] getCurrentAuthPaths() {
        return Arrays.clone(this.e);
    }

    public byte[] getSubtreeRootSig(int i2) {
        return this.u[i2];
    }

    public GMSSDigestProvider getName() {
        return this.w;
    }

    public int getNumLeafs(int i2) {
        return this.F[i2];
    }
}

