/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSDigestProvider;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.gmss.GMSSSigner;
import com.enterprisedt.bouncycastle.util.Memoable;

public class GMSSStateAwareSigner
implements StateAwareMessageSigner {
    private final GMSSSigner a;
    private GMSSPrivateKeyParameters b;

    public GMSSStateAwareSigner(Digest digest) {
        if (!(digest instanceof Memoable)) {
            throw new IllegalArgumentException("digest must implement Memoable");
        }
        final Memoable memoable = ((Memoable)((Object)digest)).copy();
        this.a = new GMSSSigner(new GMSSDigestProvider(){

            @Override
            public Digest get() {
                return (Digest)((Object)memoable.copy());
            }
        });
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
                this.b = (GMSSPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.b = (GMSSPrivateKeyParameters)param;
            }
        }
        this.a.init(forSigning, param);
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        if (this.b == null) {
            throw new IllegalStateException("signing key no longer usable");
        }
        byte[] byArray = this.a.generateSignature(message);
        this.b = this.b.nextKey();
        return byArray;
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        return this.a.verifySignature(message, signature);
    }

    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this.b;
        this.b = null;
        return gMSSPrivateKeyParameters;
    }
}

