/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.crypto.mceliece;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.pqc.crypto.MessageEncryptor;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.mceliece.McElieceKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.mceliece.McEliecePrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.mceliece.McEliecePublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2Matrix;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2Vector;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2mField;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GoppaCode;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.Permutation;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.PolynomialGF2mSmallM;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.Vector;
import java.security.SecureRandom;

public class McElieceCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.1";
    private SecureRandom a;
    private int b;
    private int c;
    private int d;
    public int maxPlainTextSize;
    public int cipherTextSize;
    private McElieceKeyParameters e;
    private boolean f;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        this.f = forEncryption;
        if (forEncryption) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
                this.a = parametersWithRandom.getRandom();
                this.e = (McEliecePublicKeyParameters)parametersWithRandom.getParameters();
                this.a((McEliecePublicKeyParameters)this.e);
            } else {
                this.a = CryptoServicesRegistrar.getSecureRandom();
                this.e = (McEliecePublicKeyParameters)param;
                this.a((McEliecePublicKeyParameters)this.e);
            }
        } else {
            this.e = (McEliecePrivateKeyParameters)param;
            this.a((McEliecePrivateKeyParameters)this.e);
        }
    }

    public int getKeySize(McElieceKeyParameters key) {
        if (key instanceof McEliecePublicKeyParameters) {
            return ((McEliecePublicKeyParameters)key).getN();
        }
        if (key instanceof McEliecePrivateKeyParameters) {
            return ((McEliecePrivateKeyParameters)key).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    private void a(McEliecePublicKeyParameters mcEliecePublicKeyParameters) {
        this.b = mcEliecePublicKeyParameters.getN();
        this.c = mcEliecePublicKeyParameters.getK();
        this.d = mcEliecePublicKeyParameters.getT();
        this.cipherTextSize = this.b >> 3;
        this.maxPlainTextSize = this.c >> 3;
    }

    private void a(McEliecePrivateKeyParameters mcEliecePrivateKeyParameters) {
        this.b = mcEliecePrivateKeyParameters.getN();
        this.c = mcEliecePrivateKeyParameters.getK();
        this.maxPlainTextSize = this.c >> 3;
        this.cipherTextSize = this.b >> 3;
    }

    @Override
    public byte[] messageEncrypt(byte[] input) {
        if (!this.f) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        GF2Vector gF2Vector = this.a(input);
        GF2Vector gF2Vector2 = new GF2Vector(this.b, this.d, this.a);
        GF2Matrix gF2Matrix = ((McEliecePublicKeyParameters)this.e).getG();
        Vector vector = gF2Matrix.leftMultiply(gF2Vector);
        GF2Vector gF2Vector3 = (GF2Vector)vector.add(gF2Vector2);
        return gF2Vector3.getEncoded();
    }

    private GF2Vector a(byte[] byArray) {
        byte[] byArray2 = new byte[this.maxPlainTextSize + ((this.c & 7) != 0 ? 1 : 0)];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = 1;
        return GF2Vector.OS2VP(this.c, byArray2);
    }

    @Override
    public byte[] messageDecrypt(byte[] input) throws InvalidCipherTextException {
        if (this.f) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        GF2Vector gF2Vector = GF2Vector.OS2VP(this.b, input);
        McEliecePrivateKeyParameters mcEliecePrivateKeyParameters = (McEliecePrivateKeyParameters)this.e;
        GF2mField gF2mField = mcEliecePrivateKeyParameters.getField();
        PolynomialGF2mSmallM polynomialGF2mSmallM = mcEliecePrivateKeyParameters.getGoppaPoly();
        GF2Matrix gF2Matrix = mcEliecePrivateKeyParameters.getSInv();
        Permutation permutation = mcEliecePrivateKeyParameters.getP1();
        Permutation permutation2 = mcEliecePrivateKeyParameters.getP2();
        GF2Matrix gF2Matrix2 = mcEliecePrivateKeyParameters.getH();
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = mcEliecePrivateKeyParameters.getQInv();
        Permutation permutation3 = permutation.rightMultiply(permutation2);
        Permutation permutation4 = permutation3.computeInverse();
        GF2Vector gF2Vector2 = (GF2Vector)gF2Vector.multiply(permutation4);
        GF2Vector gF2Vector3 = (GF2Vector)gF2Matrix2.rightMultiply(gF2Vector2);
        GF2Vector gF2Vector4 = GoppaCode.syndromeDecode(gF2Vector3, gF2mField, polynomialGF2mSmallM, polynomialGF2mSmallMArray);
        GF2Vector gF2Vector5 = (GF2Vector)gF2Vector2.add(gF2Vector4);
        gF2Vector5 = (GF2Vector)gF2Vector5.multiply(permutation);
        gF2Vector4 = (GF2Vector)gF2Vector4.multiply(permutation3);
        GF2Vector gF2Vector6 = gF2Vector5.extractRightVector(this.c);
        GF2Vector gF2Vector7 = (GF2Vector)gF2Matrix.leftMultiply(gF2Vector6);
        return this.a(gF2Vector7);
    }

    private byte[] a(GF2Vector gF2Vector) throws InvalidCipherTextException {
        int n2;
        byte[] byArray = gF2Vector.getEncoded();
        for (n2 = byArray.length - 1; n2 >= 0 && byArray[n2] == 0; --n2) {
        }
        if (n2 < 0 || byArray[n2] != 1) {
            throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }
}

