/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.crypto.ntru;

import com.enterprisedt.bouncycastle.pqc.legacy.crypto.ntru.NTRUEncryptionKeyParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.ntru.NTRUEncryptionParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.IntegerPolynomial;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NTRUEncryptionPublicKeyParameters
extends NTRUEncryptionKeyParameters {
    public IntegerPolynomial h;

    public NTRUEncryptionPublicKeyParameters(IntegerPolynomial h2, NTRUEncryptionParameters params) {
        super(false, params);
        this.h = h2;
    }

    public NTRUEncryptionPublicKeyParameters(byte[] b2, NTRUEncryptionParameters params) {
        super(false, params);
        this.h = IntegerPolynomial.fromBinary(b2, params.N, params.q);
    }

    public NTRUEncryptionPublicKeyParameters(InputStream is, NTRUEncryptionParameters params) throws IOException {
        super(false, params);
        this.h = IntegerPolynomial.fromBinary(is, params.N, params.q);
    }

    public byte[] getEncoded() {
        return this.h.toBinary(this.params.q);
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.getEncoded());
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.h == null ? 0 : this.h.hashCode());
        n3 = 31 * n3 + (this.params == null ? 0 : this.params.hashCode());
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NTRUEncryptionPublicKeyParameters)) {
            return false;
        }
        NTRUEncryptionPublicKeyParameters nTRUEncryptionPublicKeyParameters = (NTRUEncryptionPublicKeyParameters)obj;
        if (this.h == null ? nTRUEncryptionPublicKeyParameters.h != null : !this.h.equals(nTRUEncryptionPublicKeyParameters.h)) {
            return false;
        }
        return !(this.params == null ? nTRUEncryptionPublicKeyParameters.params != null : !this.params.equals(nTRUEncryptionPublicKeyParameters.params));
    }
}

