/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.crypto.ntru;

import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.digests.SHA256Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA512Digest;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.ntru.NTRUSigningParameters;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;

public class NTRUSigningKeyGenerationParameters
extends KeyGenerationParameters
implements Cloneable {
    public static final int BASIS_TYPE_STANDARD = 0;
    public static final int BASIS_TYPE_TRANSPOSE = 1;
    public static final int KEY_GEN_ALG_RESULTANT = 0;
    public static final int KEY_GEN_ALG_FLOAT = 1;
    public static final NTRUSigningKeyGenerationParameters APR2011_439 = new NTRUSigningKeyGenerationParameters(439, 2048, 146, 1, 1, 0.165, 490.0, 280.0, false, true, 0, new SHA256Digest());
    public static final NTRUSigningKeyGenerationParameters APR2011_439_PROD = new NTRUSigningKeyGenerationParameters(439, 2048, 9, 8, 5, 1, 1, 0.165, 490.0, 280.0, false, true, 0, new SHA256Digest());
    public static final NTRUSigningKeyGenerationParameters APR2011_743 = new NTRUSigningKeyGenerationParameters(743, 2048, 248, 1, 1, 0.127, 560.0, 360.0, true, false, 0, new SHA512Digest());
    public static final NTRUSigningKeyGenerationParameters APR2011_743_PROD = new NTRUSigningKeyGenerationParameters(743, 2048, 11, 11, 15, 1, 1, 0.127, 560.0, 360.0, true, false, 0, new SHA512Digest());
    public static final NTRUSigningKeyGenerationParameters TEST157 = new NTRUSigningKeyGenerationParameters(157, 256, 29, 1, 1, 0.38, 200.0, 80.0, false, false, 0, new SHA256Digest());
    public static final NTRUSigningKeyGenerationParameters TEST157_PROD = new NTRUSigningKeyGenerationParameters(157, 256, 5, 5, 8, 1, 1, 0.38, 200.0, 80.0, false, false, 0, new SHA256Digest());
    public int N;
    public int q;
    public int d;
    public int d1;
    public int d2;
    public int d3;
    public int B;
    double a;
    public double betaSq;
    double b;
    public double normBoundSq;
    public int signFailTolerance = 100;
    double c;
    public double keyNormBoundSq;
    public boolean primeCheck;
    public int basisType;
    int e = 6;
    public boolean sparse;
    public int keyGenAlg;
    public Digest hashAlg;
    public int polyType;

    public NTRUSigningKeyGenerationParameters(int N, int q2, int d2, int B, int basisType, double beta, double normBound, double keyNormBound, boolean primeCheck, boolean sparse, int keyGenAlg, Digest hashAlg) {
        super(CryptoServicesRegistrar.getSecureRandom(), N);
        this.N = N;
        this.q = q2;
        this.d = d2;
        this.B = B;
        this.basisType = basisType;
        this.a = beta;
        this.b = normBound;
        this.c = keyNormBound;
        this.primeCheck = primeCheck;
        this.sparse = sparse;
        this.keyGenAlg = keyGenAlg;
        this.hashAlg = hashAlg;
        this.polyType = 0;
        this.a();
    }

    public NTRUSigningKeyGenerationParameters(int N, int q2, int d1, int d2, int d3, int B, int basisType, double beta, double normBound, double keyNormBound, boolean primeCheck, boolean sparse, int keyGenAlg, Digest hashAlg) {
        super(CryptoServicesRegistrar.getSecureRandom(), N);
        this.N = N;
        this.q = q2;
        this.d1 = d1;
        this.d2 = d2;
        this.d3 = d3;
        this.B = B;
        this.basisType = basisType;
        this.a = beta;
        this.b = normBound;
        this.c = keyNormBound;
        this.primeCheck = primeCheck;
        this.sparse = sparse;
        this.keyGenAlg = keyGenAlg;
        this.hashAlg = hashAlg;
        this.polyType = 1;
        this.a();
    }

    private void a() {
        this.betaSq = this.a * this.a;
        this.normBoundSq = this.b * this.b;
        this.keyNormBoundSq = this.c * this.c;
    }

    public NTRUSigningKeyGenerationParameters(InputStream is) throws IOException {
        super(CryptoServicesRegistrar.getSecureRandom(), 0);
        DataInputStream dataInputStream = new DataInputStream(is);
        this.N = dataInputStream.readInt();
        this.q = dataInputStream.readInt();
        this.d = dataInputStream.readInt();
        this.d1 = dataInputStream.readInt();
        this.d2 = dataInputStream.readInt();
        this.d3 = dataInputStream.readInt();
        this.B = dataInputStream.readInt();
        this.basisType = dataInputStream.readInt();
        this.a = dataInputStream.readDouble();
        this.b = dataInputStream.readDouble();
        this.c = dataInputStream.readDouble();
        this.signFailTolerance = dataInputStream.readInt();
        this.primeCheck = dataInputStream.readBoolean();
        this.sparse = dataInputStream.readBoolean();
        this.e = dataInputStream.readInt();
        this.keyGenAlg = dataInputStream.read();
        String string = dataInputStream.readUTF();
        if ("SHA-512".equals(string)) {
            this.hashAlg = new SHA512Digest();
        } else if ("SHA-256".equals(string)) {
            this.hashAlg = new SHA256Digest();
        }
        this.polyType = dataInputStream.read();
        this.a();
    }

    public void writeTo(OutputStream os) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(os);
        dataOutputStream.writeInt(this.N);
        dataOutputStream.writeInt(this.q);
        dataOutputStream.writeInt(this.d);
        dataOutputStream.writeInt(this.d1);
        dataOutputStream.writeInt(this.d2);
        dataOutputStream.writeInt(this.d3);
        dataOutputStream.writeInt(this.B);
        dataOutputStream.writeInt(this.basisType);
        dataOutputStream.writeDouble(this.a);
        dataOutputStream.writeDouble(this.b);
        dataOutputStream.writeDouble(this.c);
        dataOutputStream.writeInt(this.signFailTolerance);
        dataOutputStream.writeBoolean(this.primeCheck);
        dataOutputStream.writeBoolean(this.sparse);
        dataOutputStream.writeInt(this.e);
        dataOutputStream.write(this.keyGenAlg);
        dataOutputStream.writeUTF(this.hashAlg.getAlgorithmName());
        dataOutputStream.write(this.polyType);
    }

    public NTRUSigningParameters getSigningParameters() {
        return new NTRUSigningParameters(this.N, this.q, this.d, this.B, this.a, this.b, this.hashAlg);
    }

    public NTRUSigningKeyGenerationParameters clone() {
        if (this.polyType == 0) {
            return new NTRUSigningKeyGenerationParameters(this.N, this.q, this.d, this.B, this.basisType, this.a, this.b, this.c, this.primeCheck, this.sparse, this.keyGenAlg, this.hashAlg);
        }
        return new NTRUSigningKeyGenerationParameters(this.N, this.q, this.d1, this.d2, this.d3, this.B, this.basisType, this.a, this.b, this.c, this.primeCheck, this.sparse, this.keyGenAlg, this.hashAlg);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.B;
        n3 = 31 * n3 + this.N;
        n3 = 31 * n3 + this.basisType;
        long l2 = Double.doubleToLongBits(this.a);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.betaSq);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        n3 = 31 * n3 + this.e;
        n3 = 31 * n3 + this.d;
        n3 = 31 * n3 + this.d1;
        n3 = 31 * n3 + this.d2;
        n3 = 31 * n3 + this.d3;
        n3 = 31 * n3 + (this.hashAlg == null ? 0 : this.hashAlg.getAlgorithmName().hashCode());
        n3 = 31 * n3 + this.keyGenAlg;
        l2 = Double.doubleToLongBits(this.c);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.keyNormBoundSq);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.b);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.normBoundSq);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        n3 = 31 * n3 + this.polyType;
        n3 = 31 * n3 + (this.primeCheck ? 1231 : 1237);
        n3 = 31 * n3 + this.q;
        n3 = 31 * n3 + this.signFailTolerance;
        n3 = 31 * n3 + (this.sparse ? 1231 : 1237);
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NTRUSigningKeyGenerationParameters)) {
            return false;
        }
        NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = (NTRUSigningKeyGenerationParameters)obj;
        if (this.B != nTRUSigningKeyGenerationParameters.B) {
            return false;
        }
        if (this.N != nTRUSigningKeyGenerationParameters.N) {
            return false;
        }
        if (this.basisType != nTRUSigningKeyGenerationParameters.basisType) {
            return false;
        }
        if (Double.doubleToLongBits(this.a) != Double.doubleToLongBits(nTRUSigningKeyGenerationParameters.a)) {
            return false;
        }
        if (Double.doubleToLongBits(this.betaSq) != Double.doubleToLongBits(nTRUSigningKeyGenerationParameters.betaSq)) {
            return false;
        }
        if (this.e != nTRUSigningKeyGenerationParameters.e) {
            return false;
        }
        if (this.d != nTRUSigningKeyGenerationParameters.d) {
            return false;
        }
        if (this.d1 != nTRUSigningKeyGenerationParameters.d1) {
            return false;
        }
        if (this.d2 != nTRUSigningKeyGenerationParameters.d2) {
            return false;
        }
        if (this.d3 != nTRUSigningKeyGenerationParameters.d3) {
            return false;
        }
        if (this.hashAlg == null ? nTRUSigningKeyGenerationParameters.hashAlg != null : !this.hashAlg.getAlgorithmName().equals(nTRUSigningKeyGenerationParameters.hashAlg.getAlgorithmName())) {
            return false;
        }
        if (this.keyGenAlg != nTRUSigningKeyGenerationParameters.keyGenAlg) {
            return false;
        }
        if (Double.doubleToLongBits(this.c) != Double.doubleToLongBits(nTRUSigningKeyGenerationParameters.c)) {
            return false;
        }
        if (Double.doubleToLongBits(this.keyNormBoundSq) != Double.doubleToLongBits(nTRUSigningKeyGenerationParameters.keyNormBoundSq)) {
            return false;
        }
        if (Double.doubleToLongBits(this.b) != Double.doubleToLongBits(nTRUSigningKeyGenerationParameters.b)) {
            return false;
        }
        if (Double.doubleToLongBits(this.normBoundSq) != Double.doubleToLongBits(nTRUSigningKeyGenerationParameters.normBoundSq)) {
            return false;
        }
        if (this.polyType != nTRUSigningKeyGenerationParameters.polyType) {
            return false;
        }
        if (this.primeCheck != nTRUSigningKeyGenerationParameters.primeCheck) {
            return false;
        }
        if (this.q != nTRUSigningKeyGenerationParameters.q) {
            return false;
        }
        if (this.signFailTolerance != nTRUSigningKeyGenerationParameters.signFailTolerance) {
            return false;
        }
        return this.sparse == nTRUSigningKeyGenerationParameters.sparse;
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        StringBuilder stringBuilder = new StringBuilder("SignatureParameters(N=" + this.N + " q=" + this.q);
        if (this.polyType == 0) {
            stringBuilder.append(" polyType=SIMPLE d=" + this.d);
        } else {
            stringBuilder.append(" polyType=PRODUCT d1=" + this.d1 + " d2=" + this.d2 + " d3=" + this.d3);
        }
        stringBuilder.append(" B=" + this.B + " basisType=" + this.basisType + " beta=" + decimalFormat.format(this.a) + " normBound=" + decimalFormat.format(this.b) + " keyNormBound=" + decimalFormat.format(this.c) + " prime=" + this.primeCheck + " sparse=" + this.sparse + " keyGenAlg=" + this.keyGenAlg + " hashAlg=" + this.hashAlg + ")");
        return stringBuilder.toString();
    }
}

