/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.crypto.ntru;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.legacy.crypto.ntru.NTRUSigningParameters;
import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.IntegerPolynomial;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NTRUSigningPublicKeyParameters
extends AsymmetricKeyParameter {
    private NTRUSigningParameters b;
    public IntegerPolynomial h;

    public NTRUSigningPublicKeyParameters(IntegerPolynomial h2, NTRUSigningParameters params) {
        super(false);
        this.h = h2;
        this.b = params;
    }

    public NTRUSigningPublicKeyParameters(byte[] b2, NTRUSigningParameters params) {
        super(false);
        this.h = IntegerPolynomial.fromBinary(b2, params.N, params.q);
        this.b = params;
    }

    public NTRUSigningPublicKeyParameters(InputStream is, NTRUSigningParameters params) throws IOException {
        super(false);
        this.h = IntegerPolynomial.fromBinary(is, params.N, params.q);
        this.b = params;
    }

    public byte[] getEncoded() {
        return this.h.toBinary(this.b.q);
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.getEncoded());
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.h == null ? 0 : this.h.hashCode());
        n3 = 31 * n3 + (this.b == null ? 0 : this.b.hashCode());
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters = (NTRUSigningPublicKeyParameters)obj;
        if (this.h == null ? nTRUSigningPublicKeyParameters.h != null : !this.h.equals(nTRUSigningPublicKeyParameters.h)) {
            return false;
        }
        return !(this.b == null ? nTRUSigningPublicKeyParameters.b != null : !this.b.equals(nTRUSigningPublicKeyParameters.b));
    }
}

