/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra;

import java.math.BigInteger;

public final class BigIntUtils {
    private BigIntUtils() {
    }

    public static boolean equals(BigInteger[] a2, BigInteger[] b2) {
        int n2 = 0;
        if (a2.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            n2 |= a2[i2].compareTo(b2[i2]);
        }
        return n2 == 0;
    }

    public static void fill(BigInteger[] array, BigInteger value) {
        for (int i2 = array.length - 1; i2 >= 0; --i2) {
            array[i2] = value;
        }
    }

    public static BigInteger[] subArray(BigInteger[] input, int start, int end) {
        BigInteger[] bigIntegerArray = new BigInteger[end - start];
        System.arraycopy(input, start, bigIntegerArray, 0, end - start);
        return bigIntegerArray;
    }

    public static int[] toIntArray(BigInteger[] input) {
        int[] nArray = new int[input.length];
        for (int i2 = 0; i2 < input.length; ++i2) {
            nArray[i2] = input[i2].intValue();
        }
        return nArray;
    }

    public static int[] toIntArrayModQ(int q2, BigInteger[] input) {
        BigInteger bigInteger = BigInteger.valueOf(q2);
        int[] nArray = new int[input.length];
        for (int i2 = 0; i2 < input.length; ++i2) {
            nArray[i2] = input[i2].mod(bigInteger).intValue();
        }
        return nArray;
    }

    public static byte[] toMinimalByteArray(BigInteger value) {
        byte[] byArray = value.toByteArray();
        if (byArray.length == 1 || (value.bitLength() & 7) != 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[value.bitLength() >> 3];
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        return byArray2;
    }
}

